/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RangeTombstoneList;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.ObjectSizes;

public class DeletionInfo
implements IMeasurableMemory {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new DeletionInfo(0L, 0));
    private DeletionTime topLevel;
    private RangeTombstoneList ranges;

    public DeletionInfo(long markedForDeleteAt, int localDeletionTime) {
        this(new DeletionTime(markedForDeleteAt, localDeletionTime == Integer.MIN_VALUE ? Integer.MAX_VALUE : localDeletionTime));
    }

    public DeletionInfo(DeletionTime topLevel) {
        this(topLevel, null);
    }

    public DeletionInfo(Composite start, Composite end, Comparator<Composite> comparator, long markedForDeleteAt, int localDeletionTime) {
        this(DeletionTime.LIVE, new RangeTombstoneList(comparator, 1));
        this.ranges.add(start, end, markedForDeleteAt, localDeletionTime);
    }

    public DeletionInfo(RangeTombstone rangeTombstone, Comparator<Composite> comparator) {
        this((Composite)rangeTombstone.min, (Composite)rangeTombstone.max, comparator, ((DeletionTime)rangeTombstone.data).markedForDeleteAt, ((DeletionTime)rangeTombstone.data).localDeletionTime);
    }

    private DeletionInfo(DeletionTime topLevel, RangeTombstoneList ranges) {
        this.topLevel = topLevel;
        this.ranges = ranges;
    }

    public static DeletionInfo live() {
        return new DeletionInfo(DeletionTime.LIVE);
    }

    public DeletionInfo copy() {
        return new DeletionInfo(this.topLevel, this.ranges == null ? null : this.ranges.copy());
    }

    public boolean isLive() {
        return this.topLevel.markedForDeleteAt == Long.MIN_VALUE && this.topLevel.localDeletionTime == Integer.MAX_VALUE && (this.ranges == null || this.ranges.isEmpty());
    }

    public boolean isDeleted(Cell cell) {
        return this.isDeleted(cell.name(), cell.timestamp());
    }

    public boolean isDeleted(Composite name, long timestamp) {
        if (this.isLive()) {
            return false;
        }
        if (timestamp <= this.topLevel.markedForDeleteAt) {
            return true;
        }
        return this.ranges != null && this.ranges.isDeleted(name, timestamp);
    }

    InOrderTester inOrderTester() {
        return this.inOrderTester(false);
    }

    public InOrderTester inOrderTester(boolean reversed) {
        return new InOrderTester(reversed);
    }

    public void purge(int gcBefore) {
        DeletionTime deletionTime = this.topLevel = this.topLevel.localDeletionTime < gcBefore ? DeletionTime.LIVE : this.topLevel;
        if (this.ranges != null) {
            this.ranges.purge(gcBefore);
            if (this.ranges.isEmpty()) {
                this.ranges = null;
            }
        }
    }

    public boolean hasPurgeableTombstones(int gcBefore) {
        if (this.topLevel.localDeletionTime < gcBefore) {
            return true;
        }
        return this.ranges != null && this.ranges.hasPurgeableTombstones(gcBefore);
    }

    public void add(DeletionTime newInfo) {
        if (this.topLevel.markedForDeleteAt < newInfo.markedForDeleteAt) {
            this.topLevel = newInfo;
        }
    }

    public void add(RangeTombstone tombstone, Comparator<Composite> comparator) {
        if (this.ranges == null) {
            this.ranges = new RangeTombstoneList(comparator, 1);
        }
        this.ranges.add(tombstone);
    }

    public DeletionInfo add(DeletionInfo newInfo) {
        this.add(newInfo.topLevel);
        if (this.ranges == null) {
            this.ranges = newInfo.ranges == null ? null : newInfo.ranges.copy();
        } else if (newInfo.ranges != null) {
            this.ranges.addAll(newInfo.ranges);
        }
        return this;
    }

    public long minTimestamp() {
        return this.ranges == null ? this.topLevel.markedForDeleteAt : Math.min(this.topLevel.markedForDeleteAt, this.ranges.minMarkedAt());
    }

    public long maxTimestamp() {
        return this.ranges == null ? this.topLevel.markedForDeleteAt : Math.max(this.topLevel.markedForDeleteAt, this.ranges.maxMarkedAt());
    }

    public DeletionTime getTopLevelDeletion() {
        return this.topLevel;
    }

    public Iterator<RangeTombstone> rangeIterator() {
        return this.ranges == null ? Iterators.emptyIterator() : this.ranges.iterator();
    }

    public DeletionTime rangeCovering(Composite name) {
        return this.ranges == null ? null : this.ranges.search(name);
    }

    public int dataSize() {
        int size = TypeSizes.NATIVE.sizeof(this.topLevel.markedForDeleteAt);
        return size + (this.ranges == null ? 0 : this.ranges.dataSize());
    }

    public boolean hasRanges() {
        return this.ranges != null && !this.ranges.isEmpty();
    }

    public int rangeCount() {
        return this.hasRanges() ? this.ranges.size() : 0;
    }

    public boolean mayModify(DeletionInfo delInfo) {
        return this.topLevel.markedForDeleteAt > delInfo.topLevel.markedForDeleteAt || this.hasRanges();
    }

    public String toString() {
        if (this.ranges == null || this.ranges.isEmpty()) {
            return String.format("{%s}", this.topLevel);
        }
        return String.format("{%s, ranges=%s}", this.topLevel, this.rangesAsString());
    }

    private String rangesAsString() {
        assert (!this.ranges.isEmpty());
        StringBuilder sb = new StringBuilder();
        CType type = (CType)this.ranges.comparator();
        assert (type != null);
        Iterator<RangeTombstone> iter = this.rangeIterator();
        while (iter.hasNext()) {
            RangeTombstone i = iter.next();
            sb.append("[");
            sb.append(type.getString((Composite)i.min)).append("-");
            sb.append(type.getString((Composite)i.max)).append(", ");
            sb.append(i.data);
            sb.append("]");
        }
        return sb.toString();
    }

    public void updateAllTimestamp(long timestamp) {
        if (this.topLevel.markedForDeleteAt != Long.MIN_VALUE) {
            this.topLevel = new DeletionTime(timestamp, this.topLevel.localDeletionTime);
        }
        if (this.ranges != null) {
            this.ranges.updateAllTimestamp(timestamp);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeletionInfo)) {
            return false;
        }
        DeletionInfo that = (DeletionInfo)o;
        return this.topLevel.equals(that.topLevel) && Objects.equal((Object)this.ranges, (Object)that.ranges);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.topLevel, this.ranges});
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + this.topLevel.unsharedHeapSize() + (this.ranges == null ? 0L : this.ranges.unsharedHeapSize());
    }

    public class InOrderTester {
        private RangeTombstoneList.InOrderTester tester;
        private final boolean reversed;

        private InOrderTester(boolean reversed) {
            this.reversed = reversed;
        }

        public boolean isDeleted(Cell cell) {
            return this.isDeleted(cell.name(), cell.timestamp());
        }

        public boolean isDeleted(Composite name, long timestamp) {
            if (timestamp <= ((DeletionInfo)DeletionInfo.this).topLevel.markedForDeleteAt) {
                return true;
            }
            if (this.reversed) {
                return DeletionInfo.this.isDeleted(name, timestamp);
            }
            if (this.tester == null && DeletionInfo.this.ranges != null) {
                this.tester = DeletionInfo.this.ranges.inOrderTester();
            }
            return this.tester != null && this.tester.isDeleted(name, timestamp);
        }
    }

    public static class Serializer
    implements IVersionedSerializer<DeletionInfo> {
        private final RangeTombstoneList.Serializer rtlSerializer;

        public Serializer(CType type) {
            this.rtlSerializer = new RangeTombstoneList.Serializer(type);
        }

        @Override
        public void serialize(DeletionInfo info, DataOutput out, int version) throws IOException {
            DeletionTime.serializer.serialize(info.topLevel, out);
            this.rtlSerializer.serialize(info.ranges, out, version);
        }

        @Override
        public DeletionInfo deserialize(DataInput in, int version) throws IOException {
            DeletionTime topLevel = DeletionTime.serializer.deserialize(in);
            RangeTombstoneList ranges = this.rtlSerializer.deserialize(in, version);
            return new DeletionInfo(topLevel, ranges);
        }

        public long serializedSize(DeletionInfo info, TypeSizes typeSizes, int version) {
            long size = DeletionTime.serializer.serializedSize(info.topLevel, typeSizes);
            return size + this.rtlSerializer.serializedSize(info.ranges, typeSizes, version);
        }

        @Override
        public long serializedSize(DeletionInfo info, int version) {
            return this.serializedSize(info, TypeSizes.NATIVE, version);
        }
    }
}

