/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class CounterUpdateCell
extends Cell {
    public CounterUpdateCell(CellName name, long value, long timestamp) {
        this(name, ByteBufferUtil.bytes(value), timestamp);
    }

    public CounterUpdateCell(CellName name, ByteBuffer value, long timestamp) {
        super(name, value, timestamp);
    }

    public long delta() {
        return this.value().getLong(this.value().position());
    }

    @Override
    public Cell diff(Cell cell) {
        throw new UnsupportedOperationException("This operation is unsupported on CounterUpdateCell.");
    }

    @Override
    public Cell reconcile(Cell cell, AbstractAllocator allocator) {
        if (cell.isMarkedForDelete(Long.MIN_VALUE)) {
            return this.timestamp() > cell.timestamp() ? this : cell;
        }
        assert (cell instanceof CounterUpdateCell) : "Wrong class type.";
        CounterUpdateCell c = (CounterUpdateCell)cell;
        return new CounterUpdateCell(this.name(), this.delta() + c.delta(), Math.max(this.timestamp(), c.timestamp()));
    }

    @Override
    public int serializationFlags() {
        return 8;
    }

    @Override
    public Cell localCopy(ColumnFamilyStore cfs, AbstractAllocator allocator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(CellNameType comparator) {
        return String.format("%s:%s@%d", comparator.getString(this.name), ByteBufferUtil.toLong(this.value), this.timestamp);
    }
}

