/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.AbstractIterator;
import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.ExpiringCell;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.HeapAllocator;

public class Cell
implements OnDiskAtom {
    public static final int MAX_NAME_LENGTH = 65535;
    private static final long EMPTY_SIZE = ObjectSizes.measure(new Cell(CellNames.simpleDense(ByteBuffer.allocate(1))));
    protected final CellName name;
    protected final ByteBuffer value;
    protected final long timestamp;

    public static Iterator<OnDiskAtom> onDiskIterator(final DataInput in, final int count, final ColumnSerializer.Flag flag, final int expireBefore, final Descriptor.Version version, final CellNameType type) {
        return new AbstractIterator<OnDiskAtom>(){
            int i = 0;

            protected OnDiskAtom computeNext() {
                OnDiskAtom atom;
                if (this.i++ >= count) {
                    return (OnDiskAtom)this.endOfData();
                }
                try {
                    atom = type.onDiskAtomSerializer().deserializeFromSSTable(in, flag, expireBefore, version);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
                if (atom == null) {
                    return (OnDiskAtom)this.endOfData();
                }
                return atom;
            }
        };
    }

    Cell(CellName name) {
        this(name, ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    public Cell(CellName name, ByteBuffer value) {
        this(name, value, 0L);
    }

    public Cell(CellName name, ByteBuffer value, long timestamp) {
        assert (name != null);
        assert (value != null);
        this.name = name;
        this.value = value;
        this.timestamp = timestamp;
    }

    public Cell withUpdatedName(CellName newName) {
        return new Cell(newName, this.value, this.timestamp);
    }

    public Cell withUpdatedTimestamp(long newTimestamp) {
        return new Cell(this.name, this.value, newTimestamp);
    }

    @Override
    public CellName name() {
        return this.name;
    }

    public ByteBuffer value() {
        return this.value;
    }

    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public long minTimestamp() {
        return this.timestamp;
    }

    @Override
    public long maxTimestamp() {
        return this.timestamp;
    }

    public boolean isMarkedForDelete(long now) {
        return false;
    }

    public boolean isLive(long now) {
        return !this.isMarkedForDelete(now);
    }

    public long getMarkedForDeleteAt() {
        return Long.MAX_VALUE;
    }

    public int dataSize() {
        return this.name.dataSize() + this.value.remaining() + TypeSizes.NATIVE.sizeof(this.timestamp);
    }

    public long excessHeapSizeExcludingData() {
        return EMPTY_SIZE + this.name.excessHeapSizeExcludingData() + ObjectSizes.sizeOnHeapExcludingData(this.value);
    }

    public int serializedSize(CellNameType type, TypeSizes typeSizes) {
        int valueSize = this.value.remaining();
        return (int)type.cellSerializer().serializedSize(this.name, typeSizes) + 1 + typeSizes.sizeof(this.timestamp) + typeSizes.sizeof(valueSize) + valueSize;
    }

    public int serializationFlags() {
        return 0;
    }

    public Cell diff(Cell cell) {
        if (this.timestamp() < cell.timestamp()) {
            return cell;
        }
        return null;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name.toByteBuffer().duplicate());
        digest.update(this.value.duplicate());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.timestamp);
            buffer.writeByte(this.serializationFlags());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    @Override
    public int getLocalDeletionTime() {
        return Integer.MAX_VALUE;
    }

    public Cell reconcile(Cell cell) {
        return this.reconcile(cell, HeapAllocator.instance);
    }

    public Cell reconcile(Cell cell, AbstractAllocator allocator) {
        if (this.isMarkedForDelete(System.currentTimeMillis())) {
            return this.timestamp() < cell.timestamp() ? cell : this;
        }
        if (cell.isMarkedForDelete(System.currentTimeMillis())) {
            return this.timestamp() > cell.timestamp() ? this : cell;
        }
        if (this.timestamp() == cell.timestamp()) {
            return this.value().compareTo(cell.value()) < 0 ? cell : this;
        }
        return this.timestamp() < cell.timestamp() ? cell : this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        return this.timestamp == cell.timestamp && this.name.equals(cell.name) && this.value.equals(cell.value);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public Cell localCopy(ColumnFamilyStore cfs, AbstractAllocator allocator) {
        return new Cell(this.name.copy(allocator), allocator.clone(this.value), this.timestamp);
    }

    public String getString(CellNameType comparator) {
        return String.format("%s:%b:%d@%d", comparator.getString(this.name), this.isMarkedForDelete(System.currentTimeMillis()), this.value.remaining(), this.timestamp);
    }

    protected void validateName(CFMetaData metadata) throws MarshalException {
        metadata.comparator.validate(this.name());
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        AbstractType<?> valueValidator = metadata.getValueValidator(this.name());
        if (valueValidator != null) {
            valueValidator.validate(this.value());
        }
    }

    public boolean hasIrrelevantData(int gcBefore) {
        return this.getLocalDeletionTime() < gcBefore;
    }

    public static Cell create(CellName name, ByteBuffer value, long timestamp, int ttl, CFMetaData metadata) {
        if (ttl <= 0) {
            ttl = metadata.getDefaultTimeToLive();
        }
        return ttl > 0 ? new ExpiringCell(name, value, timestamp, ttl) : new Cell(name, value, timestamp);
    }
}

