/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;

public class ArrayBackedSortedColumns
extends ColumnFamily {
    private static final Cell[] EMPTY_ARRAY = new Cell[0];
    private static final int MINIMAL_CAPACITY = 10;
    private final boolean reversed;
    private DeletionInfo deletionInfo;
    private Cell[] cells;
    private int size;
    private int sortedSize;
    public static final ColumnFamily.Factory<ArrayBackedSortedColumns> factory = new ColumnFamily.Factory<ArrayBackedSortedColumns>(){

        @Override
        public ArrayBackedSortedColumns create(CFMetaData metadata, boolean insertReversed) {
            return new ArrayBackedSortedColumns(metadata, insertReversed);
        }
    };

    private ArrayBackedSortedColumns(CFMetaData metadata, boolean reversed) {
        super(metadata);
        this.reversed = reversed;
        this.deletionInfo = DeletionInfo.live();
        this.cells = EMPTY_ARRAY;
        this.size = 0;
        this.sortedSize = 0;
    }

    private ArrayBackedSortedColumns(ArrayBackedSortedColumns original) {
        super(original.metadata);
        this.reversed = original.reversed;
        this.deletionInfo = DeletionInfo.live();
        this.cells = Arrays.copyOf(original.cells, original.size);
        this.size = original.size;
        this.sortedSize = original.sortedSize;
    }

    @Override
    public ColumnFamily.Factory getFactory() {
        return factory;
    }

    @Override
    public ColumnFamily cloneMe() {
        return new ArrayBackedSortedColumns(this);
    }

    @Override
    public boolean isInsertReversed() {
        return this.reversed;
    }

    private Comparator<Composite> internalComparator() {
        return this.reversed ? this.getComparator().reverseComparator() : this.getComparator();
    }

    private void maybeSortCells() {
        if (this.size != this.sortedSize) {
            this.sortCells();
        }
    }

    private void sortCells() {
        Comparator<Cell> comparator = this.reversed ? this.getComparator().columnReverseComparator() : this.getComparator().columnComparator();
        Arrays.sort(this.cells, this.sortedSize, this.size, comparator);
        int pos = this.binarySearch(0, this.sortedSize, this.cells[this.sortedSize].name, this.internalComparator());
        if (pos < 0) {
            pos = -pos - 1;
        }
        Cell[] leftCopy = pos == this.sortedSize ? EMPTY_ARRAY : Arrays.copyOfRange(this.cells, pos, this.sortedSize);
        int rightStart = this.sortedSize;
        int rightEnd = this.size;
        this.size = this.sortedSize = pos;
        int l = 0;
        int r = rightStart;
        while (l < leftCopy.length && r < rightEnd) {
            int cmp = comparator.compare(leftCopy[l], this.cells[r]);
            if (cmp < 0) {
                this.internalAppend(leftCopy[l++]);
                continue;
            }
            if (cmp == 0) {
                this.internalAppend(leftCopy[l++].reconcile(this.cells[r++]));
                continue;
            }
            this.internalAppendOrReconcile(this.cells[r++]);
        }
        while (l < leftCopy.length) {
            this.internalAppend(leftCopy[l++]);
        }
        while (r < rightEnd) {
            this.internalAppendOrReconcile(this.cells[r++]);
        }
        for (int i = this.size; i < rightEnd; ++i) {
            this.cells[i] = null;
        }
    }

    @Override
    public Cell getColumn(CellName name) {
        this.maybeSortCells();
        int pos = this.binarySearch(name);
        return pos >= 0 ? this.cells[pos] : null;
    }

    @Override
    public void addColumn(Cell cell) {
        if (this.size == 0) {
            this.internalAdd(cell);
            ++this.sortedSize;
            return;
        }
        if (this.size != this.sortedSize) {
            this.internalAdd(cell);
            return;
        }
        int c = this.internalComparator().compare(this.cells[this.size - 1].name(), cell.name());
        if (c < 0) {
            this.internalAdd(cell);
            ++this.sortedSize;
        } else if (c == 0) {
            this.reconcileWith(this.size - 1, cell);
        } else {
            int pos = this.binarySearch(cell.name());
            if (pos >= 0) {
                this.reconcileWith(pos, cell);
            } else {
                this.internalAdd(cell);
            }
        }
    }

    @Override
    public void addAll(ColumnFamily other) {
        Iterator<Cell> iterator;
        this.delete(other.deletionInfo());
        if (other.getColumnCount() == 0) {
            return;
        }
        Iterator<Cell> iterator2 = iterator = this.reversed ? other.reverseIterator() : other.iterator();
        while (iterator.hasNext()) {
            this.addColumn(iterator.next());
        }
    }

    private void internalAdd(Cell cell) {
        if (this.cells == EMPTY_ARRAY) {
            this.cells = new Cell[10];
        } else if (this.cells.length == this.size) {
            this.cells = Arrays.copyOf(this.cells, this.size * 3 / 2 + 1);
        }
        this.cells[this.size++] = cell;
    }

    private void internalAppendOrReconcile(Cell cell) {
        if (this.size > 0 && this.cells[this.size - 1].name().equals(cell.name())) {
            this.reconcileWith(this.size - 1, cell);
        } else {
            this.internalAppend(cell);
        }
    }

    private void internalAppend(Cell cell) {
        this.cells[this.size] = cell;
        ++this.size;
        ++this.sortedSize;
    }

    private void internalRemove(int index) {
        int moving = this.size - index - 1;
        if (moving > 0) {
            System.arraycopy(this.cells, index + 1, this.cells, index, moving);
        }
        this.cells[--this.size] = null;
    }

    private void reconcileWith(int i, Cell cell) {
        this.cells[i] = cell.reconcile(this.cells[i]);
    }

    private int binarySearch(CellName name) {
        return this.binarySearch(0, this.size, name, this.internalComparator());
    }

    private int binarySearch(int fromIndex, int toIndex, Composite name, Comparator<Composite> comparator) {
        int low = fromIndex;
        int mid = toIndex;
        int high = mid - 1;
        int result = -1;
        while (low <= high) {
            mid = low + high >> 1;
            result = comparator.compare(name, this.cells[mid].name());
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result < 0 ? 1 : 2);
    }

    @Override
    public Collection<Cell> getSortedColumns() {
        this.maybeSortCells();
        return this.reversed ? new ReverseSortedCollection() : new ForwardSortedCollection();
    }

    @Override
    public Collection<Cell> getReverseSortedColumns() {
        this.maybeSortCells();
        return this.reversed ? new ForwardSortedCollection() : new ReverseSortedCollection();
    }

    @Override
    public int getColumnCount() {
        this.maybeSortCells();
        return this.size;
    }

    @Override
    public void clear() {
        this.setDeletionInfo(DeletionInfo.live());
        for (int i = 0; i < this.size; ++i) {
            this.cells[i] = null;
        }
        this.sortedSize = 0;
        this.size = 0;
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.deletionInfo;
    }

    @Override
    public void delete(DeletionTime delTime) {
        this.deletionInfo.add(delTime);
    }

    @Override
    public void delete(DeletionInfo newInfo) {
        this.deletionInfo.add(newInfo);
    }

    @Override
    protected void delete(RangeTombstone tombstone) {
        this.deletionInfo.add(tombstone, this.getComparator());
    }

    @Override
    public void setDeletionInfo(DeletionInfo newInfo) {
        this.deletionInfo = newInfo;
    }

    @Override
    public void purgeTombstones(int gcBefore) {
        this.deletionInfo.purge(gcBefore);
    }

    @Override
    public Iterable<CellName> getColumnNames() {
        this.maybeSortCells();
        return Iterables.transform((Iterable)new ForwardSortedCollection(), (Function)new Function<Cell, CellName>(){

            public CellName apply(Cell cell) {
                return cell.name;
            }
        });
    }

    @Override
    public Iterator<Cell> iterator(ColumnSlice[] slices) {
        this.maybeSortCells();
        return new SlicesIterator(Arrays.asList(this.cells).subList(0, this.size), this.getComparator(), slices, this.reversed);
    }

    @Override
    public Iterator<Cell> reverseIterator(ColumnSlice[] slices) {
        this.maybeSortCells();
        return new SlicesIterator(Arrays.asList(this.cells).subList(0, this.size), this.getComparator(), slices, !this.reversed);
    }

    private class ForwardSortedCollection
    extends AbstractCollection<Cell> {
        private ForwardSortedCollection() {
        }

        @Override
        public int size() {
            return ArrayBackedSortedColumns.this.size;
        }

        @Override
        public Iterator<Cell> iterator() {
            return new Iterator<Cell>(){
                int idx = 0;
                boolean shouldCallNext = true;

                @Override
                public boolean hasNext() {
                    return this.idx < ArrayBackedSortedColumns.this.size;
                }

                @Override
                public Cell next() {
                    this.shouldCallNext = false;
                    return ArrayBackedSortedColumns.this.cells[this.idx++];
                }

                @Override
                public void remove() {
                    if (this.shouldCallNext) {
                        throw new IllegalStateException();
                    }
                    ArrayBackedSortedColumns.this.internalRemove(--this.idx);
                    this.shouldCallNext = true;
                    ArrayBackedSortedColumns.this.sortedSize--;
                }
            };
        }
    }

    private class ReverseSortedCollection
    extends AbstractCollection<Cell> {
        private ReverseSortedCollection() {
        }

        @Override
        public int size() {
            return ArrayBackedSortedColumns.this.size;
        }

        @Override
        public Iterator<Cell> iterator() {
            return new Iterator<Cell>(){
                int idx;
                boolean shouldCallNext;
                {
                    this.idx = ArrayBackedSortedColumns.this.size - 1;
                    this.shouldCallNext = true;
                }

                @Override
                public boolean hasNext() {
                    return this.idx >= 0;
                }

                @Override
                public Cell next() {
                    this.shouldCallNext = false;
                    return ArrayBackedSortedColumns.this.cells[this.idx--];
                }

                @Override
                public void remove() {
                    if (this.shouldCallNext) {
                        throw new IllegalStateException();
                    }
                    ArrayBackedSortedColumns.this.internalRemove(this.idx + 1);
                    this.shouldCallNext = true;
                    ArrayBackedSortedColumns.this.sortedSize--;
                }
            };
        }
    }

    private static class SlicesIterator
    extends AbstractIterator<Cell> {
        private final List<Cell> cells;
        private final ColumnSlice[] slices;
        private final Comparator<Composite> comparator;
        private int idx = 0;
        private int previousSliceEnd = 0;
        private Iterator<Cell> currentSlice;

        public SlicesIterator(List<Cell> cells, CellNameType comparator, ColumnSlice[] slices, boolean reversed) {
            this.cells = reversed ? Lists.reverse(cells) : cells;
            this.slices = slices;
            this.comparator = reversed ? comparator.reverseComparator() : comparator;
        }

        protected Cell computeNext() {
            if (this.currentSlice == null) {
                int finishIdx;
                int startIdx;
                if (this.idx >= this.slices.length) {
                    return (Cell)this.endOfData();
                }
                ColumnSlice slice = this.slices[this.idx++];
                int n = startIdx = slice.start.isEmpty() ? 0 : this.binarySearch(this.previousSliceEnd, slice.start);
                if (startIdx < 0) {
                    startIdx = -startIdx - 1;
                }
                int n2 = finishIdx = slice.finish.isEmpty() ? this.cells.size() - 1 : this.binarySearch(this.previousSliceEnd, slice.finish);
                finishIdx = finishIdx >= 0 ? ++finishIdx : -finishIdx - 1;
                this.currentSlice = startIdx == 0 && finishIdx == this.cells.size() ? this.cells.iterator() : this.cells.subList(startIdx, finishIdx).iterator();
                int n3 = this.previousSliceEnd = finishIdx > 0 ? finishIdx - 1 : 0;
            }
            if (this.currentSlice.hasNext()) {
                return this.currentSlice.next();
            }
            this.currentSlice = null;
            return this.computeNext();
        }

        private int binarySearch(int fromIndex, Composite name) {
            int low = fromIndex;
            int mid = this.cells.size();
            int high = mid - 1;
            int result = -1;
            while (low <= high) {
                mid = low + high >> 1;
                result = this.comparator.compare(name, this.cells.get(mid).name());
                if (result > 0) {
                    low = mid + 1;
                    continue;
                }
                if (result == 0) {
                    return mid;
                }
                high = mid - 1;
            }
            return -mid - (result < 0 ? 1 : 2);
        }
    }
}

