/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class UpdateStatement
extends ModificationStatement {
    private static final Constants.Value EMPTY = new Constants.Value(ByteBufferUtil.EMPTY_BYTE_BUFFER);

    private UpdateStatement(int boundTerms, CFMetaData cfm, Attributes attrs) {
        super(boundTerms, cfm, attrs);
    }

    @Override
    public boolean requireFullClusteringKey() {
        return true;
    }

    public void addUpdateForKey(ColumnFamily cf, ByteBuffer key, Composite prefix, UpdateParameters params) throws InvalidRequestException {
        if (this.cfm.isCQL3Table()) {
            cf.addColumn(params.makeColumn(this.cfm.comparator.rowMarker(prefix), ByteBufferUtil.EMPTY_BYTE_BUFFER));
        }
        List<Operation> updates = this.getOperations();
        if (this.cfm.comparator.isDense()) {
            if (prefix.isEmpty()) {
                throw new InvalidRequestException(String.format("Missing PRIMARY KEY part %s", this.cfm.clusteringColumns().iterator().next()));
            }
            if (!this.cfm.compactValueColumn().name.bytes.hasRemaining()) {
                assert (updates.isEmpty());
                new Constants.Setter(this.cfm.compactValueColumn(), EMPTY).execute(key, cf, prefix, params);
            } else {
                if (updates.isEmpty()) {
                    throw new InvalidRequestException(String.format("Column %s is mandatory for this COMPACT STORAGE table", this.cfm.compactValueColumn().name));
                }
                for (Operation update : updates) {
                    update.execute(key, cf, prefix, params);
                }
            }
        } else {
            for (Operation update : updates) {
                update.execute(key, cf, prefix, params);
            }
        }
    }

    @Override
    public ColumnFamily updateForKey(ByteBuffer key, Composite prefix, UpdateParameters params) throws InvalidRequestException {
        ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(this.cfm);
        this.addUpdateForKey(cf, key, prefix, params);
        return cf;
    }

    public static class ParsedUpdate
    extends ModificationStatement.Parsed {
        private final List<Pair<ColumnIdentifier, Operation.RawUpdate>> updates;
        private final List<Relation> whereClause;

        public ParsedUpdate(CFName name, Attributes.Raw attrs, List<Pair<ColumnIdentifier, Operation.RawUpdate>> updates, List<Relation> whereClause, List<Pair<ColumnIdentifier, Operation.RawUpdate>> conditions) {
            super(name, attrs, conditions, false);
            this.updates = updates;
            this.whereClause = whereClause;
        }

        @Override
        protected ModificationStatement prepareInternal(CFMetaData cfm, VariableSpecifications boundNames, Attributes attrs) throws InvalidRequestException {
            UpdateStatement stmt = new UpdateStatement(boundNames.size(), cfm, attrs);
            for (Pair<ColumnIdentifier, Operation.RawUpdate> entry : this.updates) {
                ColumnDefinition def = cfm.getColumnDefinition((ColumnIdentifier)entry.left);
                if (def == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", entry.left));
                }
                Operation operation = ((Operation.RawUpdate)entry.right).prepare(this.keyspace(), def);
                operation.collectMarkerSpecification(boundNames);
                switch (def.kind) {
                    case PARTITION_KEY: 
                    case CLUSTERING_COLUMN: {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s found in SET part", entry.left));
                    }
                    case COMPACT_VALUE: 
                    case REGULAR: {
                        stmt.addOperation(operation);
                    }
                }
            }
            stmt.processWhereClause(this.whereClause, boundNames);
            return stmt;
        }
    }

    public static class ParsedInsert
    extends ModificationStatement.Parsed {
        private final List<ColumnIdentifier> columnNames;
        private final List<Term.Raw> columnValues;

        public ParsedInsert(CFName name, Attributes.Raw attrs, List<ColumnIdentifier> columnNames, List<Term.Raw> columnValues, boolean ifNotExists) {
            super(name, attrs, null, ifNotExists);
            this.columnNames = columnNames;
            this.columnValues = columnValues;
        }

        @Override
        protected ModificationStatement prepareInternal(CFMetaData cfm, VariableSpecifications boundNames, Attributes attrs) throws InvalidRequestException {
            UpdateStatement stmt = new UpdateStatement(boundNames.size(), cfm, attrs);
            if (stmt.isCounter()) {
                throw new InvalidRequestException("INSERT statement are not allowed on counter tables, use UPDATE instead");
            }
            if (this.columnNames.size() != this.columnValues.size()) {
                throw new InvalidRequestException("Unmatched column names/values");
            }
            if (this.columnNames.isEmpty()) {
                throw new InvalidRequestException("No columns provided to INSERT");
            }
            block4: for (int i = 0; i < this.columnNames.size(); ++i) {
                ColumnDefinition def = cfm.getColumnDefinition(this.columnNames.get(i));
                if (def == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", this.columnNames.get(i)));
                }
                for (int j = 0; j < i; ++j) {
                    if (!def.name.equals(this.columnNames.get(j))) continue;
                    throw new InvalidRequestException(String.format("Multiple definitions found for column %s", def.name));
                }
                Term.Raw value = this.columnValues.get(i);
                switch (def.kind) {
                    case PARTITION_KEY: 
                    case CLUSTERING_COLUMN: {
                        Term t = value.prepare(this.keyspace(), def);
                        t.collectMarkerSpecification(boundNames);
                        stmt.addKeyValue(def.name, t);
                        continue block4;
                    }
                    case COMPACT_VALUE: 
                    case REGULAR: {
                        Operation operation = new Operation.SetValue(value).prepare(this.keyspace(), def);
                        operation.collectMarkerSpecification(boundNames);
                        stmt.addOperation(operation);
                    }
                }
            }
            return stmt;
        }
    }
}

