/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.Functions;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public class FunctionCall
extends Term.NonTerminal {
    private final Function fun;
    private final List<Term> terms;

    private FunctionCall(Function fun, List<Term> terms) {
        this.fun = fun;
        this.terms = terms;
    }

    @Override
    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        for (Term t : this.terms) {
            t.collectMarkerSpecification(boundNames);
        }
    }

    @Override
    public Term.Terminal bind(List<ByteBuffer> values) throws InvalidRequestException {
        return FunctionCall.makeTerminal(this.fun, this.bindAndGet(values));
    }

    @Override
    public ByteBuffer bindAndGet(List<ByteBuffer> values) throws InvalidRequestException {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.terms.size());
        for (Term t : this.terms) {
            ByteBuffer val = t.bindAndGet(values);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null value for argument to %s", this.fun));
            }
            buffers.add(val);
        }
        return this.fun.execute(buffers);
    }

    @Override
    public boolean containsBindMarker() {
        for (Term t : this.terms) {
            if (!t.containsBindMarker()) continue;
            return true;
        }
        return false;
    }

    private static Term.Terminal makeTerminal(Function fun, ByteBuffer result) throws InvalidRequestException {
        if (!(fun.returnType() instanceof CollectionType)) {
            return new Constants.Value(result);
        }
        switch (((CollectionType)fun.returnType()).kind) {
            case LIST: {
                return Lists.Value.fromSerialized(result, (ListType)fun.returnType());
            }
            case SET: {
                return Sets.Value.fromSerialized(result, (SetType)fun.returnType());
            }
            case MAP: {
                return Maps.Value.fromSerialized(result, (MapType)fun.returnType());
            }
        }
        throw new AssertionError();
    }

    public static class Raw
    implements Term.Raw {
        private final String functionName;
        private final List<Term.Raw> terms;

        public Raw(String functionName, List<Term.Raw> terms) {
            this.functionName = functionName;
            this.terms = terms;
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            Function fun = Functions.get(keyspace, this.functionName, this.terms, receiver);
            ArrayList<Term> parameters = new ArrayList<Term>(this.terms.size());
            boolean allTerminal = true;
            for (int i = 0; i < this.terms.size(); ++i) {
                Term t = this.terms.get(i).prepare(keyspace, Functions.makeArgSpec(receiver, fun, i));
                if (t instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                parameters.add(t);
            }
            return allTerminal && fun.isPure() ? FunctionCall.makeTerminal(fun, Raw.execute(fun, parameters)) : new FunctionCall(fun, parameters);
        }

        private static ByteBuffer execute(Function fun, List<Term> parameters) throws InvalidRequestException {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(parameters.size());
            for (Term t : parameters) {
                assert (t instanceof Term.Terminal);
                buffers.add(((Term.Terminal)t).get());
            }
            return fun.execute(buffers);
        }

        @Override
        public boolean isAssignableTo(String keyspace, ColumnSpecification receiver) {
            AbstractType<?> returnType = Functions.getReturnType(this.functionName, receiver.ksName, receiver.cfName);
            return returnType == null || receiver.type.asCQL3Type().equals(returnType.asCQL3Type());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.functionName).append("(");
            for (int i = 0; i < this.terms.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.terms.get(i));
            }
            return sb.append(")").toString();
        }
    }
}

