/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.exceptions.InvalidRequestException;

public class TypeCast
implements Term.Raw {
    private final CQL3Type.Raw type;
    private final Term.Raw term;

    public TypeCast(CQL3Type.Raw type, Term.Raw term) {
        this.type = type;
        this.term = term;
    }

    @Override
    public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
        if (!this.term.isAssignableTo(keyspace, this.castedSpecOf(keyspace, receiver))) {
            throw new InvalidRequestException(String.format("Cannot cast value %s to type %s", this.term, this.type));
        }
        if (!this.isAssignableTo(keyspace, receiver)) {
            throw new InvalidRequestException(String.format("Cannot assign value %s to %s of type %s", this, receiver, receiver.type.asCQL3Type()));
        }
        return this.term.prepare(keyspace, receiver);
    }

    private ColumnSpecification castedSpecOf(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
        return new ColumnSpecification(receiver.ksName, receiver.cfName, new ColumnIdentifier(this.toString(), true), this.type.prepare(keyspace).getType());
    }

    @Override
    public boolean isAssignableTo(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
        try {
            return receiver.type.asCQL3Type().equals(this.type.prepare(keyspace));
        }
        catch (InvalidRequestException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return "(" + this.type + ")" + this.term;
    }
}

