/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.io.util.Memory;

public class RefCountedMemory
extends Memory {
    private volatile int references = 1;
    private static final AtomicIntegerFieldUpdater<RefCountedMemory> UPDATER = AtomicIntegerFieldUpdater.newUpdater(RefCountedMemory.class, "references");

    public RefCountedMemory(long size) {
        super(size);
    }

    public boolean reference() {
        int n;
        do {
            if ((n = UPDATER.get(this)) > 0) continue;
            return false;
        } while (!UPDATER.compareAndSet(this, n, n + 1));
        return true;
    }

    public void unreference() {
        if (UPDATER.decrementAndGet(this) == 0) {
            this.free();
        }
    }
}

