/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.CFPropDefs;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.exceptions.AlreadyExistsException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang3.StringUtils;

public class CreateTableStatement
extends SchemaAlteringStatement {
    public AbstractType<?> comparator;
    private AbstractType<?> defaultValidator;
    private AbstractType<?> keyValidator;
    private final List<ByteBuffer> keyAliases = new ArrayList<ByteBuffer>();
    private final List<ByteBuffer> columnAliases = new ArrayList<ByteBuffer>();
    private ByteBuffer valueAlias;
    private final Map<ColumnIdentifier, AbstractType> columns = new HashMap<ColumnIdentifier, AbstractType>();
    private final Set<ColumnIdentifier> staticColumns;
    private final CFPropDefs properties;
    private final boolean ifNotExists;

    public CreateTableStatement(CFName name, CFPropDefs properties, boolean ifNotExists, Set<ColumnIdentifier> staticColumns) {
        super(name);
        this.properties = properties;
        this.ifNotExists = ifNotExists;
        this.staticColumns = staticColumns;
        try {
            if (!this.properties.hasProperty("compression").booleanValue() && CFMetaData.DEFAULT_COMPRESSOR != null) {
                this.properties.addProperty("compression", (Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("sstable_compression", CFMetaData.DEFAULT_COMPRESSOR);
                    }
                });
            }
        }
        catch (SyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasKeyspaceAccess(this.keyspace(), Permission.CREATE);
    }

    @Override
    public void validate(ClientState state) {
    }

    private Map<ByteBuffer, ColumnDefinition> getColumns() {
        HashMap<ByteBuffer, ColumnDefinition> columnDefs = new HashMap<ByteBuffer, ColumnDefinition>();
        Integer componentIndex = null;
        if (this.comparator instanceof CompositeType) {
            CompositeType ct = (CompositeType)this.comparator;
            componentIndex = ct.types.get(ct.types.size() - 1) instanceof ColumnToCollectionType ? ct.types.size() - 2 : ct.types.size() - 1;
        }
        for (Map.Entry<ColumnIdentifier, AbstractType> col : this.columns.entrySet()) {
            ColumnIdentifier id = col.getKey();
            columnDefs.put(id.key, this.staticColumns.contains(id) ? ColumnDefinition.staticDef(id.key, col.getValue(), componentIndex) : ColumnDefinition.regularDef(id.key, col.getValue(), componentIndex));
        }
        return columnDefs;
    }

    @Override
    public void announceMigration() throws RequestValidationException {
        block2: {
            try {
                MigrationManager.announceNewColumnFamily(this.getCFMetaData());
            }
            catch (AlreadyExistsException e) {
                if (this.ifNotExists) break block2;
                throw e;
            }
        }
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.CREATED;
    }

    public CFMetaData getCFMetaData() throws RequestValidationException {
        CFMetaData newCFMD = new CFMetaData(this.keyspace(), this.columnFamily(), ColumnFamilyType.Standard, this.comparator, null);
        this.applyPropertiesTo(newCFMD);
        return newCFMD;
    }

    public void applyPropertiesTo(CFMetaData cfmd) throws RequestValidationException {
        cfmd.defaultValidator(this.defaultValidator).keyValidator(this.keyValidator).columnMetadata(this.getColumns());
        cfmd.addColumnMetadataFromAliases(this.keyAliases, this.keyValidator, ColumnDefinition.Type.PARTITION_KEY);
        cfmd.addColumnMetadataFromAliases(this.columnAliases, this.comparator, ColumnDefinition.Type.CLUSTERING_KEY);
        if (this.valueAlias != null) {
            cfmd.addColumnMetadataFromAliases(Collections.singletonList(this.valueAlias), this.defaultValidator, ColumnDefinition.Type.COMPACT_VALUE);
        }
        this.properties.applyToCFMetadata(cfmd);
    }

    public static class RawStatement
    extends CFStatement {
        private final Map<ColumnIdentifier, CQL3Type> definitions = new HashMap<ColumnIdentifier, CQL3Type>();
        public final CFPropDefs properties = new CFPropDefs();
        private final List<List<ColumnIdentifier>> keyAliases = new ArrayList<List<ColumnIdentifier>>();
        private final List<ColumnIdentifier> columnAliases = new ArrayList<ColumnIdentifier>();
        private final Map<ColumnIdentifier, Boolean> definedOrdering = new LinkedHashMap<ColumnIdentifier, Boolean>();
        private final Set<ColumnIdentifier> staticColumns = new HashSet<ColumnIdentifier>();
        private boolean useCompactStorage;
        private final Multiset<ColumnIdentifier> definedNames = HashMultiset.create((int)1);
        private final boolean ifNotExists;

        public RawStatement(CFName name, boolean ifNotExists) {
            super(name);
            this.ifNotExists = ifNotExists;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws RequestValidationException {
            ArrayList types;
            if (!this.columnFamily().matches("\\w+")) {
                throw new InvalidRequestException(String.format("\"%s\" is not a valid column family name (must be alphanumeric character only: [0-9A-Za-z]+)", this.columnFamily()));
            }
            if (this.columnFamily().length() > 48) {
                throw new InvalidRequestException(String.format("Column family names shouldn't be more than %s characters long (got \"%s\")", 48, this.columnFamily()));
            }
            for (Multiset.Entry entry : this.definedNames.entrySet()) {
                if (entry.getCount() <= 1) continue;
                throw new InvalidRequestException(String.format("Multiple definition of identifier %s", entry.getElement()));
            }
            this.properties.validate();
            CreateTableStatement stmt = new CreateTableStatement(this.cfName, this.properties, this.ifNotExists, this.staticColumns);
            HashMap<ByteBuffer, CollectionType> definedCollections = null;
            for (Map.Entry<ColumnIdentifier, CQL3Type> entry : this.definitions.entrySet()) {
                ColumnIdentifier id = entry.getKey();
                CQL3Type pt = entry.getValue();
                if (pt.isCollection()) {
                    if (definedCollections == null) {
                        definedCollections = new HashMap<ByteBuffer, CollectionType>();
                    }
                    definedCollections.put(id.key, (CollectionType)pt.getType());
                }
                stmt.columns.put(id, pt.getType());
            }
            if (this.keyAliases.isEmpty()) {
                throw new InvalidRequestException("No PRIMARY KEY specifed (exactly one required)");
            }
            if (this.keyAliases.size() > 1) {
                throw new InvalidRequestException("Multiple PRIMARY KEYs specifed (exactly one required)");
            }
            List<ColumnIdentifier> kAliases = this.keyAliases.get(0);
            ArrayList keyTypes = new ArrayList(kAliases.size());
            for (ColumnIdentifier alias : kAliases) {
                stmt.keyAliases.add(alias.key);
                AbstractType<?> abstractType = this.getTypeAndRemove(stmt.columns, alias);
                if (abstractType instanceof CounterColumnType) {
                    throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", alias));
                }
                if (this.staticColumns.contains(alias)) {
                    throw new InvalidRequestException(String.format("Static column %s cannot be part of the PRIMARY KEY", alias));
                }
                keyTypes.add(abstractType);
            }
            stmt.keyValidator = keyTypes.size() == 1 ? (AbstractType)keyTypes.get(0) : CompositeType.getInstance(keyTypes);
            if (this.columnAliases.isEmpty()) {
                if (this.useCompactStorage) {
                    if (stmt.columns.isEmpty()) {
                        throw new InvalidRequestException("No definition found that is not part of the PRIMARY KEY");
                    }
                    if (definedCollections != null) {
                        throw new InvalidRequestException("Collection types are not supported with COMPACT STORAGE");
                    }
                    stmt.comparator = CFDefinition.definitionType;
                } else {
                    types = new ArrayList(definedCollections == null ? 1 : 2);
                    types.add(CFDefinition.definitionType);
                    if (definedCollections != null) {
                        types.add(ColumnToCollectionType.getInstance(definedCollections));
                    }
                    stmt.comparator = CompositeType.getInstance(types);
                }
            } else if (this.useCompactStorage && this.columnAliases.size() == 1) {
                if (definedCollections != null) {
                    throw new InvalidRequestException("Collection types are not supported with COMPACT STORAGE");
                }
                ColumnIdentifier alias = this.columnAliases.get(0);
                stmt.columnAliases.add(alias.key);
                stmt.comparator = this.getTypeAndRemove(stmt.columns, alias);
                if (stmt.comparator instanceof CounterColumnType) {
                    throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", alias));
                }
                if (this.staticColumns.contains(alias)) {
                    throw new InvalidRequestException(String.format("Static column %s cannot be part of the PRIMARY KEY", alias));
                }
            } else {
                types = new ArrayList(this.columnAliases.size() + 1);
                for (ColumnIdentifier columnIdentifier : this.columnAliases) {
                    stmt.columnAliases.add(columnIdentifier.key);
                    AbstractType<?> type = this.getTypeAndRemove(stmt.columns, columnIdentifier);
                    if (type instanceof CounterColumnType) {
                        throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", columnIdentifier));
                    }
                    if (this.staticColumns.contains(columnIdentifier)) {
                        throw new InvalidRequestException(String.format("Static column %s cannot be part of the PRIMARY KEY", columnIdentifier));
                    }
                    types.add(type);
                }
                if (this.useCompactStorage) {
                    if (definedCollections != null) {
                        throw new InvalidRequestException("Collection types are not supported with COMPACT STORAGE");
                    }
                } else {
                    types.add(CFDefinition.definitionType);
                    if (definedCollections != null) {
                        types.add(ColumnToCollectionType.getInstance(definedCollections));
                    }
                }
                if (types.isEmpty()) {
                    throw new IllegalStateException("Nonsensical empty parameter list for CompositeType");
                }
                stmt.comparator = CompositeType.getInstance(types);
            }
            if (!this.staticColumns.isEmpty()) {
                if (this.useCompactStorage) {
                    throw new InvalidRequestException("Static columns are not supported in COMPACT STORAGE tables");
                }
                if (this.columnAliases.isEmpty()) {
                    throw new InvalidRequestException("Static columns are only useful (and thus allowed) if the table has at least one clustering column");
                }
            }
            if (this.useCompactStorage && !stmt.columnAliases.isEmpty()) {
                if (stmt.columns.isEmpty()) {
                    stmt.defaultValidator = BytesType.instance;
                    stmt.valueAlias = ByteBufferUtil.EMPTY_BYTE_BUFFER;
                } else {
                    if (stmt.columns.size() > 1) {
                        throw new InvalidRequestException(String.format("COMPACT STORAGE with composite PRIMARY KEY allows no more than one column not part of the PRIMARY KEY (got: %s)", StringUtils.join(stmt.columns.keySet(), (String)", ")));
                    }
                    Map.Entry lastEntry = stmt.columns.entrySet().iterator().next();
                    stmt.defaultValidator = (AbstractType)lastEntry.getValue();
                    stmt.valueAlias = ((ColumnIdentifier)lastEntry.getKey()).key;
                    stmt.columns.remove(lastEntry.getKey());
                }
            } else {
                if (this.useCompactStorage && stmt.columns.isEmpty()) {
                    throw new InvalidRequestException("COMPACT STORAGE with non-composite PRIMARY KEY require one column not part of the PRIMARY KEY, none given");
                }
                stmt.defaultValidator = !stmt.columns.isEmpty() && stmt.columns.values().iterator().next() instanceof CounterColumnType ? CounterColumnType.instance : BytesType.instance;
            }
            if (!this.definedOrdering.isEmpty()) {
                if (this.definedOrdering.size() > this.columnAliases.size()) {
                    throw new InvalidRequestException("Only clustering key columns can be defined in CLUSTERING ORDER directive");
                }
                int i = 0;
                for (ColumnIdentifier columnIdentifier : this.definedOrdering.keySet()) {
                    ColumnIdentifier c;
                    if (!columnIdentifier.equals(c = this.columnAliases.get(i))) {
                        if (this.definedOrdering.containsKey(c)) {
                            throw new InvalidRequestException(String.format("The order of columns in the CLUSTERING ORDER directive must be the one of the clustering key (%s must appear before %s)", c, columnIdentifier));
                        }
                        throw new InvalidRequestException(String.format("Missing CLUSTERING ORDER for column %s", c));
                    }
                    ++i;
                }
            }
            return new ParsedStatement.Prepared(stmt);
        }

        private AbstractType<?> getTypeAndRemove(Map<ColumnIdentifier, AbstractType> columns, ColumnIdentifier t) throws InvalidRequestException {
            ReversedType type = columns.get(t);
            if (type == null) {
                throw new InvalidRequestException(String.format("Unknown definition %s referenced in PRIMARY KEY", t));
            }
            if (type instanceof CollectionType) {
                throw new InvalidRequestException(String.format("Invalid collection type for PRIMARY KEY component %s", t));
            }
            columns.remove(t);
            Boolean isReversed = this.definedOrdering.get(t);
            return isReversed != null && isReversed != false ? ReversedType.getInstance(type) : type;
        }

        public void addDefinition(ColumnIdentifier def, CQL3Type type, boolean isStatic) {
            this.definedNames.add((Object)def);
            this.definitions.put(def, type);
            if (isStatic) {
                this.staticColumns.add(def);
            }
        }

        public void addKeyAliases(List<ColumnIdentifier> aliases) {
            this.keyAliases.add(aliases);
        }

        public void addColumnAlias(ColumnIdentifier alias) {
            this.columnAliases.add(alias);
        }

        public void setOrdering(ColumnIdentifier alias, boolean reversed) {
            this.definedOrdering.put(alias, reversed);
        }

        public void setCompactStorage() {
            this.useCompactStorage = true;
        }

        public void checkAccess(ClientState state) {
            throw new UnsupportedOperationException();
        }

        public CqlResult execute(ClientState state, List<ByteBuffer> variables) {
            throw new UnsupportedOperationException();
        }
    }
}

