/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.utils.UUIDSerializer;

public class StreamInitMessage {
    public static IVersionedSerializer<StreamInitMessage> serializer = new StreamInitMessageSerializer();
    public final InetAddress from;
    public final UUID planId;
    public final String description;
    public final boolean isForOutgoing;

    public StreamInitMessage(InetAddress from, UUID planId, String description, boolean isForOutgoing) {
        this.from = from;
        this.planId = planId;
        this.description = description;
        this.isForOutgoing = isForOutgoing;
    }

    public ByteBuffer createMessage(boolean compress, int version) {
        byte[] bytes;
        int header = 0;
        if (compress) {
            header |= 4;
        }
        header |= 8;
        header |= version << 8;
        try {
            int size = (int)serializer.serializedSize(this, version);
            DataOutputBuffer buffer = new DataOutputBuffer(size);
            serializer.serialize(this, buffer, version);
            bytes = buffer.getData();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        assert (bytes.length > 0);
        ByteBuffer buffer = ByteBuffer.allocate(8 + bytes.length);
        buffer.putInt(-900387334);
        buffer.putInt(header);
        buffer.put(bytes);
        buffer.flip();
        return buffer;
    }

    private static class StreamInitMessageSerializer
    implements IVersionedSerializer<StreamInitMessage> {
        private StreamInitMessageSerializer() {
        }

        @Override
        public void serialize(StreamInitMessage message, DataOutput out, int version) throws IOException {
            CompactEndpointSerializationHelper.serialize(message.from, out);
            UUIDSerializer.serializer.serialize(message.planId, out, 7);
            out.writeUTF(message.description);
            out.writeBoolean(message.isForOutgoing);
        }

        @Override
        public StreamInitMessage deserialize(DataInput in, int version) throws IOException {
            InetAddress from = CompactEndpointSerializationHelper.deserialize(in);
            UUID planId = UUIDSerializer.serializer.deserialize(in, 7);
            String description = in.readUTF();
            boolean sentByInitiator = in.readBoolean();
            return new StreamInitMessage(from, planId, description, sentByInitiator);
        }

        @Override
        public long serializedSize(StreamInitMessage message, int version) {
            long size = CompactEndpointSerializationHelper.serializedSize(message.from);
            size += UUIDSerializer.serializer.serializedSize(message.planId, 7);
            size += (long)TypeSizes.NATIVE.sizeof(message.description);
            return size += (long)TypeSizes.NATIVE.sizeof(message.isForOutgoing);
        }
    }
}

