/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnCounter {
    protected int live;
    protected int ignored;
    protected final long timestamp;

    public ColumnCounter(long timestamp) {
        this.timestamp = timestamp;
    }

    public void count(Column column, DeletionInfo.InOrderTester tester) {
        if (!ColumnCounter.isLive(column, tester, this.timestamp)) {
            ++this.ignored;
        } else {
            ++this.live;
        }
    }

    protected static boolean isLive(Column column, DeletionInfo.InOrderTester tester, long timestamp) {
        return column.isLive(timestamp) && !tester.isDeleted(column);
    }

    public int live() {
        return this.live;
    }

    public int ignored() {
        return this.ignored;
    }

    public ColumnCounter countAll(ColumnFamily container) {
        if (container == null) {
            return this;
        }
        DeletionInfo.InOrderTester tester = container.inOrderDeletionTester();
        for (Column c : container) {
            this.count(c, tester);
        }
        return this;
    }

    public static class GroupByPrefix
    extends ColumnCounter {
        private final CompositeType type;
        private final int toGroup;
        private ByteBuffer[] previous;
        private boolean previousGroupIsStatic;

        public GroupByPrefix(long timestamp, CompositeType type, int toGroup) {
            super(timestamp);
            this.type = type;
            this.toGroup = toGroup;
            assert (toGroup == 0 || type != null);
        }

        @Override
        public void count(Column column, DeletionInfo.InOrderTester tester) {
            if (!GroupByPrefix.isLive(column, tester, this.timestamp)) {
                ++this.ignored;
                return;
            }
            if (this.toGroup == 0) {
                this.live = 1;
                return;
            }
            ByteBuffer[] current = this.type.split(column.name());
            assert (current.length >= this.toGroup);
            if (this.previous == null) {
                this.previousGroupIsStatic = CompositeType.isStaticName(column.name());
            } else {
                boolean isSameGroup;
                boolean bl = isSameGroup = this.previousGroupIsStatic == CompositeType.isStaticName(column.name());
                if (isSameGroup) {
                    for (int i = 0; i < this.toGroup; ++i) {
                        if (ByteBufferUtil.compareUnsigned(this.previous[i], current[i]) == 0) continue;
                        isSameGroup = false;
                        break;
                    }
                }
                if (isSameGroup) {
                    return;
                }
                if (this.previousGroupIsStatic) {
                    this.previous = current;
                    this.previousGroupIsStatic = false;
                    return;
                }
            }
            ++this.live;
            this.previous = current;
        }
    }
}

