/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.AbstractCommitLogExecutorService;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.WrappedRunnable;

class BatchCommitLogExecutorService
extends AbstractCommitLogExecutorService {
    private final BlockingQueue<CheaterFutureTask> queue;
    private final Thread appendingThread;
    private volatile boolean run = true;
    private final ArrayList<CheaterFutureTask> incompleteTasks = new ArrayList();
    private final ArrayList taskValues = new ArrayList();

    public BatchCommitLogExecutorService() {
        this(DatabaseDescriptor.getConcurrentWriters());
    }

    public BatchCommitLogExecutorService(int queueSize) {
        this.queue = new LinkedBlockingQueue<CheaterFutureTask>(queueSize);
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                while (BatchCommitLogExecutorService.this.run) {
                    try {
                        if (!BatchCommitLogExecutorService.this.processWithSyncBatch()) continue;
                        ++BatchCommitLogExecutorService.this.completedTaskCount;
                    }
                    catch (Throwable t) {
                        if (CommitLog.handleCommitError("Failed to persist commits to disk", t)) continue;
                        return;
                    }
                }
            }
        };
        this.appendingThread = new Thread((Runnable)runnable, "COMMIT-LOG-WRITER");
        this.appendingThread.start();
    }

    @Override
    public long getPendingTasks() {
        return this.queue.size();
    }

    private boolean processWithSyncBatch() throws Exception {
        CheaterFutureTask firstTask = this.queue.poll(100L, TimeUnit.MILLISECONDS);
        if (firstTask == null) {
            return false;
        }
        if (!(firstTask.getRawCallable() instanceof CommitLog.LogRecordAdder)) {
            firstTask.run();
            return true;
        }
        this.incompleteTasks.clear();
        this.taskValues.clear();
        long start = System.nanoTime();
        long window = (long)(1000000.0 * DatabaseDescriptor.getCommitLogSyncBatchWindow());
        this.incompleteTasks.add(firstTask);
        this.taskValues.add(firstTask.getRawCallable().call());
        while (!this.queue.isEmpty() && ((CheaterFutureTask)this.queue.peek()).getRawCallable() instanceof CommitLog.LogRecordAdder && System.nanoTime() - start < window) {
            CheaterFutureTask task = (CheaterFutureTask)this.queue.remove();
            this.incompleteTasks.add(task);
            this.taskValues.add(task.getRawCallable().call());
        }
        CommitLog.instance.sync();
        for (int i = 0; i < this.incompleteTasks.size(); ++i) {
            this.incompleteTasks.get(i).set(this.taskValues.get(i));
        }
        return true;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return this.newTaskFor(Executors.callable(runnable, value));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new CheaterFutureTask<T>(callable);
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.queue.put((CheaterFutureTask)command);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void add(CommitLog.LogRecordAdder adder) {
        FBUtilities.waitOnFuture(this.submit(adder));
    }

    @Override
    public void shutdown() {
        new Thread((Runnable)new WrappedRunnable(){

            @Override
            public void runMayThrow() throws InterruptedException {
                while (!BatchCommitLogExecutorService.this.queue.isEmpty()) {
                    Thread.sleep(100L);
                }
                BatchCommitLogExecutorService.this.run = false;
                BatchCommitLogExecutorService.this.appendingThread.join();
            }
        }, "Commitlog Shutdown").start();
    }

    @Override
    public void awaitTermination() throws InterruptedException {
        this.appendingThread.join();
    }

    private static class CheaterFutureTask<V>
    extends FutureTask<V> {
        private final Callable rawCallable;

        public CheaterFutureTask(Callable<V> callable) {
            super(callable);
            this.rawCallable = callable;
        }

        public Callable getRawCallable() {
            return this.rawCallable;
        }

        @Override
        public void set(V v) {
            super.set(v);
        }
    }
}

