/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.util.BufferedPoolingSegmentedFile;
import org.apache.cassandra.io.util.CompressedPoolingSegmentedFile;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.MmappedSegmentedFile;
import org.apache.cassandra.utils.Pair;

public abstract class SegmentedFile {
    public final String path;
    public final long length;
    public final long onDiskLength;

    SegmentedFile(String path, long length) {
        this(path, length, length);
    }

    protected SegmentedFile(String path, long length, long onDiskLength) {
        this.path = new File(path).getAbsolutePath();
        this.length = length;
        this.onDiskLength = onDiskLength;
    }

    public static Builder getBuilder(Config.DiskAccessMode mode) {
        return mode == Config.DiskAccessMode.mmap ? new MmappedSegmentedFile.Builder() : new BufferedPoolingSegmentedFile.Builder();
    }

    public static Builder getCompressedBuilder() {
        return new CompressedPoolingSegmentedFile.Builder();
    }

    public abstract FileDataInput getSegment(long var1);

    public Iterator<FileDataInput> iterator(long position) {
        return new SegmentIterator(position);
    }

    public abstract void cleanup();

    public String toString() {
        return this.getClass().getSimpleName() + "(path='" + this.path + "'" + ", length=" + this.length + ")";
    }

    final class SegmentIterator
    implements Iterator<FileDataInput> {
        private long nextpos;

        public SegmentIterator(long position) {
            this.nextpos = position;
        }

        @Override
        public boolean hasNext() {
            return this.nextpos < SegmentedFile.this.length;
        }

        @Override
        public FileDataInput next() {
            long position = this.nextpos;
            if (position >= SegmentedFile.this.length) {
                throw new NoSuchElementException();
            }
            FileDataInput segment = SegmentedFile.this.getSegment(this.nextpos);
            try {
                this.nextpos += segment.bytesRemaining();
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, SegmentedFile.this.path);
            }
            return segment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class Segment
    extends Pair<Long, MappedByteBuffer>
    implements Comparable<Segment> {
        public Segment(long offset, MappedByteBuffer segment) {
            super(offset, segment);
        }

        @Override
        public final int compareTo(Segment that) {
            return (int)Math.signum((Long)this.left - (Long)that.left);
        }
    }

    public static abstract class Builder {
        public abstract void addPotentialBoundary(long var1);

        public abstract SegmentedFile complete(String var1);

        public void serializeBounds(DataOutput out) throws IOException {
            out.writeUTF(DatabaseDescriptor.getDiskAccessMode().name());
        }

        public void deserializeBounds(DataInput in) throws IOException {
            if (!in.readUTF().equals(DatabaseDescriptor.getDiskAccessMode().name())) {
                throw new IOException("Cannot deserialize SSTable Summary component because the DiskAccessMode was changed!");
            }
        }
    }
}

