/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.cassandra.utils.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlRecordReader
extends RecordReader<Long, Row>
implements org.apache.hadoop.mapred.RecordReader<Long, Row> {
    private static final Logger logger = LoggerFactory.getLogger(CqlRecordReader.class);
    private ColumnFamilySplit split;
    private RowIterator rowIterator;
    private Pair<Long, Row> currentRow;
    private int totalRowCount;
    private String keyspace;
    private String cfName;
    private String cqlQuery;
    private Cluster cluster;
    private Session session;
    private IPartitioner partitioner;
    private LinkedHashMap<String, Boolean> partitionBoundColumns = Maps.newLinkedHashMap();

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        this.split = (ColumnFamilySplit)split;
        Configuration conf = context.getConfiguration();
        this.totalRowCount = this.split.getLength() < Long.MAX_VALUE ? (int)this.split.getLength() : ConfigHelper.getInputSplitSize(conf);
        this.cfName = ConfigHelper.getInputColumnFamily(conf);
        this.keyspace = ConfigHelper.getInputKeyspace(conf);
        this.cqlQuery = CqlConfigHelper.getInputCql(conf);
        this.partitioner = ConfigHelper.getInputPartitioner(context.getConfiguration());
        try {
            if (this.cluster != null) {
                return;
            }
            String[] locations = split.getLocations();
            Exception lastException = null;
            for (String location : locations) {
                try {
                    this.cluster = CqlConfigHelper.getInputCluster(location, conf);
                    break;
                }
                catch (Exception e) {
                    lastException = e;
                    logger.warn("Failed to create authenticated client to {}", (Object)location);
                }
            }
            if (this.cluster == null && lastException != null) {
                throw lastException;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.cluster != null) {
            this.session = this.cluster.connect(this.keyspace);
        }
        this.rowIterator = new RowIterator();
        logger.debug("created {}", (Object)this.rowIterator);
    }

    public void close() {
        if (this.session != null) {
            this.session.close();
        }
    }

    public Long getCurrentKey() {
        return (Long)this.currentRow.left;
    }

    public Row getCurrentValue() {
        return (Row)this.currentRow.right;
    }

    public float getProgress() {
        if (!this.rowIterator.hasNext()) {
            return 1.0f;
        }
        float progress = (float)this.rowIterator.totalRead / (float)this.totalRowCount;
        return progress > 1.0f ? 1.0f : progress;
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.rowIterator.hasNext()) {
            logger.debug("Finished scanning {} rows (estimate was: {})", (Object)this.rowIterator.totalRead, (Object)this.totalRowCount);
            return false;
        }
        try {
            this.currentRow = (Pair)this.rowIterator.next();
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(ioe.getCause());
            throw ioe;
        }
        return true;
    }

    public boolean next(Long key, Row value) throws IOException {
        if (this.nextKeyValue()) {
            ((WrappedRow)value).setRow(this.getCurrentValue());
            return true;
        }
        return false;
    }

    public long getPos() throws IOException {
        return this.rowIterator.totalRead;
    }

    public Long createKey() {
        return new Long(0L);
    }

    public Row createValue() {
        return new WrappedRow();
    }

    private static class WrappedRow
    implements Row {
        private Row row;

        private WrappedRow() {
        }

        public void setRow(Row row) {
            this.row = row;
        }

        public ColumnDefinitions getColumnDefinitions() {
            return this.row.getColumnDefinitions();
        }

        public boolean isNull(int i) {
            return this.row.isNull(i);
        }

        public boolean isNull(String name) {
            return this.row.isNull(name);
        }

        public boolean getBool(int i) {
            return this.row.getBool(i);
        }

        public boolean getBool(String name) {
            return this.row.getBool(name);
        }

        public int getInt(int i) {
            return this.row.getInt(i);
        }

        public int getInt(String name) {
            return this.row.getInt(name);
        }

        public long getLong(int i) {
            return this.row.getLong(i);
        }

        public long getLong(String name) {
            return this.row.getLong(name);
        }

        public Date getDate(int i) {
            return this.row.getDate(i);
        }

        public Date getDate(String name) {
            return this.row.getDate(name);
        }

        public float getFloat(int i) {
            return this.row.getFloat(i);
        }

        public float getFloat(String name) {
            return this.row.getFloat(name);
        }

        public double getDouble(int i) {
            return this.row.getDouble(i);
        }

        public double getDouble(String name) {
            return this.row.getDouble(name);
        }

        public ByteBuffer getBytesUnsafe(int i) {
            return this.row.getBytesUnsafe(i);
        }

        public ByteBuffer getBytesUnsafe(String name) {
            return this.row.getBytesUnsafe(name);
        }

        public ByteBuffer getBytes(int i) {
            return this.row.getBytes(i);
        }

        public ByteBuffer getBytes(String name) {
            return this.row.getBytes(name);
        }

        public String getString(int i) {
            return this.row.getString(i);
        }

        public String getString(String name) {
            return this.row.getString(name);
        }

        public BigInteger getVarint(int i) {
            return this.row.getVarint(i);
        }

        public BigInteger getVarint(String name) {
            return this.row.getVarint(name);
        }

        public BigDecimal getDecimal(int i) {
            return this.row.getDecimal(i);
        }

        public BigDecimal getDecimal(String name) {
            return this.row.getDecimal(name);
        }

        public UUID getUUID(int i) {
            return this.row.getUUID(i);
        }

        public UUID getUUID(String name) {
            return this.row.getUUID(name);
        }

        public InetAddress getInet(int i) {
            return this.row.getInet(i);
        }

        public InetAddress getInet(String name) {
            return this.row.getInet(name);
        }

        public <T> List<T> getList(int i, Class<T> elementsClass) {
            return this.row.getList(i, elementsClass);
        }

        public <T> List<T> getList(String name, Class<T> elementsClass) {
            return this.row.getList(name, elementsClass);
        }

        public <T> Set<T> getSet(int i, Class<T> elementsClass) {
            return this.row.getSet(i, elementsClass);
        }

        public <T> Set<T> getSet(String name, Class<T> elementsClass) {
            return this.row.getSet(name, elementsClass);
        }

        public <K, V> Map<K, V> getMap(int i, Class<K> keysClass, Class<V> valuesClass) {
            return this.row.getMap(i, keysClass, valuesClass);
        }

        public <K, V> Map<K, V> getMap(String name, Class<K> keysClass, Class<V> valuesClass) {
            return this.row.getMap(name, keysClass, valuesClass);
        }
    }

    private class RowIterator
    extends AbstractIterator<Pair<Long, Row>> {
        private long keyId = 0L;
        protected int totalRead = 0;
        protected Iterator<Row> rows;
        private Map<String, ByteBuffer> previousRowKey = new HashMap<String, ByteBuffer>();

        public RowIterator() {
            if (CqlRecordReader.this.session == null) {
                throw new RuntimeException("Can't create connection session");
            }
            AbstractType<?> type = CqlRecordReader.this.partitioner.getTokenValidator();
            ResultSet rs = CqlRecordReader.this.session.execute(CqlRecordReader.this.cqlQuery, new Object[]{type.compose(type.fromString(CqlRecordReader.this.split.getStartToken())), type.compose(type.fromString(CqlRecordReader.this.split.getEndToken()))});
            for (ColumnMetadata meta : CqlRecordReader.this.cluster.getMetadata().getKeyspace(CqlRecordReader.this.keyspace).getTable(CqlRecordReader.this.cfName).getPartitionKey()) {
                CqlRecordReader.this.partitionBoundColumns.put(meta.getName(), Boolean.TRUE);
            }
            this.rows = rs.iterator();
        }

        protected Pair<Long, Row> computeNext() {
            if (this.rows == null || !this.rows.hasNext()) {
                return (Pair)this.endOfData();
            }
            Row row = this.rows.next();
            HashMap<String, ByteBuffer> keyColumns = new HashMap<String, ByteBuffer>();
            for (String column : CqlRecordReader.this.partitionBoundColumns.keySet()) {
                keyColumns.put(column, row.getBytesUnsafe(column));
            }
            if (this.previousRowKey.isEmpty() && !keyColumns.isEmpty()) {
                this.previousRowKey = keyColumns;
                ++this.totalRead;
            } else {
                for (String column : CqlRecordReader.this.partitionBoundColumns.keySet()) {
                    if (BytesType.bytesCompare((ByteBuffer)keyColumns.get(column), this.previousRowKey.get(column)) == 0) continue;
                    this.previousRowKey = keyColumns;
                    ++this.totalRead;
                    break;
                }
            }
            ++this.keyId;
            return Pair.create(this.keyId, row);
        }
    }
}

