/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;

public class BoundedStatsDeque
implements Iterable<Long> {
    private final LinkedBlockingDeque<Long> deque;
    private final AtomicLong sum;

    public BoundedStatsDeque(int size) {
        this.deque = new LinkedBlockingDeque(size);
        this.sum = new AtomicLong(0L);
    }

    @Override
    public Iterator<Long> iterator() {
        return this.deque.iterator();
    }

    public int size() {
        return this.deque.size();
    }

    public void add(long i) {
        if (!this.deque.offer(i)) {
            Long removed = this.deque.remove();
            this.sum.addAndGet(-removed.longValue());
            this.deque.offer(i);
        }
        this.sum.addAndGet(i);
    }

    public long sum() {
        return this.sum.get();
    }

    public double mean() {
        return this.size() > 0 ? (double)this.sum() / (double)this.size() : 0.0;
    }
}

