/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.triggers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.TriggerDefinition;
import org.apache.cassandra.cql.QueryProcessor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.triggers.CustomClassLoader;
import org.apache.cassandra.triggers.ITrigger;
import org.apache.cassandra.utils.FBUtilities;

public class TriggerExecutor {
    public static final TriggerExecutor instance = new TriggerExecutor();
    private final Map<String, ITrigger> cachedTriggers = Maps.newConcurrentMap();
    private final ClassLoader parent = Thread.currentThread().getContextClassLoader();
    private volatile ClassLoader customClassLoader;

    private TriggerExecutor() {
        this.reloadClasses();
    }

    public void reloadClasses() {
        File tiggerDirectory = FBUtilities.cassandraTriggerDir();
        if (tiggerDirectory == null) {
            return;
        }
        this.customClassLoader = new CustomClassLoader(this.parent, tiggerDirectory);
        this.cachedTriggers.clear();
    }

    public Collection<RowMutation> execute(Collection<? extends IMutation> updates) throws InvalidRequestException {
        boolean hasCounters = false;
        List<RowMutation> tmutations = null;
        for (IMutation iMutation : updates) {
            for (ColumnFamily cf : iMutation.getColumnFamilies()) {
                List<RowMutation> intermediate = this.execute(iMutation.key(), cf);
                if (intermediate == null) continue;
                this.validate(intermediate);
                if (tmutations == null) {
                    tmutations = intermediate;
                    continue;
                }
                tmutations.addAll(intermediate);
            }
            if (!(iMutation instanceof CounterMutation)) continue;
            hasCounters = true;
        }
        if (tmutations != null && hasCounters) {
            throw new InvalidRequestException("Counter mutations and trigger mutations cannot be applied together atomically.");
        }
        return tmutations;
    }

    private void validate(Collection<RowMutation> tmutations) throws InvalidRequestException {
        for (RowMutation mutation : tmutations) {
            QueryProcessor.validateKey(mutation.key());
            for (ColumnFamily tcf : mutation.getColumnFamilies()) {
                for (ByteBuffer tName : tcf.getColumnNames()) {
                    QueryProcessor.validateColumn(tcf.metadata(), tName, tcf.getColumn(tName).value());
                }
            }
        }
    }

    private List<RowMutation> execute(ByteBuffer key, ColumnFamily columnFamily) {
        Map<String, TriggerDefinition> triggers = columnFamily.metadata().getTriggers();
        if (triggers.isEmpty()) {
            return null;
        }
        LinkedList tmutations = Lists.newLinkedList();
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
        try {
            for (TriggerDefinition td : triggers.values()) {
                Collection<RowMutation> temp;
                ITrigger trigger = this.cachedTriggers.get(td.classOption);
                if (trigger == null) {
                    trigger = this.loadTriggerInstance(td.classOption);
                    this.cachedTriggers.put(td.classOption, trigger);
                }
                if ((temp = trigger.augment(key, columnFamily)) == null) continue;
                tmutations.addAll(temp);
            }
            LinkedList i$ = tmutations;
            return i$;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Exception while creating trigger on CF with ID: %s", columnFamily.id()), ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.parent);
        }
    }

    public synchronized ITrigger loadTriggerInstance(String triggerName) throws Exception {
        if (this.cachedTriggers.get(triggerName) != null) {
            return this.cachedTriggers.get(triggerName);
        }
        return (ITrigger)this.customClassLoader.loadClass(triggerName).getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

