/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.serializers.UTF8Serializer;

public class UTF8Type
extends AbstractType<String> {
    public static final UTF8Type instance = new UTF8Type();

    UTF8Type() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return BytesType.bytesCompare(o1, o2);
    }

    @Override
    public ByteBuffer fromString(String source) {
        return this.decompose(source);
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        return this == previous || previous == AsciiType.instance;
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.TEXT;
    }

    @Override
    public TypeSerializer<String> getSerializer() {
        return UTF8Serializer.instance;
    }
}

