/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.utils.Pair;

public class ColumnGroupMap {
    private final ByteBuffer[] fullPath;
    private final Map<ByteBuffer, Value> map = new HashMap<ByteBuffer, Value>();

    private ColumnGroupMap(ByteBuffer[] fullPath) {
        this.fullPath = fullPath;
    }

    private void add(ByteBuffer[] fullName, int idx, Column column) {
        ByteBuffer columnName = fullName[idx];
        if (fullName.length == idx + 2) {
            Value v = this.map.get(columnName);
            if (v == null) {
                v = new Collection();
                this.map.put(columnName, v);
            }
            assert (v instanceof Collection);
            ((Collection)v).add(Pair.create(fullName[idx + 1], column));
        } else {
            assert (!this.map.containsKey(columnName));
            this.map.put(columnName, new Simple(column));
        }
    }

    public ByteBuffer getKeyComponent(int pos) {
        return this.fullPath[pos];
    }

    public Column getSimple(ByteBuffer key) {
        Value v = this.map.get(key);
        if (v == null) {
            return null;
        }
        assert (v instanceof Simple);
        return ((Simple)v).column;
    }

    public List<Pair<ByteBuffer, Column>> getCollection(ByteBuffer key) {
        Value v = this.map.get(key);
        if (v == null) {
            return null;
        }
        assert (v instanceof Collection);
        return (List)((Object)v);
    }

    public static class Builder {
        private final CompositeType composite;
        private final int idx;
        private final long now;
        private ByteBuffer[] previous;
        private final List<ColumnGroupMap> groups = new ArrayList<ColumnGroupMap>();
        private ColumnGroupMap currentGroup;

        public Builder(CompositeType composite, boolean hasCollections, long now) {
            this.composite = composite;
            this.idx = composite.types.size() - (hasCollections ? 2 : 1);
            this.now = now;
        }

        public void add(Column c) {
            if (c.isMarkedForDelete(this.now)) {
                return;
            }
            ByteBuffer[] current = this.composite.split(c.name());
            if (this.currentGroup == null) {
                this.currentGroup = new ColumnGroupMap(current);
                this.currentGroup.add(current, this.idx, c);
                this.previous = current;
                return;
            }
            if (!this.isSameGroup(current)) {
                this.groups.add(this.currentGroup);
                this.currentGroup = new ColumnGroupMap(current);
            }
            this.currentGroup.add(current, this.idx, c);
            this.previous = current;
        }

        private boolean isSameGroup(ByteBuffer[] c) {
            for (int i = 0; i < this.idx; ++i) {
                if (c[i].equals(this.previous[i])) continue;
                return false;
            }
            return true;
        }

        public List<ColumnGroupMap> groups() {
            if (this.currentGroup != null) {
                this.groups.add(this.currentGroup);
                this.currentGroup = null;
            }
            return this.groups;
        }
    }

    private static class Collection
    extends ArrayList<Pair<ByteBuffer, Column>>
    implements Value {
        private Collection() {
        }
    }

    private static class Simple
    implements Value {
        public final Column column;

        Simple(Column column) {
            this.column = column;
        }
    }

    private static interface Value {
    }
}

