/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.AbstractIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeTombstoneList
implements Iterable<RangeTombstone> {
    private static final Logger logger = LoggerFactory.getLogger(RangeTombstoneList.class);
    public static final Serializer serializer = new Serializer();
    private final Comparator<ByteBuffer> comparator;
    private ByteBuffer[] starts;
    private ByteBuffer[] ends;
    private long[] markedAts;
    private int[] delTimes;
    private int size;

    private RangeTombstoneList(Comparator<ByteBuffer> comparator, ByteBuffer[] starts, ByteBuffer[] ends, long[] markedAts, int[] delTimes, int size) {
        assert (starts.length == ends.length && starts.length == markedAts.length && starts.length == delTimes.length);
        this.comparator = comparator;
        this.starts = starts;
        this.ends = ends;
        this.markedAts = markedAts;
        this.delTimes = delTimes;
        this.size = size;
    }

    public RangeTombstoneList(Comparator<ByteBuffer> comparator, int capacity) {
        this(comparator, new ByteBuffer[capacity], new ByteBuffer[capacity], new long[capacity], new int[capacity], 0);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public Comparator<ByteBuffer> comparator() {
        return this.comparator;
    }

    public RangeTombstoneList copy() {
        return new RangeTombstoneList(this.comparator, Arrays.copyOf(this.starts, this.size), Arrays.copyOf(this.ends, this.size), Arrays.copyOf(this.markedAts, this.size), Arrays.copyOf(this.delTimes, this.size), this.size);
    }

    public void add(RangeTombstone tombstone) {
        this.add((ByteBuffer)tombstone.min, (ByteBuffer)tombstone.max, ((DeletionTime)tombstone.data).markedForDeleteAt, ((DeletionTime)tombstone.data).localDeletionTime);
    }

    public void add(ByteBuffer start, ByteBuffer end, long markedAt, int delTime) {
        if (this.isEmpty()) {
            this.addInternal(0, start, end, markedAt, delTime);
            return;
        }
        int c = this.comparator.compare(this.ends[this.size - 1], start);
        if (c <= 0) {
            this.addInternal(this.size, start, end, markedAt, delTime);
        } else {
            int pos = Arrays.binarySearch(this.ends, 0, this.size, start, this.comparator);
            this.insertFrom(pos >= 0 ? pos + 1 : -pos - 1, start, end, markedAt, delTime);
        }
    }

    public void addAll(RangeTombstoneList tombstones) {
        if (tombstones.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            RangeTombstoneList.copyArrays(tombstones, this);
            return;
        }
        if (this.size > 10 * tombstones.size) {
            for (int i = 0; i < tombstones.size; ++i) {
                this.add(tombstones.starts[i], tombstones.ends[i], tombstones.markedAts[i], tombstones.delTimes[i]);
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < this.size && j < tombstones.size) {
                if (this.comparator.compare(tombstones.starts[j], this.ends[i]) < 0) {
                    this.insertFrom(i, tombstones.starts[j], tombstones.ends[j], tombstones.markedAts[j], tombstones.delTimes[j]);
                    ++j;
                    continue;
                }
                ++i;
            }
            while (j < tombstones.size) {
                this.addInternal(this.size, tombstones.starts[j], tombstones.ends[j], tombstones.markedAts[j], tombstones.delTimes[j]);
                ++j;
            }
        }
    }

    public boolean isDeleted(ByteBuffer name, long timestamp) {
        int idx = this.searchInternal(name);
        return idx >= 0 && this.markedAts[idx] >= timestamp;
    }

    InOrderTester inOrderTester() {
        return new InOrderTester();
    }

    public DeletionTime search(ByteBuffer name) {
        int idx = this.searchInternal(name);
        return idx < 0 ? null : new DeletionTime(this.markedAts[idx], this.delTimes[idx]);
    }

    private int searchInternal(ByteBuffer name) {
        if (this.isEmpty()) {
            return -1;
        }
        int pos = Arrays.binarySearch(this.starts, 0, this.size, name, this.comparator);
        if (pos >= 0) {
            if (pos > 0 && this.comparator.compare(name, this.ends[pos - 1]) == 0 && this.markedAts[pos - 1] > this.markedAts[pos]) {
                return pos - 1;
            }
            return pos;
        }
        int idx = -pos - 2;
        if (idx < 0) {
            return -1;
        }
        return this.comparator.compare(name, this.ends[idx]) <= 0 ? idx : -1;
    }

    public int dataSize() {
        int dataSize = TypeSizes.NATIVE.sizeof(this.size);
        for (int i = 0; i < this.size; ++i) {
            dataSize += this.starts[i].remaining() + this.ends[i].remaining();
            dataSize += TypeSizes.NATIVE.sizeof(this.markedAts[i]);
            dataSize += TypeSizes.NATIVE.sizeof(this.delTimes[i]);
        }
        return dataSize;
    }

    public long minMarkedAt() {
        long min = Long.MAX_VALUE;
        for (int i = 0; i < this.size; ++i) {
            min = Math.min(min, this.markedAts[i]);
        }
        return min;
    }

    public long maxMarkedAt() {
        long max = Long.MIN_VALUE;
        for (int i = 0; i < this.size; ++i) {
            max = Math.max(max, this.markedAts[i]);
        }
        return max;
    }

    public void updateAllTimestamp(long timestamp) {
        for (int i = 0; i < this.size; ++i) {
            this.markedAts[i] = timestamp;
        }
    }

    public void purge(int gcBefore) {
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.delTimes[i] < gcBefore) continue;
            this.setInternal(j++, this.starts[i], this.ends[i], this.markedAts[i], this.delTimes[i]);
        }
        this.size = j;
    }

    public boolean hasIrrelevantData(int gcBefore) {
        for (int i = 0; i < this.size; ++i) {
            if (this.delTimes[i] >= gcBefore) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<RangeTombstone> iterator() {
        return new AbstractIterator<RangeTombstone>(){
            private int idx;

            protected RangeTombstone computeNext() {
                if (this.idx >= RangeTombstoneList.this.size) {
                    return (RangeTombstone)this.endOfData();
                }
                RangeTombstone t = new RangeTombstone(RangeTombstoneList.this.starts[this.idx], RangeTombstoneList.this.ends[this.idx], RangeTombstoneList.this.markedAts[this.idx], RangeTombstoneList.this.delTimes[this.idx]);
                ++this.idx;
                return t;
            }
        };
    }

    public boolean equals(Object o) {
        if (!(o instanceof RangeTombstoneList)) {
            return false;
        }
        RangeTombstoneList that = (RangeTombstoneList)o;
        if (this.size != that.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!this.starts[i].equals(that.starts[i])) {
                return false;
            }
            if (!this.ends[i].equals(that.ends[i])) {
                return false;
            }
            if (this.markedAts[i] != that.markedAts[i]) {
                return false;
            }
            if (this.delTimes[i] == that.delTimes[i]) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int result = this.size;
        for (int i = 0; i < this.size; ++i) {
            result += this.starts[i].hashCode() + this.ends[i].hashCode();
            result += (int)(this.markedAts[i] ^ this.markedAts[i] >>> 32);
            result += this.delTimes[i];
        }
        return result;
    }

    private static void copyArrays(RangeTombstoneList src, RangeTombstoneList dst) {
        dst.grow(src.size);
        System.arraycopy(src.starts, 0, dst.starts, 0, src.size);
        System.arraycopy(src.ends, 0, dst.ends, 0, src.size);
        System.arraycopy(src.markedAts, 0, dst.markedAts, 0, src.size);
        System.arraycopy(src.delTimes, 0, dst.delTimes, 0, src.size);
        dst.size = src.size;
    }

    private void insertFrom(int i, ByteBuffer start, ByteBuffer end, long markedAt, int delTime) {
        while (i < this.size) {
            assert (i == 0 || this.comparator.compare(start, this.ends[i - 1]) >= 0);
            assert (i >= this.size || this.comparator.compare(start, this.ends[i]) < 0);
            if (markedAt > this.markedAts[i]) {
                if (this.comparator.compare(this.starts[i], start) < 0) {
                    this.addInternal(i, this.starts[i], start, this.markedAts[i], this.delTimes[i]);
                    ++i;
                }
                if (this.comparator.compare(end, this.starts[i]) <= 0) {
                    this.addInternal(i, start, end, markedAt, delTime);
                    return;
                }
                int cmp = this.comparator.compare(this.ends[i], end);
                if (cmp <= 0) {
                    if (i == this.size - 1) {
                        this.setInternal(i, start, end, markedAt, delTime);
                        return;
                    }
                    this.setInternal(i, start, this.ends[i], markedAt, delTime);
                    if (cmp == 0) {
                        return;
                    }
                    start = this.ends[i];
                    ++i;
                    continue;
                }
                this.addInternal(i, start, end, markedAt, delTime);
                this.setInternal(++i, end, this.ends[i], this.markedAts[i], this.delTimes[i]);
                return;
            }
            if (this.comparator.compare(start, this.starts[i]) < 0) {
                if (this.comparator.compare(end, this.starts[i]) <= 0) {
                    this.addInternal(i, start, end, markedAt, delTime);
                    return;
                }
                this.addInternal(i, start, this.starts[i], markedAt, delTime);
                ++i;
            }
            if (this.comparator.compare(end, this.ends[i]) <= 0) {
                return;
            }
            start = this.ends[i];
            ++i;
        }
        this.addInternal(i, start, end, markedAt, delTime);
    }

    private int capacity() {
        return this.starts.length;
    }

    private void addInternal(int i, ByteBuffer start, ByteBuffer end, long markedAt, int delTime) {
        assert (i >= 0);
        if (this.size == this.capacity()) {
            this.growToFree(i);
        } else if (i < this.size) {
            this.moveElements(i);
        }
        this.setInternal(i, start, end, markedAt, delTime);
        ++this.size;
    }

    private void growToFree(int i) {
        int newLength = this.capacity() * 3 / 2 + 1;
        this.grow(i, newLength);
    }

    private void grow(int newLength) {
        if (this.capacity() < newLength) {
            this.grow(-1, newLength);
        }
    }

    private void grow(int i, int newLength) {
        this.starts = RangeTombstoneList.grow(this.starts, this.size, newLength, i);
        this.ends = RangeTombstoneList.grow(this.ends, this.size, newLength, i);
        this.markedAts = RangeTombstoneList.grow(this.markedAts, this.size, newLength, i);
        this.delTimes = RangeTombstoneList.grow(this.delTimes, this.size, newLength, i);
    }

    private static ByteBuffer[] grow(ByteBuffer[] a, int size, int newLength, int i) {
        if (i < 0 || i >= size) {
            return Arrays.copyOf(a, newLength);
        }
        ByteBuffer[] newA = new ByteBuffer[newLength];
        System.arraycopy(a, 0, newA, 0, i);
        System.arraycopy(a, i, newA, i + 1, size - i);
        return newA;
    }

    private static long[] grow(long[] a, int size, int newLength, int i) {
        if (i < 0 || i >= size) {
            return Arrays.copyOf(a, newLength);
        }
        long[] newA = new long[newLength];
        System.arraycopy(a, 0, newA, 0, i);
        System.arraycopy(a, i, newA, i + 1, size - i);
        return newA;
    }

    private static int[] grow(int[] a, int size, int newLength, int i) {
        if (i < 0 || i >= size) {
            return Arrays.copyOf(a, newLength);
        }
        int[] newA = new int[newLength];
        System.arraycopy(a, 0, newA, 0, i);
        System.arraycopy(a, i, newA, i + 1, size - i);
        return newA;
    }

    private void moveElements(int i) {
        if (i >= this.size) {
            return;
        }
        System.arraycopy(this.starts, i, this.starts, i + 1, this.size - i);
        System.arraycopy(this.ends, i, this.ends, i + 1, this.size - i);
        System.arraycopy(this.markedAts, i, this.markedAts, i + 1, this.size - i);
        System.arraycopy(this.delTimes, i, this.delTimes, i + 1, this.size - i);
    }

    private void setInternal(int i, ByteBuffer start, ByteBuffer end, long markedAt, int delTime) {
        this.starts[i] = start;
        this.ends[i] = end;
        this.markedAts[i] = markedAt;
        this.delTimes[i] = delTime;
    }

    public class InOrderTester {
        private int idx;

        public boolean isDeleted(ByteBuffer name, long timestamp) {
            while (this.idx < RangeTombstoneList.this.size) {
                int cmp = RangeTombstoneList.this.comparator.compare(name, RangeTombstoneList.this.starts[this.idx]);
                if (cmp == 0) {
                    if (this.idx > 0 && RangeTombstoneList.this.comparator.compare(name, RangeTombstoneList.this.ends[this.idx - 1]) == 0 && RangeTombstoneList.this.markedAts[this.idx - 1] > RangeTombstoneList.this.markedAts[this.idx]) {
                        return RangeTombstoneList.this.markedAts[this.idx - 1] >= timestamp;
                    }
                    return RangeTombstoneList.this.markedAts[this.idx] >= timestamp;
                }
                if (cmp < 0) {
                    return false;
                }
                if (RangeTombstoneList.this.comparator.compare(name, RangeTombstoneList.this.ends[this.idx]) <= 0) {
                    return RangeTombstoneList.this.markedAts[this.idx] >= timestamp;
                }
                ++this.idx;
            }
            return false;
        }
    }

    public static class Serializer
    implements IVersionedSerializer<RangeTombstoneList> {
        private Serializer() {
        }

        @Override
        public void serialize(RangeTombstoneList tombstones, DataOutput out, int version) throws IOException {
            if (tombstones == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(tombstones.size);
            for (int i = 0; i < tombstones.size; ++i) {
                ByteBufferUtil.writeWithShortLength(tombstones.starts[i], out);
                ByteBufferUtil.writeWithShortLength(tombstones.ends[i], out);
                out.writeInt(tombstones.delTimes[i]);
                out.writeLong(tombstones.markedAts[i]);
            }
        }

        @Override
        public RangeTombstoneList deserialize(DataInput in, int version) throws IOException {
            throw new UnsupportedOperationException();
        }

        public RangeTombstoneList deserialize(DataInput in, int version, Comparator<ByteBuffer> comparator) throws IOException {
            int size = in.readInt();
            if (size == 0) {
                return null;
            }
            RangeTombstoneList tombstones = new RangeTombstoneList(comparator, size);
            for (int i = 0; i < size; ++i) {
                ByteBuffer start = ByteBufferUtil.readWithShortLength(in);
                ByteBuffer end = ByteBufferUtil.readWithShortLength(in);
                int delTime = in.readInt();
                long markedAt = in.readLong();
                if (version >= 7) {
                    tombstones.setInternal(i, start, end, markedAt, delTime);
                    continue;
                }
                tombstones.add(start, end, markedAt, delTime);
            }
            if (version >= 7) {
                tombstones.size = size;
            }
            return tombstones;
        }

        public long serializedSize(RangeTombstoneList tombstones, TypeSizes typeSizes, int version) {
            if (tombstones == null) {
                return typeSizes.sizeof(0);
            }
            long size = typeSizes.sizeof(tombstones.size);
            for (int i = 0; i < tombstones.size; ++i) {
                int startSize = tombstones.starts[i].remaining();
                size += (long)(typeSizes.sizeof((short)startSize) + startSize);
                int endSize = tombstones.ends[i].remaining();
                size += (long)(typeSizes.sizeof((short)endSize) + endSize);
                size += (long)typeSizes.sizeof(tombstones.delTimes[i]);
                size += (long)typeSizes.sizeof(tombstones.markedAts[i]);
            }
            return size;
        }

        @Override
        public long serializedSize(RangeTombstoneList tombstones, int version) {
            return this.serializedSize(tombstones, TypeSizes.NATIVE, version);
        }
    }
}

