/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingDeque;

public class BoundedStatsDeque
implements Iterable<Long> {
    protected final LinkedBlockingDeque<Long> deque;

    public BoundedStatsDeque(int size) {
        this.deque = new LinkedBlockingDeque(size);
    }

    @Override
    public Iterator<Long> iterator() {
        return this.deque.iterator();
    }

    public int size() {
        return this.deque.size();
    }

    public void clear() {
        this.deque.clear();
    }

    public void add(long i) {
        if (!this.deque.offer(i)) {
            try {
                this.deque.remove();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.deque.offer(i);
        }
    }

    public double sum() {
        double sum = 0.0;
        for (Long interval : this.deque) {
            sum += (double)interval.longValue();
        }
        return sum;
    }

    public double mean() {
        return this.size() > 0 ? this.sum() / (double)this.size() : 0.0;
    }
}

