/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.UnsortedColumns;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang3.StringUtils;

public class RowMutation
implements IMutation {
    public static final RowMutationSerializer serializer = new RowMutationSerializer();
    public static final String FORWARD_TO = "FWD_TO";
    public static final String FORWARD_FROM = "FWD_FRM";
    private final String keyspaceName;
    private final ByteBuffer key;
    private final Map<UUID, ColumnFamily> modifications;

    public RowMutation(String keyspaceName, ByteBuffer key) {
        this(keyspaceName, key, new HashMap<UUID, ColumnFamily>());
    }

    public RowMutation(String keyspaceName, ByteBuffer key, ColumnFamily cf) {
        this(keyspaceName, key, Collections.singletonMap(cf.id(), cf));
    }

    public RowMutation(String keyspaceName, Row row) {
        this(keyspaceName, row.key.key, row.cf);
    }

    protected RowMutation(String keyspaceName, ByteBuffer key, Map<UUID, ColumnFamily> modifications) {
        this.keyspaceName = keyspaceName;
        this.key = key;
        this.modifications = modifications;
    }

    public RowMutation(ByteBuffer key, ColumnFamily cf) {
        this(cf.metadata().ksName, key, cf);
    }

    public RowMutation copy() {
        return new RowMutation(this.keyspaceName, this.key, new HashMap<UUID, ColumnFamily>(this.modifications));
    }

    @Override
    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    @Override
    public Collection<UUID> getColumnFamilyIds() {
        return this.modifications.keySet();
    }

    @Override
    public ByteBuffer key() {
        return this.key;
    }

    @Override
    public Collection<ColumnFamily> getColumnFamilies() {
        return this.modifications.values();
    }

    public ColumnFamily getColumnFamily(UUID cfId) {
        return this.modifications.get(cfId);
    }

    public void add(ColumnFamily columnFamily) {
        assert (columnFamily != null);
        ColumnFamily prev = this.modifications.put(columnFamily.id(), columnFamily);
        if (prev != null) {
            throw new IllegalArgumentException("ColumnFamily " + columnFamily + " already has modifications in this mutation: " + prev);
        }
    }

    public ColumnFamily addOrGet(String cfName) {
        return this.addOrGet(Schema.instance.getCFMetaData(this.keyspaceName, cfName));
    }

    public ColumnFamily addOrGet(CFMetaData cfm) {
        return this.addOrGet(cfm, TreeMapBackedSortedColumns.factory);
    }

    public ColumnFamily addOrGet(CFMetaData cfm, ColumnFamily.Factory factory) {
        ColumnFamily cf = this.modifications.get(cfm.cfId);
        if (cf == null) {
            cf = factory.create(cfm);
            this.modifications.put(cfm.cfId, cf);
        }
        return cf;
    }

    public boolean isEmpty() {
        return this.modifications.isEmpty();
    }

    public void add(String cfName, ByteBuffer name, ByteBuffer value, long timestamp, int timeToLive) {
        this.addOrGet(cfName).addColumn(name, value, timestamp, timeToLive);
    }

    public void addCounter(String cfName, ByteBuffer name, long value) {
        this.addOrGet(cfName).addCounter(name, value);
    }

    public void add(String cfName, ByteBuffer name, ByteBuffer value, long timestamp) {
        this.add(cfName, name, value, timestamp, 0);
    }

    public void delete(String cfName, long timestamp) {
        int localDeleteTime = (int)(System.currentTimeMillis() / 1000L);
        this.addOrGet(cfName).delete(new DeletionInfo(timestamp, localDeleteTime));
    }

    public void delete(String cfName, ByteBuffer name, long timestamp) {
        int localDeleteTime = (int)(System.currentTimeMillis() / 1000L);
        this.addOrGet(cfName).addTombstone(name, localDeleteTime, timestamp);
    }

    public void deleteRange(String cfName, ByteBuffer start, ByteBuffer end, long timestamp) {
        int localDeleteTime = (int)(System.currentTimeMillis() / 1000L);
        this.addOrGet(cfName).addAtom(new RangeTombstone(start, end, timestamp, localDeleteTime));
    }

    @Override
    public void addAll(IMutation m) {
        if (!(m instanceof RowMutation)) {
            throw new IllegalArgumentException();
        }
        RowMutation rm = (RowMutation)m;
        if (!this.keyspaceName.equals(rm.keyspaceName) || !this.key.equals(rm.key)) {
            throw new IllegalArgumentException();
        }
        for (Map.Entry<UUID, ColumnFamily> entry : rm.modifications.entrySet()) {
            ColumnFamily cf = this.modifications.put(entry.getKey(), entry.getValue());
            if (cf == null) continue;
            entry.getValue().resolve(cf);
        }
    }

    @Override
    public void apply() {
        Keyspace ks = Keyspace.open(this.keyspaceName);
        ks.apply(this, ks.getMetadata().durableWrites);
    }

    public void applyUnsafe() {
        Keyspace.open(this.keyspaceName).apply(this, false);
    }

    public MessageOut<RowMutation> createMessage() {
        return this.createMessage(MessagingService.Verb.MUTATION);
    }

    public MessageOut<RowMutation> createMessage(MessagingService.Verb verb) {
        return new MessageOut<RowMutation>(verb, this, serializer);
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean shallow) {
        StringBuilder buff = new StringBuilder("RowMutation(");
        buff.append("keyspace='").append(this.keyspaceName).append('\'');
        buff.append(", key='").append(ByteBufferUtil.bytesToHex(this.key)).append('\'');
        buff.append(", modifications=[");
        if (shallow) {
            ArrayList<String> cfnames = new ArrayList<String>(this.modifications.size());
            for (UUID cfid : this.modifications.keySet()) {
                CFMetaData cfm = Schema.instance.getCFMetaData(cfid);
                cfnames.add(cfm == null ? "-dropped-" : cfm.cfName);
            }
            buff.append(StringUtils.join(cfnames, (String)", "));
        } else {
            buff.append(StringUtils.join(this.modifications.values(), (String)", "));
        }
        return buff.append("])").toString();
    }

    public RowMutation without(UUID cfId) {
        RowMutation rm = new RowMutation(this.keyspaceName, this.key);
        for (Map.Entry<UUID, ColumnFamily> entry : this.modifications.entrySet()) {
            if (entry.getKey().equals(cfId)) continue;
            rm.add(entry.getValue());
        }
        return rm;
    }

    public static class RowMutationSerializer
    implements IVersionedSerializer<RowMutation> {
        @Override
        public void serialize(RowMutation rm, DataOutput out, int version) throws IOException {
            if (version < 7) {
                out.writeUTF(rm.getKeyspaceName());
            }
            ByteBufferUtil.writeWithShortLength(rm.key(), out);
            int size = rm.modifications.size();
            out.writeInt(size);
            assert (size > 0);
            for (Map.Entry entry : rm.modifications.entrySet()) {
                ColumnFamily.serializer.serialize((ColumnFamily)entry.getValue(), out, version);
            }
        }

        public RowMutation deserialize(DataInput in, int version, ColumnSerializer.Flag flag) throws IOException {
            HashMap<UUID, ColumnFamily> modifications;
            String keyspaceName = null;
            if (version < 7) {
                keyspaceName = in.readUTF();
            }
            ByteBuffer key = ByteBufferUtil.readWithShortLength(in);
            int size = in.readInt();
            assert (size > 0);
            if (size == 1) {
                ColumnFamily cf = this.deserializeOneCf(in, version, flag);
                modifications = Collections.singletonMap(cf.id(), cf);
                keyspaceName = cf.metadata().ksName;
            } else {
                modifications = new HashMap();
                for (int i = 0; i < size; ++i) {
                    ColumnFamily cf = this.deserializeOneCf(in, version, flag);
                    modifications.put(cf.id(), cf);
                    keyspaceName = cf.metadata().ksName;
                }
            }
            return new RowMutation(keyspaceName, key, modifications);
        }

        private ColumnFamily deserializeOneCf(DataInput in, int version, ColumnSerializer.Flag flag) throws IOException {
            ColumnFamily cf = ColumnFamily.serializer.deserialize(in, UnsortedColumns.factory, flag, version);
            assert (cf != null);
            return cf;
        }

        @Override
        public RowMutation deserialize(DataInput in, int version) throws IOException {
            return this.deserialize(in, version, ColumnSerializer.Flag.FROM_REMOTE);
        }

        @Override
        public long serializedSize(RowMutation rm, int version) {
            TypeSizes sizes = TypeSizes.NATIVE;
            int size = 0;
            if (version < 7) {
                size += sizes.sizeof(rm.getKeyspaceName());
            }
            int keySize = rm.key().remaining();
            size += sizes.sizeof((short)keySize) + keySize;
            size += sizes.sizeof(rm.modifications.size());
            for (Map.Entry entry : rm.modifications.entrySet()) {
                size = (int)((long)size + ColumnFamily.serializer.serializedSize((ColumnFamily)entry.getValue(), TypeSizes.NATIVE, version));
            }
            return size;
        }
    }
}

