/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnCondition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class UpdateStatement
extends ModificationStatement {
    private static final Operation setToEmptyOperation = new Constants.Setter(null, new Constants.Value(ByteBufferUtil.EMPTY_BYTE_BUFFER));

    private UpdateStatement(ModificationStatement.StatementType type, CFMetaData cfm, Attributes attrs) {
        super(type, cfm, attrs);
    }

    @Override
    public boolean requireFullClusteringKey() {
        return true;
    }

    @Override
    public void addUpdateForKey(ColumnFamily cf, ByteBuffer key, ColumnNameBuilder builder, UpdateParameters params) throws InvalidRequestException {
        CFDefinition cfDef = this.cfm.getCfDef();
        if (builder.getLength() > 65535) {
            throw new InvalidRequestException(String.format("The sum of all clustering columns is too long (%s > %s)", builder.getLength(), 65535));
        }
        if (this.type == ModificationStatement.StatementType.INSERT && cfDef.isComposite && !cfDef.isCompact && !this.cfm.isSuper()) {
            ByteBuffer name = builder.copy().add(ByteBufferUtil.EMPTY_BYTE_BUFFER).build();
            cf.addColumn(params.makeColumn(name, ByteBufferUtil.EMPTY_BYTE_BUFFER));
        }
        List<Operation> updates = this.getOperations();
        if (cfDef.isCompact) {
            if (builder.componentCount() == 0) {
                throw new InvalidRequestException(String.format("Missing PRIMARY KEY part %s", cfDef.clusteringColumns().iterator().next()));
            }
            if (cfDef.compactValue() == null) {
                assert (updates.isEmpty());
                setToEmptyOperation.execute(key, cf, builder.copy(), params);
            } else {
                if (updates.isEmpty()) {
                    throw new InvalidRequestException(String.format("Column %s is mandatory for this COMPACT STORAGE table", cfDef.compactValue()));
                }
                for (Operation update : updates) {
                    update.execute(key, cf, builder.copy(), params);
                }
            }
        } else {
            for (Operation update : updates) {
                update.execute(key, cf, builder.copy(), params);
            }
        }
        SecondaryIndexManager indexManager = Keyspace.open((String)this.cfm.ksName).getColumnFamilyStore((UUID)this.cfm.cfId).indexManager;
        if (indexManager.hasIndexes()) {
            for (Column column : cf) {
                if (indexManager.validate(column)) continue;
                throw new InvalidRequestException(String.format("Can't index column value of size %d for index %s on %s.%s", column.value().remaining(), this.cfm.getColumnDefinitionFromColumnName(column.name()).getIndexName(), this.cfm.ksName, this.cfm.cfName));
            }
        }
    }

    public static class ParsedUpdate
    extends ModificationStatement.Parsed {
        private final List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> updates;
        private final List<Relation> whereClause;

        public ParsedUpdate(CFName name, Attributes.Raw attrs, List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> updates, List<Relation> whereClause, List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions, boolean ifExists) {
            super(name, attrs, conditions, false, ifExists);
            this.updates = updates;
            this.whereClause = whereClause;
        }

        @Override
        protected ModificationStatement prepareInternal(CFDefinition cfDef, VariableSpecifications boundNames, Attributes attrs) throws InvalidRequestException {
            UpdateStatement stmt = new UpdateStatement(ModificationStatement.StatementType.UPDATE, cfDef.cfm, attrs);
            for (Pair<ColumnIdentifier.Raw, Operation.RawUpdate> entry : this.updates) {
                CFDefinition.Name name = cfDef.get(((ColumnIdentifier.Raw)entry.left).prepare(cfDef.cfm));
                if (name == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", entry.left));
                }
                Operation operation = ((Operation.RawUpdate)entry.right).prepare(name);
                operation.collectMarkerSpecification(boundNames);
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s found in SET part", entry.left));
                    }
                    case VALUE_ALIAS: 
                    case COLUMN_METADATA: 
                    case STATIC: {
                        stmt.addOperation(operation);
                    }
                }
            }
            stmt.processWhereClause(this.whereClause, boundNames);
            return stmt;
        }
    }

    public static class ParsedInsert
    extends ModificationStatement.Parsed {
        private final List<ColumnIdentifier.Raw> columnNames;
        private final List<Term.Raw> columnValues;

        public ParsedInsert(CFName name, Attributes.Raw attrs, List<ColumnIdentifier.Raw> columnNames, List<Term.Raw> columnValues, boolean ifNotExists) {
            super(name, attrs, null, ifNotExists, false);
            this.columnNames = columnNames;
            this.columnValues = columnValues;
        }

        @Override
        protected ModificationStatement prepareInternal(CFDefinition cfDef, VariableSpecifications boundNames, Attributes attrs) throws InvalidRequestException {
            UpdateStatement stmt = new UpdateStatement(ModificationStatement.StatementType.INSERT, cfDef.cfm, attrs);
            if (stmt.isCounter()) {
                throw new InvalidRequestException("INSERT statement are not allowed on counter tables, use UPDATE instead");
            }
            if (this.columnNames.size() != this.columnValues.size()) {
                throw new InvalidRequestException("Unmatched column names/values");
            }
            if (this.columnNames.isEmpty()) {
                throw new InvalidRequestException("No columns provided to INSERT");
            }
            block4: for (int i = 0; i < this.columnNames.size(); ++i) {
                ColumnIdentifier id = this.columnNames.get(i).prepare(cfDef.cfm);
                CFDefinition.Name name = cfDef.get(id);
                if (name == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", id));
                }
                for (int j = 0; j < i; ++j) {
                    ColumnIdentifier otherId = this.columnNames.get(j).prepare(cfDef.cfm);
                    if (!id.equals(otherId)) continue;
                    throw new InvalidRequestException(String.format("Multiple definitions found for column %s", id));
                }
                Term.Raw value = this.columnValues.get(i);
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        Term t = value.prepare(name);
                        t.collectMarkerSpecification(boundNames);
                        stmt.addKeyValue(name, t);
                        continue block4;
                    }
                    case VALUE_ALIAS: 
                    case COLUMN_METADATA: 
                    case STATIC: {
                        Operation operation = new Operation.SetValue(value).prepare(name);
                        operation.collectMarkerSpecification(boundNames);
                        stmt.addOperation(operation);
                    }
                }
            }
            return stmt;
        }
    }
}

