/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.util.concurrent.AtomicDouble;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundActivityMonitor {
    private static final Logger logger = LoggerFactory.getLogger(BackgroundActivityMonitor.class);
    public static final int USER_INDEX = 0;
    public static final int NICE_INDEX = 1;
    public static final int SYS_INDEX = 2;
    public static final int IDLE_INDEX = 3;
    public static final int IOWAIT_INDEX = 4;
    public static final int IRQ_INDEX = 5;
    public static final int SOFTIRQ_INDEX = 6;
    private static final String OPERATING_SYSTEM = System.getProperty("os.name").toLowerCase();
    private static final int NUM_CPUS = Runtime.getRuntime().availableProcessors();
    private static final String PROC_STAT_PATH = "/proc/stat";
    private final AtomicDouble compaction_severity = new AtomicDouble();
    private final ScheduledExecutorService reportThread = new DebuggableScheduledThreadPoolExecutor("Background_Reporter");
    private RandomAccessFile statsFile;
    private long[] lastReading;

    public BackgroundActivityMonitor() {
        try {
            this.statsFile = new RandomAccessFile(PROC_STAT_PATH, "r");
            this.lastReading = this.readAndCompute();
        }
        catch (IOException ex) {
            if (BackgroundActivityMonitor.isUnix()) {
                logger.warn("Couldn't open /proc/stats");
            }
            this.statsFile = null;
        }
        this.reportThread.scheduleAtFixedRate(new BackgroundActivityReporter(), 1L, 1L, TimeUnit.SECONDS);
    }

    public static boolean isUnix() {
        return OPERATING_SYSTEM.contains("nix") || OPERATING_SYSTEM.contains("nux") || OPERATING_SYSTEM.contains("aix");
    }

    private long[] readAndCompute() throws IOException {
        this.statsFile.seek(0L);
        StringTokenizer tokenizer = new StringTokenizer(this.statsFile.readLine());
        String name = tokenizer.nextToken();
        assert (name.equalsIgnoreCase("cpu"));
        long[] returned = new long[tokenizer.countTokens()];
        for (int i = 0; i < tokenizer.countTokens(); ++i) {
            returned[i] = Long.parseLong(tokenizer.nextToken());
        }
        return returned;
    }

    private float compareAtIndex(long[] reading1, long[] reading2, int index) {
        long total1 = 0L;
        long total2 = 0L;
        for (int i = 0; i <= 6; ++i) {
            total1 += reading1[i];
            total2 += reading2[i];
        }
        float totalDiff = total2 - total1;
        long intrested2 = reading2[index];
        long intrested1 = reading1[index];
        float diff = intrested2 - intrested1;
        if (diff == 0.0f) {
            return 0.0f;
        }
        return diff / totalDiff * 100.0f;
    }

    public void incrCompactionSeverity(double sev) {
        this.compaction_severity.addAndGet(sev);
    }

    public double getIOWait() throws IOException {
        if (this.statsFile == null) {
            return -1.0;
        }
        long[] newComp = this.readAndCompute();
        double value = this.compareAtIndex(this.lastReading, newComp, 4);
        this.lastReading = newComp;
        return value;
    }

    public double getNormalizedLoadAvg() {
        double avg = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        return avg / (double)NUM_CPUS;
    }

    public double getSeverity(InetAddress endpoint) {
        VersionedValue event;
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state != null && (event = state.getApplicationState(ApplicationState.SEVERITY)) != null) {
            return Double.parseDouble(event.value);
        }
        return 0.0;
    }

    public class BackgroundActivityReporter
    implements Runnable {
        @Override
        public void run() {
            double report;
            block4: {
                report = -1.0;
                try {
                    report = BackgroundActivityMonitor.this.getIOWait();
                }
                catch (IOException e) {
                    if (!BackgroundActivityMonitor.isUnix()) break block4;
                    logger.warn("Couldn't read /proc/stats");
                }
            }
            if (report == -1.0) {
                report = BackgroundActivityMonitor.this.compaction_severity.get();
            }
            if (!Gossiper.instance.isEnabled()) {
                return;
            }
            VersionedValue updated = StorageService.instance.valueFactory.severity(report);
            Gossiper.instance.addLocalApplicationState(ApplicationState.SEVERITY, updated);
        }
    }
}

