/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.metrics.FileCacheMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCacheService {
    private static final Logger logger = LoggerFactory.getLogger(FileCacheService.class);
    private static final long MEMORY_USAGE_THRESHOLD = DatabaseDescriptor.getFileCacheSizeInMB() * 1024 * 1024;
    private static final int AFTER_ACCESS_EXPIRATION = 512;
    public static FileCacheService instance = new FileCacheService();
    private final Cache<String, Queue<RandomAccessReader>> cache;
    private final FileCacheMetrics metrics = new FileCacheMetrics();
    public final Callable<Queue<RandomAccessReader>> cacheForPathCreator = new Callable<Queue<RandomAccessReader>>(){

        @Override
        public Queue<RandomAccessReader> call() throws Exception {
            return new ConcurrentLinkedQueue<RandomAccessReader>();
        }
    };

    protected FileCacheService() {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(512L, TimeUnit.MILLISECONDS).concurrencyLevel(DatabaseDescriptor.getConcurrentReaders()).removalListener((RemovalListener)new RemovalListener<String, Queue<RandomAccessReader>>(){

            public void onRemoval(RemovalNotification<String, Queue<RandomAccessReader>> notification) {
                Queue cachedInstances = (Queue)notification.getValue();
                if (cachedInstances == null) {
                    return;
                }
                for (RandomAccessReader reader : cachedInstances) {
                    reader.deallocate();
                }
            }
        }).build();
    }

    public RandomAccessReader get(String path) {
        this.metrics.requests.mark();
        Queue<RandomAccessReader> instances = this.getCacheFor(path);
        if (instances == null) {
            return null;
        }
        RandomAccessReader result = instances.poll();
        if (result != null) {
            this.metrics.hits.mark();
        }
        return result;
    }

    private Queue<RandomAccessReader> getCacheFor(String path) {
        try {
            return (Queue)this.cache.get((Object)path, this.cacheForPathCreator);
        }
        catch (ExecutionException e) {
            logger.debug("Exception fetching cache", (Throwable)e);
            return null;
        }
    }

    public void put(RandomAccessReader instance) {
        long memoryUsage = (this.cache.size() + 1L) * (long)instance.getBufferSize();
        if (memoryUsage >= MEMORY_USAGE_THRESHOLD) {
            instance.deallocate();
        } else {
            this.getCacheFor(instance.getPath()).add(instance);
        }
    }

    public void invalidate(String path) {
        this.cache.invalidate((Object)path);
    }

    public long sizeInBytes() {
        long n = 0L;
        for (Queue queue : this.cache.asMap().values()) {
            for (RandomAccessReader reader : queue) {
                n += (long)reader.getBufferSize();
            }
        }
        return n;
    }
}

