/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.auth.Auth;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.ISaslAwareAuthenticator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang3.StringUtils;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordAuthenticator
implements ISaslAwareAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(PasswordAuthenticator.class);
    private static final int GENSALT_LOG2_ROUNDS = 10;
    private static final String SALTED_HASH = "salted_hash";
    private static final String DEFAULT_USER_NAME = "cassandra";
    private static final String DEFAULT_USER_PASSWORD = "cassandra";
    private static final String CREDENTIALS_CF = "credentials";
    private static final String CREDENTIALS_CF_SCHEMA = String.format("CREATE TABLE %s.%s (username text,salted_hash text,options map<text,text>,PRIMARY KEY(username)) WITH gc_grace_seconds=%d", "system_auth", "credentials", 7776000);
    private SelectStatement authenticateStatement;

    @Override
    public boolean requireAuthentication() {
        return true;
    }

    @Override
    public Set<IAuthenticator.Option> supportedOptions() {
        return ImmutableSet.of((Object)((Object)IAuthenticator.Option.PASSWORD));
    }

    @Override
    public Set<IAuthenticator.Option> alterableOptions() {
        return ImmutableSet.of((Object)((Object)IAuthenticator.Option.PASSWORD));
    }

    @Override
    public AuthenticatedUser authenticate(Map<String, String> credentials) throws AuthenticationException {
        UntypedResultSet result;
        String username = credentials.get("username");
        if (username == null) {
            throw new AuthenticationException(String.format("Required key '%s' is missing", "username"));
        }
        String password = credentials.get("password");
        if (password == null) {
            throw new AuthenticationException(String.format("Required key '%s' is missing", "password"));
        }
        try {
            ResultMessage.Rows rows = this.authenticateStatement.execute(new QueryState(new ClientState(true)), new QueryOptions(PasswordAuthenticator.consistencyForUser(username), Lists.newArrayList((Object[])new ByteBuffer[]{ByteBufferUtil.bytes(username)})));
            result = new UntypedResultSet(rows.result);
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
        catch (RequestExecutionException e) {
            throw new AuthenticationException(e.toString());
        }
        if (result.isEmpty() || !BCrypt.checkpw((String)password, (String)result.one().getString(SALTED_HASH))) {
            throw new AuthenticationException("Username and/or password are incorrect");
        }
        return new AuthenticatedUser(username);
    }

    @Override
    public void create(String username, Map<IAuthenticator.Option, Object> options) throws InvalidRequestException, RequestExecutionException {
        String password = (String)options.get((Object)IAuthenticator.Option.PASSWORD);
        if (password == null) {
            throw new InvalidRequestException("PasswordAuthenticator requires PASSWORD option");
        }
        PasswordAuthenticator.process(String.format("INSERT INTO %s.%s (username, salted_hash) VALUES ('%s', '%s')", "system_auth", CREDENTIALS_CF, PasswordAuthenticator.escape(username), PasswordAuthenticator.escape(PasswordAuthenticator.hashpw(password))), PasswordAuthenticator.consistencyForUser(username));
    }

    @Override
    public void alter(String username, Map<IAuthenticator.Option, Object> options) throws RequestExecutionException {
        PasswordAuthenticator.process(String.format("UPDATE %s.%s SET salted_hash = '%s' WHERE username = '%s'", "system_auth", CREDENTIALS_CF, PasswordAuthenticator.escape(PasswordAuthenticator.hashpw((String)options.get((Object)IAuthenticator.Option.PASSWORD))), PasswordAuthenticator.escape(username)), PasswordAuthenticator.consistencyForUser(username));
    }

    @Override
    public void drop(String username) throws RequestExecutionException {
        PasswordAuthenticator.process(String.format("DELETE FROM %s.%s WHERE username = '%s'", "system_auth", CREDENTIALS_CF, PasswordAuthenticator.escape(username)), PasswordAuthenticator.consistencyForUser(username));
    }

    public Set<DataResource> protectedResources() {
        return ImmutableSet.of((Object)DataResource.columnFamily("system_auth", CREDENTIALS_CF));
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
    }

    @Override
    public void setup() {
        this.setupCredentialsTable();
        if (DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddress()) || !DatabaseDescriptor.isAutoBootstrap()) {
            StorageService.tasks.schedule(new Runnable(){

                @Override
                public void run() {
                    PasswordAuthenticator.this.setupDefaultUser();
                }
            }, Auth.SUPERUSER_SETUP_DELAY, TimeUnit.MILLISECONDS);
        }
        try {
            String query = String.format("SELECT %s FROM %s.%s WHERE username = ?", SALTED_HASH, "system_auth", CREDENTIALS_CF);
            this.authenticateStatement = (SelectStatement)QueryProcessor.parseStatement((String)query).prepare().statement;
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ISaslAwareAuthenticator.SaslAuthenticator newAuthenticator() {
        return new PlainTextSaslAuthenticator();
    }

    private void setupCredentialsTable() {
        if (Schema.instance.getCFMetaData("system_auth", CREDENTIALS_CF) == null) {
            try {
                PasswordAuthenticator.process(CREDENTIALS_CF_SCHEMA, ConsistencyLevel.ANY);
            }
            catch (RequestExecutionException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private void setupDefaultUser() {
        try {
            if (PasswordAuthenticator.process(String.format("SELECT * FROM %s.%s", "system_auth", CREDENTIALS_CF), ConsistencyLevel.QUORUM).isEmpty()) {
                PasswordAuthenticator.process(String.format("INSERT INTO %s.%s (username, salted_hash) VALUES ('%s', '%s') USING TIMESTAMP 0", "system_auth", CREDENTIALS_CF, "cassandra", PasswordAuthenticator.escape(PasswordAuthenticator.hashpw("cassandra"))), ConsistencyLevel.QUORUM);
                logger.info("PasswordAuthenticator created default user '{}'", (Object)"cassandra");
            }
        }
        catch (RequestExecutionException e) {
            logger.warn("PasswordAuthenticator skipped default user setup: some nodes were not ready");
        }
    }

    private static String hashpw(String password) {
        return BCrypt.hashpw((String)password, (String)BCrypt.gensalt((int)10));
    }

    private static String escape(String name) {
        return StringUtils.replace((String)name, (String)"'", (String)"''");
    }

    private static UntypedResultSet process(String query, ConsistencyLevel cl) throws RequestExecutionException {
        return QueryProcessor.process(query, cl);
    }

    private static ConsistencyLevel consistencyForUser(String username) {
        if (username.equals("cassandra")) {
            return ConsistencyLevel.QUORUM;
        }
        return ConsistencyLevel.ONE;
    }

    private class PlainTextSaslAuthenticator
    implements ISaslAwareAuthenticator.SaslAuthenticator {
        private static final byte NUL = 0;
        private final Charset UTF8_CHARSET = Charset.forName("UTF-8");
        private boolean complete = false;
        private Map<String, String> credentials;

        private PlainTextSaslAuthenticator() {
        }

        @Override
        public byte[] evaluateResponse(byte[] clientResponse) throws AuthenticationException {
            this.credentials = this.decodeCredentials(clientResponse);
            this.complete = true;
            return null;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public AuthenticatedUser getAuthenticatedUser() throws AuthenticationException {
            return PasswordAuthenticator.this.authenticate(this.credentials);
        }

        private Map<String, String> decodeCredentials(byte[] bytes) throws AuthenticationException {
            logger.debug("Decoding credentials from client token");
            byte[] user = null;
            byte[] pass = null;
            int end = bytes.length;
            for (int i = bytes.length - 1; i >= 0; --i) {
                if (bytes[i] != 0) continue;
                if (pass == null) {
                    pass = Arrays.copyOfRange(bytes, i + 1, end);
                } else if (user == null) {
                    user = Arrays.copyOfRange(bytes, i + 1, end);
                }
                end = i;
            }
            if (user == null) {
                throw new AuthenticationException("Authentication ID must not be null");
            }
            if (pass == null) {
                throw new AuthenticationException("Password must not be null");
            }
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("username", new String(user, this.UTF8_CHARSET));
            credentials.put("password", new String(pass, this.UTF8_CHARSET));
            return credentials;
        }
    }
}

