/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.FrameCompressor;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.SimpleClient;
import org.apache.cassandra.transport.messages.AuthResponse;
import org.apache.cassandra.transport.messages.CredentialsMessage;
import org.apache.cassandra.transport.messages.ExecuteMessage;
import org.apache.cassandra.transport.messages.OptionsMessage;
import org.apache.cassandra.transport.messages.PrepareMessage;
import org.apache.cassandra.transport.messages.QueryMessage;
import org.apache.cassandra.transport.messages.RegisterMessage;
import org.apache.cassandra.transport.messages.StartupMessage;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.MD5Digest;

public class Client
extends SimpleClient {
    public Client(String host, int port, EncryptionOptions.ClientEncryptionOptions encryptionOptions) {
        super(host, port, encryptionOptions);
    }

    public void run() throws IOException {
        System.out.print("Connecting...");
        this.establishConnection();
        System.out.println();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print(">> ");
            System.out.flush();
            String line = in.readLine();
            if (line == null) break;
            Message.Request req = this.parseLine(line.trim());
            if (req == null) {
                System.out.println("! Error parsing line.");
                continue;
            }
            try {
                Message.Response resp = this.execute(req);
                System.out.println("-> " + resp);
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e.getMessage());
            }
        }
        this.close();
    }

    private Message.Request parseLine(String line) {
        Splitter splitter = Splitter.on((char)' ').trimResults().omitEmptyStrings();
        Iterator<String> iter = splitter.split((CharSequence)line).iterator();
        if (!iter.hasNext()) {
            return null;
        }
        String msgType = ((String)iter.next()).toUpperCase();
        if (msgType.equals("STARTUP")) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("CQL_VERSION", "3.0.0");
            while (iter.hasNext()) {
                String next = (String)iter.next();
                if (!next.toLowerCase().equals("snappy")) continue;
                options.put("COMPRESSION", "snappy");
                this.connection.setCompressor(FrameCompressor.SnappyCompressor.instance);
            }
            return new StartupMessage(options);
        }
        if (msgType.equals("QUERY")) {
            String query = line = line.substring(6);
            int pageSize = -1;
            if (line.matches(".+ !\\d+$")) {
                int idx = line.lastIndexOf(33);
                query = line.substring(0, idx - 1);
                try {
                    pageSize = Integer.parseInt(line.substring(idx + 1, line.length()));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return new QueryMessage(query, new QueryOptions(ConsistencyLevel.ONE, Collections.emptyList(), false, pageSize, null, null));
        }
        if (msgType.equals("PREPARE")) {
            String query = line.substring(8);
            return new PrepareMessage(query);
        }
        if (msgType.equals("EXECUTE")) {
            try {
                byte[] id = Hex.hexToBytes((String)iter.next());
                ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>();
                while (iter.hasNext()) {
                    ByteBuffer bb;
                    String next = (String)iter.next();
                    try {
                        int v = Integer.parseInt(next);
                        bb = Int32Type.instance.decompose(v);
                    }
                    catch (NumberFormatException e) {
                        bb = UTF8Type.instance.decompose(next);
                    }
                    values.add(bb);
                }
                return new ExecuteMessage(MD5Digest.wrap(id), new QueryOptions(ConsistencyLevel.ONE, values));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (msgType.equals("OPTIONS")) {
            return new OptionsMessage();
        }
        if (msgType.equals("CREDENTIALS")) {
            System.err.println("[WARN] CREDENTIALS command is deprecated, use AUTHENTICATE instead");
            CredentialsMessage msg = new CredentialsMessage();
            msg.credentials.putAll(this.readCredentials(iter));
            return msg;
        }
        if (msgType.equals("AUTHENTICATE")) {
            Map<String, String> credentials = this.readCredentials(iter);
            if (!credentials.containsKey("username") || !credentials.containsKey("password")) {
                System.err.println("[ERROR] Authentication requires both 'username' and 'password'");
                return null;
            }
            return new AuthResponse(this.encodeCredentialsForSasl(credentials));
        }
        if (msgType.equals("REGISTER")) {
            String type = line.substring(9).toUpperCase();
            try {
                return new RegisterMessage(Collections.singletonList(Enum.valueOf(Event.Type.class, type)));
            }
            catch (IllegalArgumentException e) {
                System.err.println("[ERROR] Unknown event type: " + type);
                return null;
            }
        }
        return null;
    }

    private Map<String, String> readCredentials(Iterator<String> iter) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        while (iter.hasNext()) {
            String next = iter.next();
            String[] kv = next.split("=");
            if (kv.length != 2) {
                System.err.println("[ERROR] Default authentication requires username & password");
                return null;
            }
            credentials.put(kv[0], kv[1]);
        }
        return credentials;
    }

    private byte[] encodeCredentialsForSasl(Map<String, String> credentials) {
        byte[] username = credentials.get("username").getBytes(Charset.forName("UTF-8"));
        byte[] password = credentials.get("password").getBytes(Charset.forName("UTF-8"));
        byte[] initialResponse = new byte[username.length + password.length + 2];
        initialResponse[0] = 0;
        System.arraycopy(username, 0, initialResponse, 1, username.length);
        initialResponse[username.length + 1] = 0;
        System.arraycopy(password, 0, initialResponse, username.length + 2, password.length);
        return initialResponse;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + Client.class.getSimpleName() + " <host> <port>");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        EncryptionOptions.ClientEncryptionOptions encryptionOptions = new EncryptionOptions.ClientEncryptionOptions();
        System.out.println("CQL binary protocol console " + host + "@" + port);
        new Client(host, port, encryptionOptions).run();
        System.exit(0);
    }
}

