/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.AbstractRowResolver;
import org.apache.cassandra.service.DigestMismatchException;

public class RowDigestResolver
extends AbstractRowResolver {
    public RowDigestResolver(String keyspaceName, ByteBuffer key) {
        super(key, keyspaceName);
    }

    @Override
    public Row getData() {
        for (MessageIn message : this.replies) {
            ReadResponse result = (ReadResponse)message.payload;
            if (result.isDigestQuery()) continue;
            return result.row();
        }
        return null;
    }

    @Override
    public Row resolve() throws DigestMismatchException {
        if (logger.isDebugEnabled()) {
            logger.debug("resolving " + this.replies.size() + " responses");
        }
        long start = System.nanoTime();
        ColumnFamily data = null;
        ByteBuffer digest = null;
        for (MessageIn message : this.replies) {
            ReadResponse response = (ReadResponse)message.payload;
            if (response.isDigestQuery()) {
                if (digest == null) {
                    digest = response.digest();
                    continue;
                }
                ByteBuffer digest2 = response.digest();
                if (digest.equals(digest2)) continue;
                throw new DigestMismatchException(this.key, digest, digest2);
            }
            data = response.row().cf;
        }
        if (digest != null) {
            ByteBuffer digest2 = ColumnFamily.digest(data);
            if (!digest.equals(digest2)) {
                throw new DigestMismatchException(this.key, digest, digest2);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("digests verified");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("resolve: {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        }
        return new Row(this.key, data);
    }

    @Override
    public boolean isDataPresent() {
        for (MessageIn message : this.replies) {
            if (((ReadResponse)message.payload).isDigestQuery()) continue;
            return true;
        }
        return false;
    }
}

