/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Collections;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIndexStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(CreateIndexStatement.class);
    private final String indexName;
    private final ColumnIdentifier columnName;
    private final boolean ifNotExists;
    private final boolean isCustom;
    private final String indexClass;

    public CreateIndexStatement(CFName name, String indexName, ColumnIdentifier columnName, boolean ifNotExists, boolean isCustom, String indexClass) {
        super(name);
        this.indexName = indexName;
        this.columnName = columnName;
        this.ifNotExists = ifNotExists;
        this.isCustom = isCustom;
        this.indexClass = indexClass;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        ColumnDefinition cd = cfm.getColumnDefinition(this.columnName.key);
        if (cd == null) {
            throw new InvalidRequestException("No column definition found for column " + this.columnName);
        }
        if (cd.getIndexType() != null) {
            if (this.ifNotExists) {
                return;
            }
            throw new InvalidRequestException("Index already exists");
        }
        if (this.isCustom && this.indexClass == null) {
            throw new InvalidRequestException("CUSTOM index requires specifiying the index class");
        }
        if (!this.isCustom && this.indexClass != null) {
            throw new InvalidRequestException("Cannot specify index class for a non-CUSTOM index");
        }
        if (cfm.getCfDef().isCompact && cd.type != ColumnDefinition.Type.REGULAR) {
            throw new InvalidRequestException(String.format("Secondary index on %s column %s is not yet supported for compact table", new Object[]{cd.type, this.columnName}));
        }
        if (cd.getValidator().isCollection() && !this.isCustom) {
            throw new InvalidRequestException("Indexes on collections are no yet supported");
        }
        if (cd.type == ColumnDefinition.Type.PARTITION_KEY && cd.componentIndex == null) {
            throw new InvalidRequestException(String.format("Cannot add secondary index to already primarily indexed column %s", this.columnName));
        }
    }

    @Override
    public void announceMigration() throws InvalidRequestException, ConfigurationException {
        logger.debug("Updating column {} definition for index {}", (Object)this.columnName, (Object)this.indexName);
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily()).clone();
        ColumnDefinition cd = cfm.getColumnDefinition(this.columnName.key);
        if (cd.getIndexType() != null && this.ifNotExists) {
            return;
        }
        if (this.isCustom) {
            cd.setIndexType(IndexType.CUSTOM, Collections.singletonMap("class_name", this.indexClass));
        } else if (cfm.getCfDef().isComposite) {
            cd.setIndexType(IndexType.COMPOSITES, Collections.emptyMap());
        } else {
            cd.setIndexType(IndexType.KEYS, Collections.emptyMap());
        }
        cd.setIndexName(this.indexName);
        cfm.addDefaultIndexNames();
        MigrationManager.announceColumnFamilyUpdate(cfm, false);
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.UPDATED;
    }
}

