/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class SimpleCondition
implements Condition {
    private boolean set;

    @Override
    public synchronized void await() throws InterruptedException {
        while (!this.set) {
            this.wait();
        }
    }

    public synchronized void reset() {
        this.set = false;
    }

    @Override
    public synchronized boolean await(long time, TimeUnit unit) throws InterruptedException {
        long elapsed;
        long start = System.nanoTime();
        long timeout = unit.toNanos(time);
        while (!this.set && (elapsed = System.nanoTime() - start) < timeout) {
            TimeUnit.NANOSECONDS.timedWait(this, timeout - elapsed);
        }
        return this.set;
    }

    @Override
    public void signal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void signalAll() {
        this.set = true;
        this.notifyAll();
    }

    public synchronized boolean isSignaled() {
        return this.set;
    }

    @Override
    public void awaitUninterruptibly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long awaitNanos(long nanosTimeout) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean awaitUntil(Date deadline) throws InterruptedException {
        throw new UnsupportedOperationException();
    }
}

