/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.pager.AbstractQueryPager;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.SinglePartitionPager;

public class SliceQueryPager
extends AbstractQueryPager
implements SinglePartitionPager {
    private final SliceFromReadCommand command;
    private volatile ByteBuffer lastReturned;

    SliceQueryPager(SliceFromReadCommand command, ConsistencyLevel consistencyLevel, boolean localQuery) {
        super(consistencyLevel, command.filter.count, localQuery, command.ksName, command.cfName, command.filter, command.timestamp);
        this.command = command;
    }

    SliceQueryPager(SliceFromReadCommand command, ConsistencyLevel consistencyLevel, boolean localQuery, PagingState state) {
        this(command, consistencyLevel, localQuery);
        if (state != null) {
            this.lastReturned = state.cellName;
            this.restoreState(state.remaining, true);
        }
    }

    @Override
    public PagingState state() {
        return this.lastReturned == null ? null : new PagingState(null, this.lastReturned, this.maxRemaining());
    }

    @Override
    protected List<Row> queryNextPage(int pageSize, ConsistencyLevel consistencyLevel, boolean localQuery) throws RequestValidationException, RequestExecutionException {
        SliceQueryFilter filter = this.command.filter.withUpdatedCount(pageSize);
        if (this.lastReturned != null) {
            filter = filter.withUpdatedStart(this.lastReturned, this.cfm.comparator);
        }
        SliceFromReadCommand pageCmd = this.command.withUpdatedFilter(filter);
        return localQuery ? Collections.singletonList(((ReadCommand)pageCmd).getRow(Keyspace.open(this.command.ksName))) : StorageProxy.read(Collections.singletonList(pageCmd), consistencyLevel);
    }

    @Override
    protected boolean containsPreviousLast(Row first) {
        return this.lastReturned != null && this.lastReturned.equals(SliceQueryPager.firstName(first.cf));
    }

    @Override
    protected boolean recordLast(Row last) {
        this.lastReturned = SliceQueryPager.lastName(last.cf);
        return true;
    }
}

