/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.StorageService;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRowResolver
implements IResponseResolver<ReadResponse, Row> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRowResolver.class);
    protected final String keyspaceName;
    protected final Set<MessageIn<ReadResponse>> replies = new NonBlockingHashSet();
    protected final DecoratedKey key;

    public AbstractRowResolver(ByteBuffer key, String keyspaceName) {
        this.key = StorageService.getPartitioner().decorateKey(key);
        this.keyspaceName = keyspaceName;
    }

    @Override
    public boolean preprocess(MessageIn<ReadResponse> message) {
        MessageIn<ReadResponse> toReplace = null;
        for (MessageIn<ReadResponse> reply : this.replies) {
            if (!reply.from.equals(message.from)) continue;
            if (((ReadResponse)message.payload).isDigestQuery()) break;
            toReplace = reply;
            break;
        }
        if (toReplace != null) {
            this.replies.remove(toReplace);
            this.replies.add(message);
            return false;
        }
        this.replies.add(message);
        return true;
    }

    @Override
    public Iterable<MessageIn<ReadResponse>> getMessages() {
        return this.replies;
    }
}

