/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.exceptions;

import org.apache.cassandra.exceptions.ExceptionCode;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.utils.MD5Digest;

public class PreparedQueryNotFoundException
extends RequestValidationException {
    public final MD5Digest id;

    public PreparedQueryNotFoundException(MD5Digest id) {
        super(ExceptionCode.UNPREPARED, PreparedQueryNotFoundException.makeMsg(id));
        this.id = id;
    }

    private static String makeMsg(MD5Digest id) {
        return String.format("Prepared query with ID %s not found (either the query was not prepared on this host (maybe the host has been restarted?) or you have prepared more than %d queries and query %s has been evicted from the internal cache)", id, 100000, id);
    }
}

