/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.Pair;

public class DeleteStatement
extends ModificationStatement {
    private DeleteStatement(int boundTerms, CFMetaData cfm, Attributes attrs) {
        super(boundTerms, cfm, attrs);
    }

    @Override
    protected boolean requireFullClusteringKey() {
        return false;
    }

    @Override
    public ColumnFamily updateForKey(ByteBuffer key, ColumnNameBuilder builder, UpdateParameters params) throws InvalidRequestException {
        boolean isRange;
        boolean fullKey;
        CFDefinition cfDef = this.cfm.getCfDef();
        TreeMapBackedSortedColumns cf = TreeMapBackedSortedColumns.factory.create(this.cfm);
        List<Operation> deletions = this.getOperations();
        boolean bl = fullKey = builder.componentCount() == cfDef.columns.size();
        boolean bl2 = cfDef.isCompact ? !fullKey : (isRange = !fullKey || deletions.isEmpty());
        if (!deletions.isEmpty() && isRange) {
            throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s since %s specified", this.getFirstEmptyKey(), deletions.get((int)0).columnName));
        }
        if (deletions.isEmpty() && builder.componentCount() == 0) {
            ((ColumnFamily)cf).delete(new DeletionInfo(params.timestamp, params.localDeletionTime));
        } else if (isRange) {
            assert (deletions.isEmpty());
            ByteBuffer start = builder.build();
            ByteBuffer end = builder.buildAsEndOfRange();
            cf.addAtom(params.makeRangeTombstone(start, end));
        } else if (cfDef.isCompact) {
            ByteBuffer columnName = builder.build();
            cf.addColumn(params.makeTombstone(columnName));
        } else {
            for (Operation deletion : deletions) {
                deletion.execute(key, cf, builder.copy(), params);
            }
        }
        return cf;
    }

    public static class Parsed
    extends ModificationStatement.Parsed {
        private final List<Operation.RawDeletion> deletions;
        private final List<Relation> whereClause;

        public Parsed(CFName name, Attributes.Raw attrs, List<Operation.RawDeletion> deletions, List<Relation> whereClause, List<Pair<ColumnIdentifier, Operation.RawUpdate>> conditions) {
            super(name, attrs, conditions, false);
            this.deletions = deletions;
            this.whereClause = whereClause;
        }

        @Override
        protected ModificationStatement prepareInternal(CFDefinition cfDef, ColumnSpecification[] boundNames, Attributes attrs) throws InvalidRequestException {
            DeleteStatement stmt = new DeleteStatement(this.getBoundsTerms(), cfDef.cfm, attrs);
            for (Operation.RawDeletion deletion : this.deletions) {
                CFDefinition.Name name = cfDef.get(deletion.affectedColumn());
                if (name == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", deletion.affectedColumn()));
                }
                if (name.kind != CFDefinition.Name.Kind.COLUMN_METADATA && name.kind != CFDefinition.Name.Kind.VALUE_ALIAS) {
                    throw new InvalidRequestException(String.format("Invalid identifier %s for deletion (should not be a PRIMARY KEY part)", name));
                }
                Operation op = deletion.prepare(name);
                op.collectMarkerSpecification(boundNames);
                stmt.addOperation(op);
            }
            stmt.processWhereClause(this.whereClause, boundNames);
            return stmt;
        }
    }
}

