/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.transport.CBCodec;
import org.apache.cassandra.transport.CBUtil;
import org.jboss.netty.buffer.ChannelBuffer;

public class QueryOptions {
    public static final QueryOptions DEFAULT = new QueryOptions(ConsistencyLevel.ONE, Collections.emptyList());
    public static final CBCodec<QueryOptions> codec = new Codec();
    private final ConsistencyLevel consistency;
    private final List<ByteBuffer> values;
    private final boolean skipMetadata;
    private final SpecificOptions options;

    public QueryOptions(ConsistencyLevel consistency, List<ByteBuffer> values) {
        this(consistency, values, false, SpecificOptions.DEFAULT);
    }

    public QueryOptions(ConsistencyLevel consistency, List<ByteBuffer> values, boolean skipMetadata, int pageSize, PagingState pagingState, ConsistencyLevel serialConsistency) {
        this(consistency, values, skipMetadata, new SpecificOptions(pageSize, pagingState, serialConsistency));
    }

    private QueryOptions(ConsistencyLevel consistency, List<ByteBuffer> values, boolean skipMetadata, SpecificOptions options) {
        this.consistency = consistency;
        this.values = values;
        this.skipMetadata = skipMetadata;
        this.options = options;
    }

    public ConsistencyLevel getConsistency() {
        return this.consistency;
    }

    public List<ByteBuffer> getValues() {
        return this.values;
    }

    public boolean skipMetadata() {
        return this.skipMetadata;
    }

    public int getPageSize() {
        return this.options.pageSize;
    }

    public PagingState getPagingState() {
        return this.options.state;
    }

    public ConsistencyLevel getSerialConsistency() {
        return this.options.serialConsistency;
    }

    private static class Codec
    implements CBCodec<QueryOptions> {
        private Codec() {
        }

        @Override
        public QueryOptions decode(ChannelBuffer body, int version) {
            int paramCount;
            assert (version >= 2);
            ConsistencyLevel consistency = CBUtil.readConsistencyLevel(body);
            EnumSet<Flag> flags = Flag.deserialize(body.readByte());
            List values = Collections.emptyList();
            if (flags.contains((Object)Flag.VALUES) && (paramCount = body.readUnsignedShort()) > 0) {
                values = new ArrayList(paramCount);
                for (int i = 0; i < paramCount; ++i) {
                    values.add(CBUtil.readValue(body));
                }
            }
            boolean skipMetadata = flags.contains((Object)Flag.SKIP_METADATA);
            flags.remove((Object)Flag.VALUES);
            flags.remove((Object)Flag.SKIP_METADATA);
            SpecificOptions options = SpecificOptions.DEFAULT;
            if (!flags.isEmpty()) {
                int pageSize = flags.contains((Object)Flag.PAGE_SIZE) ? body.readInt() : -1;
                PagingState pagingState = flags.contains((Object)Flag.PAGING_STATE) ? PagingState.deserialize(CBUtil.readValue(body)) : null;
                ConsistencyLevel serialConsistency = flags.contains((Object)Flag.SERIAL_CONSISTENCY) ? CBUtil.readConsistencyLevel(body) : ConsistencyLevel.SERIAL;
                options = new SpecificOptions(pageSize, pagingState, serialConsistency);
            }
            return new QueryOptions(consistency, values, skipMetadata, options);
        }

        @Override
        public ChannelBuffer encode(QueryOptions options, int version) {
            assert (version >= 2);
            int nbBuff = 2;
            EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
            if (options.getValues().size() > 0) {
                flags.add(Flag.VALUES);
                ++nbBuff;
            }
            if (options.skipMetadata) {
                flags.add(Flag.SKIP_METADATA);
            }
            if (options.getPageSize() >= 0) {
                flags.add(Flag.PAGE_SIZE);
                ++nbBuff;
            }
            if (options.getSerialConsistency() != ConsistencyLevel.SERIAL) {
                flags.add(Flag.SERIAL_CONSISTENCY);
                ++nbBuff;
            }
            CBUtil.BufferBuilder builder = new CBUtil.BufferBuilder(nbBuff, 0, options.values.size() + (flags.contains((Object)Flag.PAGING_STATE) ? 1 : 0));
            builder.add(CBUtil.consistencyLevelToCB(options.getConsistency()));
            builder.add(CBUtil.byteToCB((byte)Flag.serialize(flags)));
            if (flags.contains((Object)Flag.VALUES)) {
                builder.add(CBUtil.shortToCB(options.getValues().size()));
                for (ByteBuffer value : options.getValues()) {
                    builder.addValue(value);
                }
            }
            if (flags.contains((Object)Flag.PAGE_SIZE)) {
                builder.add(CBUtil.intToCB(options.getPageSize()));
            }
            if (flags.contains((Object)Flag.PAGING_STATE)) {
                builder.addValue(options.getPagingState().serialize());
            }
            if (flags.contains((Object)Flag.SERIAL_CONSISTENCY)) {
                builder.add(CBUtil.consistencyLevelToCB(options.getSerialConsistency()));
            }
            return builder.build();
        }

        private static enum Flag {
            VALUES,
            SKIP_METADATA,
            PAGE_SIZE,
            PAGING_STATE,
            SERIAL_CONSISTENCY;


            public static EnumSet<Flag> deserialize(int flags) {
                EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                Flag[] values = Flag.values();
                for (int n = 0; n < values.length; ++n) {
                    if ((flags & 1 << n) == 0) continue;
                    set.add(values[n]);
                }
                return set;
            }

            public static int serialize(EnumSet<Flag> flags) {
                int i = 0;
                for (Flag flag : flags) {
                    i |= 1 << flag.ordinal();
                }
                return i;
            }
        }
    }

    private static class SpecificOptions {
        private static final SpecificOptions DEFAULT = new SpecificOptions(-1, null, null);
        private final int pageSize;
        private final PagingState state;
        private final ConsistencyLevel serialConsistency;

        private SpecificOptions(int pageSize, PagingState state, ConsistencyLevel serialConsistency) {
            this.pageSize = pageSize;
            this.state = state;
            this.serialConsistency = serialConsistency == null ? ConsistencyLevel.SERIAL : serialConsistency;
        }
    }
}

