/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class AbstractMarker
extends Term.NonTerminal {
    protected final int bindIndex;
    protected final ColumnSpecification receiver;

    protected AbstractMarker(int bindIndex, ColumnSpecification receiver) {
        this.bindIndex = bindIndex;
        this.receiver = receiver;
    }

    @Override
    public void collectMarkerSpecification(ColumnSpecification[] boundNames) {
        boundNames[this.bindIndex] = this.receiver;
    }

    @Override
    public boolean containsBindMarker() {
        return true;
    }

    public static class Raw
    implements Term.Raw {
        protected final int bindIndex;

        public Raw(int bindIndex) {
            this.bindIndex = bindIndex;
        }

        @Override
        public AbstractMarker prepare(ColumnSpecification receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof CollectionType)) {
                return new Constants.Marker(this.bindIndex, receiver);
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return new Lists.Marker(this.bindIndex, receiver);
                }
                case SET: {
                    return new Sets.Marker(this.bindIndex, receiver);
                }
                case MAP: {
                    return new Maps.Marker(this.bindIndex, receiver);
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean isAssignableTo(ColumnSpecification receiver) {
            return true;
        }

        public String toString() {
            return "?";
        }
    }
}

