/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.collect.AbstractIterator;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.util.Iterator;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.IColumnIteratorFactory;
import org.apache.cassandra.db.columniterator.LazyColumnIterator;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.ICompactionScanner;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SSTableScanner
implements ICompactionScanner {
    protected final RandomAccessReader dfile;
    protected final RandomAccessReader ifile;
    public final SSTableReader sstable;
    private final DataRange dataRange;
    private boolean hasSeeked;
    private long stopAt;
    protected Iterator<OnDiskAtomIterator> iterator;

    SSTableScanner(SSTableReader sstable, DataRange dataRange, RateLimiter limiter) {
        assert (sstable != null);
        this.dfile = limiter == null ? sstable.openDataReader() : sstable.openDataReader(limiter);
        this.ifile = sstable.openIndexReader();
        this.sstable = sstable;
        this.dataRange = dataRange;
        this.stopAt = this.computeStopAt();
        if (dataRange.stopKey().isMinimum(sstable.partitioner) || !dataRange.isWrapAround()) {
            this.seekToStart();
        }
    }

    private void seekToStart() {
        this.hasSeeked = true;
        if (this.dataRange.startKey().isMinimum(this.sstable.partitioner)) {
            return;
        }
        long indexPosition = this.sstable.getIndexScanPosition(this.dataRange.startKey());
        if (indexPosition == -1L) {
            return;
        }
        this.ifile.seek(indexPosition);
        try {
            while (!this.ifile.isEOF()) {
                indexPosition = this.ifile.getFilePointer();
                DecoratedKey indexDecoratedKey = this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(this.ifile));
                int comparison = indexDecoratedKey.compareTo(this.dataRange.startKey());
                if (comparison >= 0) {
                    long dataPosition = this.ifile.readLong();
                    this.ifile.seek(indexPosition);
                    this.dfile.seek(dataPosition);
                    break;
                }
                RowIndexEntry.serializer.skip(this.ifile);
            }
        }
        catch (IOException e) {
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, this.sstable.getFilename());
        }
    }

    private long computeStopAt() {
        if (this.dataRange.stopKey().isMinimum(this.sstable.partitioner)) {
            return this.dfile.length();
        }
        RowIndexEntry position = this.sstable.getPosition(this.dataRange.stopKey(), SSTableReader.Operator.GT);
        return position == null ? this.dfile.length() : position.position;
    }

    @Override
    public void close() throws IOException {
        FileUtils.close(this.dfile, this.ifile);
    }

    @Override
    public long getLengthInBytes() {
        return this.dfile.length();
    }

    @Override
    public long getCurrentPosition() {
        return this.dfile.getFilePointer();
    }

    @Override
    public String getBackingFiles() {
        return this.sstable.toString();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public OnDiskAtomIterator next() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Iterator<OnDiskAtomIterator> createIterator() {
        return new KeyScanningIterator();
    }

    private boolean isDone(long current) {
        if (current < this.stopAt) {
            return false;
        }
        if (!this.hasSeeked) {
            this.seekToStart();
            this.stopAt = this.dfile.length();
        }
        return current >= this.stopAt;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "dfile=" + this.dfile + " ifile=" + this.ifile + " sstable=" + this.sstable + ")";
    }

    protected class KeyScanningIterator
    extends AbstractIterator<OnDiskAtomIterator> {
        private DecoratedKey nextKey;
        private RowIndexEntry nextEntry;
        private DecoratedKey currentKey;
        private RowIndexEntry currentEntry;

        protected KeyScanningIterator() {
        }

        protected OnDiskAtomIterator computeNext() {
            try {
                if (SSTableScanner.this.ifile.isEOF() && this.nextKey == null) {
                    return (OnDiskAtomIterator)this.endOfData();
                }
                if (this.currentKey == null) {
                    this.currentKey = SSTableScanner.this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(SSTableScanner.this.ifile));
                    this.currentEntry = RowIndexEntry.serializer.deserialize(SSTableScanner.this.ifile, SSTableScanner.this.sstable.descriptor.version);
                } else {
                    this.currentKey = this.nextKey;
                    this.currentEntry = this.nextEntry;
                }
                assert (this.currentEntry.position <= SSTableScanner.this.stopAt);
                if (SSTableScanner.this.isDone(this.currentEntry.position)) {
                    return (OnDiskAtomIterator)this.endOfData();
                }
                if (SSTableScanner.this.ifile.isEOF()) {
                    this.nextKey = null;
                    this.nextEntry = null;
                } else {
                    this.nextKey = SSTableScanner.this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(SSTableScanner.this.ifile));
                    this.nextEntry = RowIndexEntry.serializer.deserialize(SSTableScanner.this.ifile, SSTableScanner.this.sstable.descriptor.version);
                }
                assert (!SSTableScanner.this.dfile.isEOF());
                if (SSTableScanner.this.dataRange.selectsFullRowFor(this.currentKey.key)) {
                    SSTableScanner.this.dfile.seek(this.currentEntry.position);
                    ByteBufferUtil.readWithShortLength(SSTableScanner.this.dfile);
                    if (SSTableScanner.this.sstable.descriptor.version.hasRowSizeAndColumnCount) {
                        SSTableScanner.this.dfile.readLong();
                    }
                    long dataSize = (this.nextEntry == null ? SSTableScanner.this.dfile.length() : this.nextEntry.position) - SSTableScanner.this.dfile.getFilePointer();
                    return new SSTableIdentityIterator(SSTableScanner.this.sstable, SSTableScanner.this.dfile, this.currentKey, dataSize);
                }
                return new LazyColumnIterator(this.currentKey, new IColumnIteratorFactory(){

                    @Override
                    public OnDiskAtomIterator create() {
                        return SSTableScanner.this.dataRange.columnFilter(((KeyScanningIterator)KeyScanningIterator.this).currentKey.key).getSSTableColumnIterator(SSTableScanner.this.sstable, SSTableScanner.this.dfile, KeyScanningIterator.this.currentKey, KeyScanningIterator.this.currentEntry);
                    }
                });
            }
            catch (IOException e) {
                SSTableScanner.this.sstable.markSuspect();
                throw new CorruptSSTableException((Exception)e, SSTableScanner.this.sstable.getFilename());
            }
        }
    }
}

