/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.index.SecondaryIndexBuilder;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.index.keys.KeysIndex;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.LocalByPartionerType;
import org.apache.cassandra.dht.LocalToken;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecondaryIndex {
    protected static final Logger logger = LoggerFactory.getLogger(SecondaryIndex.class);
    public static final String CUSTOM_INDEX_OPTION_NAME = "class_name";
    public static final AbstractType<?> keyComparator = StorageService.getPartitioner().preservesOrder() ? BytesType.instance : new LocalByPartionerType(StorageService.getPartitioner());
    protected ColumnFamilyStore baseCfs;
    protected final Set<ColumnDefinition> columnDefs = Collections.newSetFromMap(new ConcurrentHashMap());

    public abstract void init();

    public abstract void reload();

    public abstract void validateOptions() throws ConfigurationException;

    public abstract String getIndexName();

    public abstract String getNameForSystemKeyspace(ByteBuffer var1);

    public boolean isIndexBuilt(ByteBuffer columnName) {
        return SystemKeyspace.isIndexBuilt(this.baseCfs.keyspace.getName(), this.getNameForSystemKeyspace(columnName));
    }

    public void setIndexBuilt() {
        for (ColumnDefinition columnDef : this.columnDefs) {
            SystemKeyspace.setIndexBuilt(this.baseCfs.keyspace.getName(), this.getNameForSystemKeyspace(columnDef.name));
        }
    }

    public void setIndexRemoved() {
        for (ColumnDefinition columnDef : this.columnDefs) {
            SystemKeyspace.setIndexRemoved(this.baseCfs.keyspace.getName(), this.getNameForSystemKeyspace(columnDef.name));
        }
    }

    protected abstract SecondaryIndexSearcher createSecondaryIndexSearcher(Set<ByteBuffer> var1);

    public abstract void forceBlockingFlush();

    public abstract long getLiveSize();

    public abstract ColumnFamilyStore getIndexCfs();

    public abstract void removeIndex(ByteBuffer var1);

    public abstract void invalidate();

    public abstract void truncateBlocking(long var1);

    protected void buildIndexBlocking() {
        logger.info(String.format("Submitting index build of %s for data in %s", this.getIndexName(), StringUtils.join(this.baseCfs.getSSTables(), (String)", ")));
        Collection<SSTableReader> sstables = this.baseCfs.markCurrentSSTablesReferenced();
        SecondaryIndexBuilder builder = new SecondaryIndexBuilder(this.baseCfs, Collections.singleton(this.getIndexName()), new ReducingKeyIterator(sstables));
        Future<?> future = CompactionManager.instance.submitIndexBuild(builder);
        FBUtilities.waitOnFuture(future);
        this.forceBlockingFlush();
        this.setIndexBuilt();
        logger.info("Index build of " + this.getIndexName() + " complete");
    }

    public Future<?> buildIndexAsync() {
        boolean allAreBuilt = true;
        for (ColumnDefinition cdef : this.columnDefs) {
            if (SystemKeyspace.isIndexBuilt(this.baseCfs.keyspace.getName(), this.getNameForSystemKeyspace(cdef.name))) continue;
            allAreBuilt = false;
            break;
        }
        if (allAreBuilt) {
            return null;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SecondaryIndex.this.baseCfs.forceBlockingFlush();
                SecondaryIndex.this.buildIndexBlocking();
            }
        };
        FutureTask<Object> f = new FutureTask<Object>(runnable, null);
        new Thread(f, "Creating index: " + this.getIndexName()).start();
        return f;
    }

    public ColumnFamilyStore getBaseCfs() {
        return this.baseCfs;
    }

    private void setBaseCfs(ColumnFamilyStore baseCfs) {
        this.baseCfs = baseCfs;
    }

    public Set<ColumnDefinition> getColumnDefs() {
        return this.columnDefs;
    }

    void addColumnDef(ColumnDefinition columnDef) {
        this.columnDefs.add(columnDef);
    }

    void removeColumnDef(ByteBuffer name) {
        Iterator<ColumnDefinition> it = this.columnDefs.iterator();
        while (it.hasNext()) {
            if (!it.next().name.equals(name)) continue;
            it.remove();
        }
    }

    public DecoratedKey getIndexKeyFor(ByteBuffer value) {
        ByteBuffer name = this.columnDefs.iterator().next().name;
        return new DecoratedKey(new LocalToken(this.baseCfs.metadata.getColumnDefinition(name).getValidator(), value), value);
    }

    public boolean indexes(ByteBuffer name) {
        for (ColumnDefinition columnDef : this.columnDefs) {
            if (this.baseCfs.getComparator().compare(columnDef.name, name) != 0) continue;
            return true;
        }
        return false;
    }

    public static SecondaryIndex createInstance(ColumnFamilyStore baseCfs, ColumnDefinition cdef) throws ConfigurationException {
        SecondaryIndex index;
        switch (cdef.getIndexType()) {
            case KEYS: {
                index = new KeysIndex();
                break;
            }
            case COMPOSITES: {
                index = CompositesIndex.create(cdef);
                break;
            }
            case CUSTOM: {
                assert (cdef.getIndexOptions() != null);
                String class_name = cdef.getIndexOptions().get(CUSTOM_INDEX_OPTION_NAME);
                assert (class_name != null);
                try {
                    index = (SecondaryIndex)Class.forName(class_name).newInstance();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new RuntimeException("Unknown index type: " + cdef.getIndexName());
            }
        }
        index.addColumnDef(cdef);
        ((SecondaryIndex)index).validateOptions();
        super.setBaseCfs(baseCfs);
        return index;
    }

    public abstract boolean validate(Column var1);

    public static AbstractType<?> getIndexComparator(CFMetaData baseMetadata, ColumnDefinition cdef) {
        switch (cdef.getIndexType()) {
            case KEYS: {
                return keyComparator;
            }
            case COMPOSITES: {
                return CompositesIndex.getIndexComparator(baseMetadata, cdef);
            }
            case CUSTOM: {
                return null;
            }
        }
        throw new AssertionError();
    }
}

