/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.utils.ObjectSizes;

public class DeletionTime
implements Comparable<DeletionTime> {
    public static final DeletionTime LIVE = new DeletionTime(Long.MIN_VALUE, Integer.MAX_VALUE);
    public final long markedForDeleteAt;
    public final int localDeletionTime;
    public static final ISerializer<DeletionTime> serializer = new Serializer();

    @VisibleForTesting
    public DeletionTime(long markedForDeleteAt, int localDeletionTime) {
        this.markedForDeleteAt = markedForDeleteAt;
        this.localDeletionTime = localDeletionTime;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeletionTime)) {
            return false;
        }
        DeletionTime that = (DeletionTime)o;
        return this.markedForDeleteAt == that.markedForDeleteAt && this.localDeletionTime == that.localDeletionTime;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.markedForDeleteAt, this.localDeletionTime});
    }

    public String toString() {
        return String.format("deletedAt=%d, localDeletion=%d", this.markedForDeleteAt, this.localDeletionTime);
    }

    @Override
    public int compareTo(DeletionTime dt) {
        if (this.markedForDeleteAt < dt.markedForDeleteAt) {
            return -1;
        }
        if (this.markedForDeleteAt > dt.markedForDeleteAt) {
            return 1;
        }
        if (this.localDeletionTime < dt.localDeletionTime) {
            return -1;
        }
        if (this.localDeletionTime > dt.localDeletionTime) {
            return -1;
        }
        return 0;
    }

    public boolean isGcAble(int gcBefore) {
        return this.localDeletionTime < gcBefore;
    }

    public boolean isDeleted(Column column, long now) {
        return column.isMarkedForDelete(now) && column.getMarkedForDeleteAt() <= this.markedForDeleteAt;
    }

    public long memorySize() {
        long fields = TypeSizes.NATIVE.sizeof(this.markedForDeleteAt) + TypeSizes.NATIVE.sizeof(this.localDeletionTime);
        return ObjectSizes.getFieldSize(fields);
    }

    private static class Serializer
    implements ISerializer<DeletionTime> {
        private Serializer() {
        }

        @Override
        public void serialize(DeletionTime delTime, DataOutput out) throws IOException {
            out.writeInt(delTime.localDeletionTime);
            out.writeLong(delTime.markedForDeleteAt);
        }

        @Override
        public DeletionTime deserialize(DataInput in) throws IOException {
            int ldt = in.readInt();
            long mfda = in.readLong();
            if (mfda == Long.MIN_VALUE && ldt == Integer.MAX_VALUE) {
                return LIVE;
            }
            return new DeletionTime(mfda, ldt);
        }

        @Override
        public long serializedSize(DeletionTime delTime, TypeSizes typeSizes) {
            return typeSizes.sizeof(delTime.localDeletionTime) + typeSizes.sizeof(delTime.markedForDeleteAt);
        }
    }
}

