/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.utils.ByteBufferUtil;

public class TriggerOptions {
    private static final String CLASS_KEY = "class";
    private static final String OPTIONS_KEY = "trigger_options";

    public static Map<String, Map<String, String>> getAllTriggers(String ksName, String cfName) {
        String req = "SELECT * FROM system.%s WHERE keyspace_name='%s' AND columnfamily_name='%s'";
        UntypedResultSet result = QueryProcessor.processInternal(String.format(req, "schema_triggers", ksName, cfName));
        HashMap<String, Map<String, String>> triggers = new HashMap<String, Map<String, String>>();
        if (result.isEmpty()) {
            return triggers;
        }
        for (UntypedResultSet.Row row : result) {
            triggers.put(row.getString("trigger_name"), row.getMap(OPTIONS_KEY, UTF8Type.instance, UTF8Type.instance));
        }
        return triggers;
    }

    public static void addColumns(RowMutation rm, String cfName, Map.Entry<String, Map<String, String>> tentry, long modificationTimestamp) {
        ColumnFamily cf = rm.addOrGet(CFMetaData.SchemaTriggersCf);
        assert (tentry.getValue().get(CLASS_KEY) != null);
        ColumnNameBuilder builder = CFMetaData.SchemaTriggersCf.getCfDef().getColumnNameBuilder();
        builder.add(ByteBufferUtil.bytes(cfName)).add(ByteBufferUtil.bytes(tentry.getKey())).add(ByteBufferUtil.bytes(OPTIONS_KEY));
        for (Map.Entry<String, String> entry : tentry.getValue().entrySet()) {
            ColumnNameBuilder builderCopy = builder.copy();
            builderCopy.add(ByteBufferUtil.bytes(entry.getKey()));
            cf.addColumn(builderCopy.build(), ByteBufferUtil.bytes(entry.getValue()), modificationTimestamp);
        }
    }

    public static void deleteColumns(RowMutation rm, String cfName, Map.Entry<String, Map<String, String>> tentry, long modificationTimestamp) {
        ColumnFamily cf = rm.addOrGet(CFMetaData.SchemaTriggersCf);
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        ColumnNameBuilder builder = CFMetaData.SchemaTriggersCf.getCfDef().getColumnNameBuilder();
        builder.add(ByteBufferUtil.bytes(cfName)).add(ByteBufferUtil.bytes(tentry.getKey()));
        cf.addAtom(new RangeTombstone(builder.build(), builder.buildAsEndOfRange(), modificationTimestamp, ldt));
    }

    public static void update(CFMetaData cfm, String triggerName, String clazz) {
        Map<String, Map<String, String>> existingTriggers = cfm.getTriggers();
        assert (existingTriggers.get(triggerName) == null);
        HashMap<String, String> triggerUnit = new HashMap<String, String>();
        triggerUnit.put(CLASS_KEY, clazz);
        existingTriggers.put(triggerName, triggerUnit);
        cfm.triggers(existingTriggers);
    }

    public static void remove(CFMetaData cfm, String triggerName) {
        Map<String, Map<String, String>> existingTriggers = cfm.getTriggers();
        existingTriggers.remove(triggerName);
        cfm.triggers(existingTriggers);
    }

    public static boolean hasTrigger(CFMetaData cfm, String triggerName) {
        return cfm.getTriggers().get(triggerName) != null;
    }

    public static Collection<String> extractClasses(Map<String, Map<String, String>> triggers) {
        ArrayList<String> classes = new ArrayList<String>();
        if (triggers.isEmpty()) {
            return null;
        }
        for (Map<String, String> options : triggers.values()) {
            classes.add(options.get(CLASS_KEY));
        }
        return classes;
    }
}

