/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ReadRepairDecision;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.TriggerOptions;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.CreateTableStatement;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SuperColumns;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.SizeTieredCompactionStrategy;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.compress.LZ4Compressor;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CFMetaData {
    private static final Logger logger = LoggerFactory.getLogger(CFMetaData.class);
    public static final double DEFAULT_READ_REPAIR_CHANCE = 0.1;
    public static final double DEFAULT_DCLOCAL_READ_REPAIR_CHANCE = 0.0;
    public static final boolean DEFAULT_REPLICATE_ON_WRITE = true;
    public static final int DEFAULT_GC_GRACE_SECONDS = 864000;
    public static final int DEFAULT_MIN_COMPACTION_THRESHOLD = 4;
    public static final int DEFAULT_MAX_COMPACTION_THRESHOLD = 32;
    public static final Class<? extends AbstractCompactionStrategy> DEFAULT_COMPACTION_STRATEGY_CLASS = SizeTieredCompactionStrategy.class;
    public static final Caching DEFAULT_CACHING_STRATEGY = Caching.KEYS_ONLY;
    public static final int DEFAULT_DEFAULT_TIME_TO_LIVE = 0;
    public static final SpeculativeRetry DEFAULT_SPECULATIVE_RETRY = new SpeculativeRetry(SpeculativeRetry.RetryType.NONE, 0.0);
    public static final int DEFAULT_INDEX_INTERVAL = 128;
    public static final boolean DEFAULT_POPULATE_IO_CACHE_ON_FLUSH = false;
    public static final String DEFAULT_COMPRESSOR = LZ4Compressor.class.getCanonicalName();
    public static final CFMetaData IndexCf = CFMetaData.compile("CREATE TABLE \"IndexInfo\" (table_name text,index_name text,PRIMARY KEY (table_name, index_name)) WITH COMPACT STORAGE AND COMMENT='indexes that have been completed'");
    public static final CFMetaData CounterIdCf = CFMetaData.compile("CREATE TABLE \"NodeIdInfo\" (key text,id timeuuid,PRIMARY KEY (key, id)) WITH COMPACT STORAGE AND COMMENT='counter node IDs'");
    public static final CFMetaData SchemaKeyspacesCf = CFMetaData.compile("CREATE TABLE schema_keyspaces (keyspace_name text PRIMARY KEY,durable_writes boolean,strategy_class text,strategy_options text) WITH COMPACT STORAGE AND COMMENT='keyspace definitions' AND gc_grace_seconds=8640");
    public static final CFMetaData SchemaColumnFamiliesCf = CFMetaData.compile("CREATE TABLE schema_columnfamilies (keyspace_name text,columnfamily_name text,type text,comparator text,subcomparator text,comment text,read_repair_chance double,local_read_repair_chance double,replicate_on_write boolean,gc_grace_seconds int,default_validator text,key_validator text,min_compaction_threshold int,max_compaction_threshold int,memtable_flush_period_in_ms int,key_alias text,key_aliases text,bloom_filter_fp_chance double,caching text,default_time_to_live int,compaction_strategy_class text,compression_parameters text,value_alias text,column_aliases text,compaction_strategy_options text,default_read_consistency text,default_write_consistency text,speculative_retry text,populate_io_cache_on_flush boolean,index_interval int,dropped_columns map<text, bigint>,PRIMARY KEY (keyspace_name, columnfamily_name)) WITH COMMENT='ColumnFamily definitions' AND gc_grace_seconds=8640");
    public static final CFMetaData SchemaColumnsCf = CFMetaData.compile("CREATE TABLE schema_columns (keyspace_name text,columnfamily_name text,column_name text,validator text,index_type text,index_options text,index_name text,component_index int,type text,PRIMARY KEY(keyspace_name, columnfamily_name, column_name)) WITH COMMENT='ColumnFamily column attributes' AND gc_grace_seconds=8640");
    public static final CFMetaData SchemaTriggersCf = CFMetaData.compile("CREATE TABLE schema_triggers (keyspace_name text,columnfamily_name text,trigger_name text,trigger_options map<text, text>,PRIMARY KEY (keyspace_name, columnfamily_name, trigger_name)) WITH COMMENT='triggers metadata table'");
    public static final CFMetaData HintsCf = CFMetaData.compile("CREATE TABLE hints (target_id uuid,hint_id timeuuid,message_version int,mutation blob,PRIMARY KEY (target_id, hint_id, message_version)) WITH COMPACT STORAGE AND COMPACTION={'class' : 'SizeTieredCompactionStrategy', 'enabled' : false} AND COMMENT='hints awaiting delivery'AND gc_grace_seconds=0");
    public static final CFMetaData PeersCf = CFMetaData.compile("CREATE TABLE peers (peer inet PRIMARY KEY,host_id uuid,tokens set<varchar>,schema_version uuid,release_version text,rpc_address inet,preferred_ip inet,data_center text,rack text) WITH COMMENT='known peers in the cluster'");
    public static final CFMetaData PeerEventsCf = CFMetaData.compile("CREATE TABLE peer_events (peer inet PRIMARY KEY,hints_dropped map<uuid, int>) WITH COMMENT='cf contains events related to peers'");
    public static final CFMetaData LocalCf = CFMetaData.compile("CREATE TABLE local (key text PRIMARY KEY,tokens set<varchar>,cluster_name text,gossip_generation int,bootstrapped text,host_id uuid,release_version text,thrift_version text,cql_version text,data_center text,rack text,partitioner text,schema_version uuid,truncated_at map<uuid, blob>) WITH COMMENT='information about the local node'");
    public static final CFMetaData TraceSessionsCf = CFMetaData.compile("CREATE TABLE sessions (session_id uuid PRIMARY KEY,coordinator inet,request text,started_at timestamp,parameters map<text, text>,duration int) WITH COMMENT='traced sessions'", "system_traces");
    public static final CFMetaData TraceEventsCf = CFMetaData.compile("CREATE TABLE events (session_id uuid,event_id timeuuid,source inet,thread text,activity text,source_elapsed int,PRIMARY KEY (session_id, event_id))", "system_traces");
    public static final CFMetaData BatchlogCf = CFMetaData.compile("CREATE TABLE batchlog (id uuid PRIMARY KEY,written_at timestamp,data blob) WITH COMMENT='uncommited batches' AND gc_grace_seconds=0 AND COMPACTION={'class' : 'SizeTieredCompactionStrategy', 'min_threshold' : 2}");
    public static final CFMetaData RangeXfersCf = CFMetaData.compile("CREATE TABLE range_xfers (token_bytes blob PRIMARY KEY,requested_at timestamp) WITH COMMENT='ranges requested for transfer here'");
    public static final CFMetaData CompactionLogCf = CFMetaData.compile("CREATE TABLE compactions_in_progress (id uuid PRIMARY KEY,keyspace_name text,columnfamily_name text,inputs set<int>) WITH COMMENT='unfinished compactions'");
    public static final CFMetaData PaxosCf = CFMetaData.compile("CREATE TABLE paxos (row_key blob,cf_id UUID,in_progress_ballot timeuuid,proposal blob,most_recent_commit_at timeuuid,most_recent_commit blob,PRIMARY KEY (row_key, cf_id)) WITH COMMENT='in-progress paxos proposals'");
    public final UUID cfId;
    public final String ksName;
    public final String cfName;
    public final ColumnFamilyType cfType;
    public volatile AbstractType<?> comparator;
    private volatile String comment = "";
    private volatile double readRepairChance = 0.1;
    private volatile double dcLocalReadRepairChance = 0.0;
    private volatile boolean replicateOnWrite = true;
    private volatile int gcGraceSeconds = 864000;
    private volatile AbstractType<?> defaultValidator = BytesType.instance;
    private volatile AbstractType<?> keyValidator = BytesType.instance;
    private volatile int minCompactionThreshold = 4;
    private volatile int maxCompactionThreshold = 32;
    private volatile Double bloomFilterFpChance = null;
    private volatile Caching caching = DEFAULT_CACHING_STRATEGY;
    private volatile int indexInterval = 128;
    private int memtableFlushPeriod = 0;
    private volatile int defaultTimeToLive = 0;
    private volatile SpeculativeRetry speculativeRetry = DEFAULT_SPECULATIVE_RETRY;
    private volatile boolean populateIoCacheOnFlush = false;
    private volatile Map<ByteBuffer, Long> droppedColumns = new HashMap<ByteBuffer, Long>();
    private volatile Map<String, Map<String, String>> triggers = new HashMap<String, Map<String, String>>();
    private volatile Collection<String> cachedTriggers;
    public static final String DEFAULT_KEY_ALIAS = "key";
    public static final String DEFAULT_COLUMN_ALIAS = "column";
    public static final String DEFAULT_VALUE_ALIAS = "value";
    private volatile Map<ByteBuffer, ColumnDefinition> column_metadata = new HashMap<ByteBuffer, ColumnDefinition>();
    private volatile List<ColumnDefinition> partitionKeyColumns;
    private volatile List<ColumnDefinition> clusteringKeyColumns;
    private volatile Set<ColumnDefinition> regularColumns;
    private volatile ColumnDefinition compactValueColumn;
    public volatile Class<? extends AbstractCompactionStrategy> compactionStrategyClass = DEFAULT_COMPACTION_STRATEGY_CLASS;
    public volatile Map<String, String> compactionStrategyOptions = new HashMap<String, String>();
    public volatile CompressionParameters compressionParameters = new CompressionParameters(null);
    private volatile CFDefinition cqlCfDef;

    public CFMetaData comment(String prop) {
        this.comment = CFMetaData.enforceCommentNotNull(prop);
        return this;
    }

    public CFMetaData readRepairChance(double prop) {
        this.readRepairChance = prop;
        return this;
    }

    public CFMetaData dcLocalReadRepairChance(double prop) {
        this.dcLocalReadRepairChance = prop;
        return this;
    }

    public CFMetaData replicateOnWrite(boolean prop) {
        this.replicateOnWrite = prop;
        return this;
    }

    public CFMetaData gcGraceSeconds(int prop) {
        this.gcGraceSeconds = prop;
        return this;
    }

    public CFMetaData defaultValidator(AbstractType<?> prop) {
        this.defaultValidator = prop;
        return this;
    }

    public CFMetaData keyValidator(AbstractType<?> prop) {
        this.keyValidator = prop;
        return this;
    }

    public CFMetaData minCompactionThreshold(int prop) {
        this.minCompactionThreshold = prop;
        return this;
    }

    public CFMetaData maxCompactionThreshold(int prop) {
        this.maxCompactionThreshold = prop;
        return this;
    }

    public CFMetaData columnMetadata(Map<ByteBuffer, ColumnDefinition> prop) {
        this.column_metadata = prop;
        return this;
    }

    public CFMetaData compactionStrategyClass(Class<? extends AbstractCompactionStrategy> prop) {
        this.compactionStrategyClass = prop;
        return this;
    }

    public CFMetaData compactionStrategyOptions(Map<String, String> prop) {
        this.compactionStrategyOptions = prop;
        return this;
    }

    public CFMetaData compressionParameters(CompressionParameters prop) {
        this.compressionParameters = prop;
        return this;
    }

    public CFMetaData bloomFilterFpChance(Double prop) {
        this.bloomFilterFpChance = prop;
        return this;
    }

    public CFMetaData caching(Caching prop) {
        this.caching = prop;
        return this;
    }

    public CFMetaData indexInterval(int prop) {
        this.indexInterval = prop;
        return this;
    }

    public CFMetaData memtableFlushPeriod(int prop) {
        this.memtableFlushPeriod = prop;
        return this;
    }

    public CFMetaData defaultTimeToLive(int prop) {
        this.defaultTimeToLive = prop;
        return this;
    }

    public CFMetaData speculativeRetry(SpeculativeRetry prop) {
        this.speculativeRetry = prop;
        return this;
    }

    public CFMetaData populateIoCacheOnFlush(boolean prop) {
        this.populateIoCacheOnFlush = prop;
        return this;
    }

    public CFMetaData droppedColumns(Map<ByteBuffer, Long> cols) {
        this.droppedColumns = cols;
        return this;
    }

    public CFMetaData triggers(Map<String, Map<String, String>> prop) {
        this.triggers = prop;
        this.cachedTriggers = TriggerOptions.extractClasses(this.triggers);
        return this;
    }

    public CFMetaData(String keyspace, String name, ColumnFamilyType type, AbstractType<?> comp, AbstractType<?> subcc) {
        this(keyspace, name, type, CFMetaData.makeComparator(type, comp, subcc));
    }

    public CFMetaData(String keyspace, String name, ColumnFamilyType type, AbstractType<?> comp) {
        this(keyspace, name, type, comp, CFMetaData.getId(keyspace, name));
    }

    @VisibleForTesting
    CFMetaData(String keyspace, String name, ColumnFamilyType type, AbstractType<?> comp, UUID id) {
        this.ksName = keyspace;
        this.cfName = name;
        this.cfType = type;
        this.comparator = comp;
        this.cfId = id;
    }

    public Map<String, Map<String, String>> getTriggers() {
        return new HashMap<String, Map<String, String>>(this.triggers);
    }

    private static CFMetaData compile(String cql) {
        return CFMetaData.compile(cql, "system");
    }

    private static CFMetaData compile(String cql, String keyspace) {
        try {
            CreateTableStatement statement = (CreateTableStatement)QueryProcessor.parseStatement((String)cql).prepare().statement;
            CFMetaData cfm = CFMetaData.newSystemMetadata(keyspace, statement.columnFamily(), "", statement.comparator, null);
            statement.applyPropertiesTo(cfm);
            return cfm.rebuild();
        }
        catch (RequestValidationException e) {
            throw new RuntimeException(e);
        }
    }

    private static AbstractType<?> makeComparator(ColumnFamilyType cftype, AbstractType<?> comp, AbstractType<?> subcc) {
        return cftype == ColumnFamilyType.Super ? CompositeType.getInstance(comp, subcc == null ? BytesType.instance : subcc) : comp;
    }

    private static String enforceCommentNotNull(CharSequence comment) {
        return comment == null ? "" : comment.toString();
    }

    static UUID getId(String ksName, String cfName) {
        return UUID.nameUUIDFromBytes(ArrayUtils.addAll((byte[])ksName.getBytes(), (byte[])cfName.getBytes()));
    }

    private static CFMetaData newSystemMetadata(String keyspace, String cfName, String comment, AbstractType<?> comparator, AbstractType<?> subcc) {
        ColumnFamilyType type = subcc == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super;
        CFMetaData newCFMD = new CFMetaData(keyspace, cfName, type, comparator, subcc);
        return newCFMD.comment(comment).readRepairChance(0.0).dcLocalReadRepairChance(0.0).gcGraceSeconds(0);
    }

    public static CFMetaData newIndexMetadata(CFMetaData parent, ColumnDefinition info, AbstractType<?> columnComparator) {
        Caching indexCaching = parent.getCaching() == Caching.ALL || parent.getCaching() == Caching.KEYS_ONLY ? Caching.KEYS_ONLY : Caching.NONE;
        return new CFMetaData(parent.ksName, parent.indexColumnFamilyName(info), ColumnFamilyType.Standard, columnComparator, (AbstractType)null).keyValidator(info.getValidator()).readRepairChance(0.0).dcLocalReadRepairChance(0.0).gcGraceSeconds(0).caching(indexCaching).speculativeRetry(parent.speculativeRetry).triggers(parent.triggers).compactionStrategyClass(parent.compactionStrategyClass).compactionStrategyOptions(parent.compactionStrategyOptions).reloadSecondaryIndexMetadata(parent).rebuild();
    }

    public CFMetaData reloadSecondaryIndexMetadata(CFMetaData parent) {
        this.minCompactionThreshold(parent.minCompactionThreshold);
        this.maxCompactionThreshold(parent.maxCompactionThreshold);
        this.compactionStrategyClass(parent.compactionStrategyClass);
        this.compactionStrategyOptions(parent.compactionStrategyOptions);
        this.compressionParameters(parent.compressionParameters);
        return this;
    }

    public CFMetaData clone() {
        return CFMetaData.copyOpts(new CFMetaData(this.ksName, this.cfName, this.cfType, this.comparator, this.cfId), this);
    }

    public static CFMetaData rename(CFMetaData cfm, String newName) {
        return CFMetaData.copyOpts(new CFMetaData(cfm.ksName, newName, cfm.cfType, cfm.comparator, cfm.cfId), cfm);
    }

    static CFMetaData copyOpts(CFMetaData newCFMD, CFMetaData oldCFMD) {
        HashMap<ByteBuffer, ColumnDefinition> clonedColumns = new HashMap<ByteBuffer, ColumnDefinition>();
        for (ColumnDefinition cd : oldCFMD.column_metadata.values()) {
            ColumnDefinition cloned = cd.clone();
            clonedColumns.put(cloned.name, cloned);
        }
        return newCFMD.comment(oldCFMD.comment).readRepairChance(oldCFMD.readRepairChance).dcLocalReadRepairChance(oldCFMD.dcLocalReadRepairChance).replicateOnWrite(oldCFMD.replicateOnWrite).gcGraceSeconds(oldCFMD.gcGraceSeconds).defaultValidator(oldCFMD.defaultValidator).keyValidator(oldCFMD.keyValidator).minCompactionThreshold(oldCFMD.minCompactionThreshold).maxCompactionThreshold(oldCFMD.maxCompactionThreshold).columnMetadata(clonedColumns).compactionStrategyClass(oldCFMD.compactionStrategyClass).compactionStrategyOptions(oldCFMD.compactionStrategyOptions).compressionParameters(oldCFMD.compressionParameters).bloomFilterFpChance(oldCFMD.bloomFilterFpChance).caching(oldCFMD.caching).defaultTimeToLive(oldCFMD.defaultTimeToLive).indexInterval(oldCFMD.indexInterval).speculativeRetry(oldCFMD.speculativeRetry).memtableFlushPeriod(oldCFMD.memtableFlushPeriod).populateIoCacheOnFlush(oldCFMD.populateIoCacheOnFlush).droppedColumns(oldCFMD.droppedColumns).triggers(oldCFMD.getTriggers()).rebuild();
    }

    public String indexColumnFamilyName(ColumnDefinition info) {
        return this.cfName + "." + (info.getIndexName() == null ? ByteBufferUtil.bytesToHex(info.name) : info.getIndexName());
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isSuper() {
        return this.cfType == ColumnFamilyType.Super;
    }

    public double getReadRepairChance() {
        return this.readRepairChance;
    }

    public double getDcLocalReadRepair() {
        return this.dcLocalReadRepairChance;
    }

    public ReadRepairDecision newReadRepairDecision() {
        double chance = FBUtilities.threadLocalRandom().nextDouble();
        if (this.getReadRepairChance() > chance) {
            return ReadRepairDecision.GLOBAL;
        }
        if (this.getDcLocalReadRepair() > chance) {
            return ReadRepairDecision.DC_LOCAL;
        }
        return ReadRepairDecision.NONE;
    }

    public boolean getReplicateOnWrite() {
        return this.replicateOnWrite;
    }

    public boolean populateIoCacheOnFlush() {
        return this.populateIoCacheOnFlush;
    }

    public int getGcGraceSeconds() {
        return this.gcGraceSeconds;
    }

    public AbstractType<?> getDefaultValidator() {
        return this.defaultValidator;
    }

    public AbstractType<?> getKeyValidator() {
        return this.keyValidator;
    }

    public Integer getMinCompactionThreshold() {
        return this.minCompactionThreshold;
    }

    public Integer getMaxCompactionThreshold() {
        return this.maxCompactionThreshold;
    }

    public String getCQL2KeyName() {
        if (this.partitionKeyColumns.size() > 1) {
            throw new IllegalStateException("Cannot acces column family with composite key from CQL < 3.0.0");
        }
        try {
            String str = ByteBufferUtil.string(this.partitionKeyColumns.get((int)0).name);
            return str.equalsIgnoreCase(DEFAULT_KEY_ALIAS) ? str.toUpperCase() : str;
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public CompressionParameters compressionParameters() {
        return this.compressionParameters;
    }

    public Collection<ColumnDefinition> allColumns() {
        return this.column_metadata.values();
    }

    public List<ColumnDefinition> partitionKeyColumns() {
        return this.partitionKeyColumns;
    }

    public List<ColumnDefinition> clusteringKeyColumns() {
        return this.clusteringKeyColumns;
    }

    public Set<ColumnDefinition> regularColumns() {
        return this.regularColumns;
    }

    public ColumnDefinition compactValueColumn() {
        return this.compactValueColumn;
    }

    public double getBloomFilterFpChance() {
        return this.bloomFilterFpChance == null || this.bloomFilterFpChance == 0.0 ? (this.compactionStrategyClass == LeveledCompactionStrategy.class ? 0.1 : 0.01) : this.bloomFilterFpChance;
    }

    public Collection<String> getTriggerClasses() {
        return this.cachedTriggers;
    }

    public Caching getCaching() {
        return this.caching;
    }

    public int getIndexInterval() {
        return this.indexInterval;
    }

    public SpeculativeRetry getSpeculativeRetry() {
        return this.speculativeRetry;
    }

    public int getMemtableFlushPeriod() {
        return this.memtableFlushPeriod;
    }

    public int getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    public Map<ByteBuffer, Long> getDroppedColumns() {
        return this.droppedColumns;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CFMetaData rhs = (CFMetaData)obj;
        return new EqualsBuilder().append((Object)this.ksName, (Object)rhs.ksName).append((Object)this.cfName, (Object)rhs.cfName).append((Object)this.cfType, (Object)rhs.cfType).append(this.comparator, rhs.comparator).append((Object)this.comment, (Object)rhs.comment).append(this.readRepairChance, rhs.readRepairChance).append(this.dcLocalReadRepairChance, rhs.dcLocalReadRepairChance).append(this.replicateOnWrite, rhs.replicateOnWrite).append(this.gcGraceSeconds, rhs.gcGraceSeconds).append(this.defaultValidator, rhs.defaultValidator).append(this.keyValidator, rhs.keyValidator).append(this.minCompactionThreshold, rhs.minCompactionThreshold).append(this.maxCompactionThreshold, rhs.maxCompactionThreshold).append((Object)this.cfId, (Object)rhs.cfId).append(this.column_metadata, rhs.column_metadata).append(this.compactionStrategyClass, rhs.compactionStrategyClass).append(this.compactionStrategyOptions, rhs.compactionStrategyOptions).append((Object)this.compressionParameters, (Object)rhs.compressionParameters).append((Object)this.bloomFilterFpChance, (Object)rhs.bloomFilterFpChance).append(this.memtableFlushPeriod, rhs.memtableFlushPeriod).append((Object)this.caching, (Object)rhs.caching).append(this.defaultTimeToLive, rhs.defaultTimeToLive).append(this.indexInterval, rhs.indexInterval).append((Object)this.speculativeRetry, (Object)rhs.speculativeRetry).append(this.populateIoCacheOnFlush, rhs.populateIoCacheOnFlush).append(this.droppedColumns, rhs.droppedColumns).append(this.triggers, rhs.triggers).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.ksName).append((Object)this.cfName).append((Object)this.cfType).append(this.comparator).append((Object)this.comment).append(this.readRepairChance).append(this.dcLocalReadRepairChance).append(this.replicateOnWrite).append(this.gcGraceSeconds).append(this.defaultValidator).append(this.keyValidator).append(this.minCompactionThreshold).append(this.maxCompactionThreshold).append((Object)this.cfId).append(this.column_metadata).append(this.compactionStrategyClass).append(this.compactionStrategyOptions).append((Object)this.compressionParameters).append((Object)this.bloomFilterFpChance).append(this.memtableFlushPeriod).append((Object)this.caching).append(this.defaultTimeToLive).append(this.indexInterval).append((Object)this.speculativeRetry).append(this.populateIoCacheOnFlush).append(this.droppedColumns).append(this.triggers).toHashCode();
    }

    public AbstractType<?> getValueValidator(ByteBuffer column) {
        return this.getValueValidator(this.getColumnDefinition(column));
    }

    public AbstractType<?> getValueValidator(ColumnDefinition columnDefinition) {
        return columnDefinition == null ? this.defaultValidator : columnDefinition.getValidator();
    }

    public static void applyImplicitDefaults(CfDef cf_def) {
        if (!cf_def.isSetComment()) {
            cf_def.setComment("");
        }
        if (!cf_def.isSetReplicate_on_write()) {
            cf_def.setReplicate_on_write(true);
        }
        if (!cf_def.isSetPopulate_io_cache_on_flush()) {
            cf_def.setPopulate_io_cache_on_flush(false);
        }
        if (!cf_def.isSetMin_compaction_threshold()) {
            cf_def.setMin_compaction_threshold(4);
        }
        if (!cf_def.isSetMax_compaction_threshold()) {
            cf_def.setMax_compaction_threshold(32);
        }
        if (cf_def.compaction_strategy == null) {
            cf_def.compaction_strategy = DEFAULT_COMPACTION_STRATEGY_CLASS.getSimpleName();
        }
        if (cf_def.compaction_strategy_options == null) {
            cf_def.compaction_strategy_options = Collections.emptyMap();
        }
        if (!cf_def.isSetCompression_options()) {
            cf_def.setCompression_options((Map)new HashMap<String, String>(){
                {
                    if (DEFAULT_COMPRESSOR != null) {
                        this.put("sstable_compression", DEFAULT_COMPRESSOR);
                    }
                }
            });
        }
        if (!cf_def.isSetDefault_time_to_live()) {
            cf_def.setDefault_time_to_live(0);
        }
        if (!cf_def.isSetDclocal_read_repair_chance()) {
            cf_def.setDclocal_read_repair_chance(0.0);
        }
    }

    public static CFMetaData fromThrift(CfDef cf_def) throws InvalidRequestException, ConfigurationException {
        ColumnFamilyType cfType = ColumnFamilyType.create(cf_def.column_type);
        if (cfType == null) {
            throw new InvalidRequestException("Invalid column type " + cf_def.column_type);
        }
        CFMetaData.applyImplicitDefaults(cf_def);
        try {
            CFMetaData newCFMD = new CFMetaData(cf_def.keyspace, cf_def.name, cfType, TypeParser.parse(cf_def.comparator_type), cf_def.subcomparator_type == null ? null : TypeParser.parse(cf_def.subcomparator_type));
            if (cf_def.isSetGc_grace_seconds()) {
                newCFMD.gcGraceSeconds(cf_def.gc_grace_seconds);
            }
            if (cf_def.isSetMin_compaction_threshold()) {
                newCFMD.minCompactionThreshold(cf_def.min_compaction_threshold);
            }
            if (cf_def.isSetMax_compaction_threshold()) {
                newCFMD.maxCompactionThreshold(cf_def.max_compaction_threshold);
            }
            if (cf_def.isSetCompaction_strategy()) {
                newCFMD.compactionStrategyClass = CFMetaData.createCompactionStrategy(cf_def.compaction_strategy);
            }
            if (cf_def.isSetCompaction_strategy_options()) {
                newCFMD.compactionStrategyOptions(new HashMap<String, String>(cf_def.compaction_strategy_options));
            }
            if (cf_def.isSetBloom_filter_fp_chance()) {
                newCFMD.bloomFilterFpChance(cf_def.bloom_filter_fp_chance);
            }
            if (cf_def.isSetMemtable_flush_period_in_ms()) {
                newCFMD.memtableFlushPeriod(cf_def.memtable_flush_period_in_ms);
            }
            if (cf_def.isSetCaching()) {
                newCFMD.caching(Caching.fromString(cf_def.caching));
            }
            if (cf_def.isSetRead_repair_chance()) {
                newCFMD.readRepairChance(cf_def.read_repair_chance);
            }
            if (cf_def.isSetDefault_time_to_live()) {
                newCFMD.defaultTimeToLive(cf_def.default_time_to_live);
            }
            if (cf_def.isSetDclocal_read_repair_chance()) {
                newCFMD.dcLocalReadRepairChance(cf_def.dclocal_read_repair_chance);
            }
            if (cf_def.isSetIndex_interval()) {
                newCFMD.indexInterval(cf_def.index_interval);
            }
            if (cf_def.isSetSpeculative_retry()) {
                newCFMD.speculativeRetry(SpeculativeRetry.fromString(cf_def.speculative_retry));
            }
            if (cf_def.isSetPopulate_io_cache_on_flush()) {
                newCFMD.populateIoCacheOnFlush(cf_def.populate_io_cache_on_flush);
            }
            if (cf_def.isSetTriggers()) {
                newCFMD.triggers(cf_def.triggers);
            }
            CompressionParameters cp = CompressionParameters.create(cf_def.compression_options);
            if (cf_def.isSetKey_validation_class()) {
                newCFMD.keyValidator(TypeParser.parse(cf_def.key_validation_class));
            }
            if (cf_def.isSetKey_alias() && !(newCFMD.keyValidator instanceof CompositeType)) {
                newCFMD.column_metadata.put(cf_def.key_alias, ColumnDefinition.partitionKeyDef(cf_def.key_alias, newCFMD.keyValidator, null));
            }
            return newCFMD.comment(cf_def.comment).replicateOnWrite(cf_def.replicate_on_write).defaultValidator(TypeParser.parse(cf_def.default_validation_class)).columnMetadata(ColumnDefinition.fromThrift(cf_def.column_metadata, newCFMD.isSuper())).compressionParameters(cp).rebuild();
        }
        catch (SyntaxException e) {
            throw new ConfigurationException(e.getMessage());
        }
        catch (MarshalException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public static CFMetaData fromThriftCqlRow(CqlRow row) {
        HashMap<String, ByteBuffer> columns = new HashMap<String, ByteBuffer>();
        try {
            for (Column column : row.getColumns()) {
                columns.put(ByteBufferUtil.string(column.bufferForName()), column.value);
            }
        }
        catch (CharacterCodingException ignore) {
            // empty catch block
        }
        UntypedResultSet.Row cql3row = new UntypedResultSet.Row(columns);
        return CFMetaData.fromSchemaNoColumns(cql3row);
    }

    public void reload() {
        Row cfDefRow = SystemKeyspace.readSchemaRow(this.ksName, this.cfName);
        if (cfDefRow.cf == null || cfDefRow.cf.getColumnCount() == 0) {
            throw new RuntimeException(String.format("%s not found in the schema definitions keyspace.", this.ksName + ":" + this.cfName));
        }
        try {
            this.apply(CFMetaData.fromSchema(cfDefRow));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void apply(CFMetaData cfm) throws ConfigurationException {
        logger.debug("applying {} to {}", (Object)cfm, (Object)this);
        this.validateCompatility(cfm);
        this.comparator = cfm.comparator;
        this.comment = CFMetaData.enforceCommentNotNull(cfm.comment);
        this.readRepairChance = cfm.readRepairChance;
        this.dcLocalReadRepairChance = cfm.dcLocalReadRepairChance;
        this.replicateOnWrite = cfm.replicateOnWrite;
        this.gcGraceSeconds = cfm.gcGraceSeconds;
        this.defaultValidator = cfm.defaultValidator;
        this.keyValidator = cfm.keyValidator;
        this.minCompactionThreshold = cfm.minCompactionThreshold;
        this.maxCompactionThreshold = cfm.maxCompactionThreshold;
        this.bloomFilterFpChance = cfm.bloomFilterFpChance;
        this.memtableFlushPeriod = cfm.memtableFlushPeriod;
        this.caching = cfm.caching;
        this.defaultTimeToLive = cfm.defaultTimeToLive;
        this.speculativeRetry = cfm.speculativeRetry;
        this.populateIoCacheOnFlush = cfm.populateIoCacheOnFlush;
        if (!cfm.droppedColumns.isEmpty()) {
            this.droppedColumns = cfm.droppedColumns;
        }
        MapDifference columnDiff = Maps.difference(this.column_metadata, cfm.column_metadata);
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnLeft().values()) {
            this.column_metadata.remove(cd.name);
        }
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnRight().values()) {
            this.column_metadata.put(cd.name, cd);
        }
        for (ByteBuffer name : columnDiff.entriesDiffering().keySet()) {
            ColumnDefinition oldDef = this.column_metadata.get(name);
            ColumnDefinition def = cfm.column_metadata.get(name);
            oldDef.apply(def, this.getColumnDefinitionComparator(oldDef));
        }
        this.triggers(new HashMap<String, Map<String, String>>(cfm.triggers));
        this.compactionStrategyClass = cfm.compactionStrategyClass;
        this.compactionStrategyOptions = cfm.compactionStrategyOptions;
        this.compressionParameters = cfm.compressionParameters();
        this.rebuild();
        logger.debug("application result is {}", (Object)this);
    }

    public void validateCompatility(CFMetaData cfm) throws ConfigurationException {
        if (!cfm.ksName.equals(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace mismatch (found %s; expected %s)", cfm.ksName, this.ksName));
        }
        if (!cfm.cfName.equals(this.cfName)) {
            throw new ConfigurationException(String.format("Column family mismatch (found %s; expected %s)", cfm.cfName, this.cfName));
        }
        if (!cfm.cfId.equals(this.cfId)) {
            throw new ConfigurationException(String.format("Column family ID mismatch (found %s; expected %s)", cfm.cfId, this.cfId));
        }
        if (!cfm.cfType.equals((Object)this.cfType)) {
            throw new ConfigurationException("types do not match.");
        }
        if (!cfm.comparator.isCompatibleWith(this.comparator)) {
            throw new ConfigurationException("comparators do not match or are not compatible.");
        }
    }

    public static void validateCompactionOptions(Class<? extends AbstractCompactionStrategy> strategyClass, Map<String, String> options) throws ConfigurationException {
        try {
            if (options == null) {
                return;
            }
            Method validateMethod = strategyClass.getMethod("validateOptions", Map.class);
            Map unknownOptions = (Map)validateMethod.invoke(null, options);
            if (!unknownOptions.isEmpty()) {
                throw new ConfigurationException(String.format("Properties specified %s are not understood by %s", unknownOptions.keySet(), strategyClass.getSimpleName()));
            }
        }
        catch (NoSuchMethodException e) {
            logger.warn("Compaction Strategy {} does not have a static validateOptions method. Validation ignored", (Object)strategyClass.getName());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getTargetException();
            }
            throw new ConfigurationException("Failed to validate compaction options");
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to validate compaction options");
        }
    }

    public static Class<? extends AbstractCompactionStrategy> createCompactionStrategy(String className) throws ConfigurationException {
        Class strategyClass = FBUtilities.classForName(className = className.contains(".") ? className : "org.apache.cassandra.db.compaction." + className, "compaction strategy");
        if (!AbstractCompactionStrategy.class.isAssignableFrom(strategyClass)) {
            throw new ConfigurationException(String.format("Specified compaction strategy class (%s) is not derived from AbstractReplicationStrategy", className));
        }
        return strategyClass;
    }

    public AbstractCompactionStrategy createCompactionStrategyInstance(ColumnFamilyStore cfs) {
        try {
            Constructor<? extends AbstractCompactionStrategy> constructor = this.compactionStrategyClass.getConstructor(ColumnFamilyStore.class, Map.class);
            return constructor.newInstance(cfs, this.compactionStrategyOptions);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public CfDef toThrift() {
        CfDef def = new CfDef(this.ksName, this.cfName);
        def.setColumn_type(this.cfType.name());
        if (this.isSuper()) {
            CompositeType ct = (CompositeType)this.comparator;
            def.setComparator_type(ct.types.get(0).toString());
            def.setSubcomparator_type(ct.types.get(1).toString());
        } else {
            def.setComparator_type(this.comparator.toString());
        }
        def.setComment(CFMetaData.enforceCommentNotNull(this.comment));
        def.setRead_repair_chance(this.readRepairChance);
        def.setDclocal_read_repair_chance(this.dcLocalReadRepairChance);
        def.setReplicate_on_write(this.replicateOnWrite);
        def.setPopulate_io_cache_on_flush(this.populateIoCacheOnFlush);
        def.setGc_grace_seconds(this.gcGraceSeconds);
        def.setDefault_validation_class(this.defaultValidator == null ? null : this.defaultValidator.toString());
        def.setKey_validation_class(this.keyValidator.toString());
        def.setMin_compaction_threshold(this.minCompactionThreshold);
        def.setMax_compaction_threshold(this.maxCompactionThreshold);
        if (this.partitionKeyColumns.size() == 1) {
            def.setKey_alias(this.partitionKeyColumns.get((int)0).name);
        }
        ArrayList<ColumnDef> column_meta = new ArrayList<ColumnDef>(this.column_metadata.size());
        for (ColumnDefinition cd : this.column_metadata.values()) {
            if (cd.type != ColumnDefinition.Type.REGULAR) continue;
            column_meta.add(cd.toThrift());
        }
        def.setColumn_metadata(column_meta);
        def.setCompaction_strategy(this.compactionStrategyClass.getName());
        def.setCompaction_strategy_options(new HashMap<String, String>(this.compactionStrategyOptions));
        def.setCompression_options(this.compressionParameters.asThriftOptions());
        if (this.bloomFilterFpChance != null) {
            def.setBloom_filter_fp_chance(this.bloomFilterFpChance.doubleValue());
        }
        def.setIndex_interval(this.indexInterval);
        def.setMemtable_flush_period_in_ms(this.memtableFlushPeriod);
        def.setCaching(this.caching.toString());
        def.setDefault_time_to_live(this.defaultTimeToLive);
        def.setSpeculative_retry(this.speculativeRetry.toString());
        def.setTriggers(this.triggers);
        return def;
    }

    public ColumnDefinition getColumnDefinition(ByteBuffer name) {
        return this.column_metadata.get(name);
    }

    public ColumnDefinition getColumnDefinitionFromColumnName(ByteBuffer columnName) {
        if (!this.isSuper() && this.comparator instanceof CompositeType) {
            CompositeType composite = (CompositeType)this.comparator;
            ByteBuffer[] components = composite.split(columnName);
            for (ColumnDefinition def : this.column_metadata.values()) {
                ByteBuffer toCompare = def.componentIndex == null ? columnName : components[def.componentIndex];
                if (!def.name.equals(toCompare)) continue;
                return def;
            }
            return null;
        }
        return this.column_metadata.get(columnName);
    }

    public ColumnDefinition getColumnDefinitionForIndex(String indexName) {
        for (ColumnDefinition def : this.column_metadata.values()) {
            if (!indexName.equals(def.getIndexName())) continue;
            return def;
        }
        return null;
    }

    public void addDefaultIndexNames() throws ConfigurationException {
        UUID cfId = Schema.instance.getId(this.ksName, this.cfName);
        if (cfId != null) {
            CFMetaData cfm = Schema.instance.getCFMetaData(cfId);
            for (Map.Entry entry : this.column_metadata.entrySet()) {
                String oldIndexName;
                ColumnDefinition newDef = (ColumnDefinition)entry.getValue();
                if (!cfm.column_metadata.containsKey(entry.getKey()) || newDef.getIndexType() == null || (oldIndexName = cfm.column_metadata.get(entry.getKey()).getIndexName()) == null) continue;
                if (newDef.getIndexName() != null && !oldIndexName.equals(newDef.getIndexName())) {
                    throw new ConfigurationException("Can't modify index name: was '" + oldIndexName + "' changed to '" + newDef.getIndexName() + "'.");
                }
                newDef.setIndexName(oldIndexName);
            }
        }
        Set<String> existingNames = CFMetaData.existingIndexNames(null);
        for (ColumnDefinition columnDefinition : this.column_metadata.values()) {
            String baseName;
            if (columnDefinition.getIndexType() == null || columnDefinition.getIndexName() != null) continue;
            String indexName = baseName = CFMetaData.getDefaultIndexName(this.cfName, this.getColumnDefinitionComparator(columnDefinition), columnDefinition.name);
            int i = 0;
            while (existingNames.contains(indexName)) {
                indexName = baseName + '_' + ++i;
            }
            columnDefinition.setIndexName(indexName);
        }
    }

    public static String getDefaultIndexName(String cfName, AbstractType<?> comparator, ByteBuffer columnName) {
        return (cfName + "_" + comparator.getString(columnName) + "_idx").replaceAll("\\W", "");
    }

    public Iterator<OnDiskAtom> getOnDiskIterator(DataInput in, int count, Descriptor.Version version) {
        return this.getOnDiskIterator(in, count, ColumnSerializer.Flag.LOCAL, Integer.MIN_VALUE, version);
    }

    public Iterator<OnDiskAtom> getOnDiskIterator(DataInput in, int count, ColumnSerializer.Flag flag, int expireBefore, Descriptor.Version version) {
        if (version.hasSuperColumns && this.cfType == ColumnFamilyType.Super) {
            return SuperColumns.onDiskIterator(in, count, flag, expireBefore);
        }
        return org.apache.cassandra.db.Column.onDiskIterator(in, count, flag, expireBefore, version);
    }

    public static boolean isNameValid(String name) {
        return name != null && !name.isEmpty() && name.length() <= 48 && name.matches("\\w+");
    }

    public static boolean isIndexNameValid(String name) {
        return name != null && !name.isEmpty() && name.matches("\\w+");
    }

    public CFMetaData validate() throws ConfigurationException {
        this.rebuild();
        if (!CFMetaData.isNameValid(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.ksName));
        }
        if (!CFMetaData.isNameValid(this.cfName)) {
            throw new ConfigurationException(String.format("ColumnFamily name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.cfName));
        }
        if (this.cfType == null) {
            throw new ConfigurationException(String.format("Invalid column family type for %s", this.cfName));
        }
        if (this.comparator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid comparator");
        }
        if (this.keyValidator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid key validator");
        }
        if (this.defaultValidator instanceof CounterColumnType) {
            for (ColumnDefinition def : this.regularColumns) {
                if (def.getValidator() instanceof CounterColumnType) continue;
                throw new ConfigurationException("Cannot add a non counter column (" + this.getColumnDefinitionComparator(def).getString(def.name) + ") in a counter column family");
            }
        } else {
            for (ColumnDefinition def : this.column_metadata.values()) {
                if (!(def.getValidator() instanceof CounterColumnType)) continue;
                throw new ConfigurationException("Cannot add a counter column (" + this.getColumnDefinitionComparator(def).getString(def.name) + ") in a non counter column family");
            }
        }
        for (ColumnDefinition def : this.partitionKeyColumns) {
            CFMetaData.validateAlias(def, "Key");
        }
        for (ColumnDefinition def : this.clusteringKeyColumns) {
            CFMetaData.validateAlias(def, "Column");
        }
        if (this.compactValueColumn != null) {
            CFMetaData.validateAlias(this.compactValueColumn, "Value");
        }
        Set<String> indexNames = CFMetaData.existingIndexNames(this.cfName);
        for (ColumnDefinition c : this.column_metadata.values()) {
            AbstractType<?> comparator = this.getColumnDefinitionComparator(c);
            try {
                comparator.validate(c.name);
            }
            catch (MarshalException e) {
                throw new ConfigurationException(String.format("Column name %s is not valid for comparator %s", ByteBufferUtil.bytesToHex(c.name), comparator));
            }
            if (c.getIndexType() == null) {
                if (c.getIndexName() == null) continue;
                throw new ConfigurationException("Index name cannot be set without index type");
            }
            if (this.cfType == ColumnFamilyType.Super) {
                throw new ConfigurationException("Secondary indexes are not supported on super column families");
            }
            if (!CFMetaData.isIndexNameValid(c.getIndexName())) {
                throw new ConfigurationException("Illegal index name " + c.getIndexName());
            }
            if (indexNames.contains(c.getIndexName())) {
                throw new ConfigurationException("Duplicate index name " + c.getIndexName());
            }
            indexNames.add(c.getIndexName());
            if (!(c.getIndexType() != IndexType.CUSTOM || c.getIndexOptions() != null && c.getIndexOptions().containsKey("class_name"))) {
                throw new ConfigurationException("Required index option missing: class_name");
            }
            SecondaryIndex.createInstance(null, c);
        }
        this.validateCompactionThresholds();
        if (this.bloomFilterFpChance != null && this.bloomFilterFpChance == 0.0) {
            throw new ConfigurationException("Zero false positives is impossible; bloom filter false positive chance bffpc must be 0 < bffpc <= 1");
        }
        return this;
    }

    private static Set<String> existingIndexNames(String cfToExclude) {
        HashSet<String> indexNames = new HashSet<String>();
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            if (cfToExclude != null && cfs.name.equals(cfToExclude)) continue;
            for (ColumnDefinition cd : cfs.metadata.allColumns()) {
                indexNames.add(cd.getIndexName());
            }
        }
        return indexNames;
    }

    private static void validateAlias(ColumnDefinition alias, String msg) throws ConfigurationException {
        try {
            UTF8Type.instance.validate(alias.name);
        }
        catch (MarshalException e) {
            throw new ConfigurationException(msg + " alias must be UTF8");
        }
    }

    private void validateCompactionThresholds() throws ConfigurationException {
        if (this.maxCompactionThreshold == 0) {
            logger.warn("Disabling compaction by setting max or min compaction has been deprecated, set the compaction strategy option 'enabled' to 'false' instead");
            return;
        }
        if (this.minCompactionThreshold <= 1) {
            throw new ConfigurationException(String.format("Min compaction threshold cannot be less than 2 (got %d).", this.minCompactionThreshold));
        }
        if (this.minCompactionThreshold > this.maxCompactionThreshold) {
            throw new ConfigurationException(String.format("Min compaction threshold (got %d) cannot be greater than max compaction threshold (got %d)", this.minCompactionThreshold, this.maxCompactionThreshold));
        }
    }

    public RowMutation toSchemaUpdate(CFMetaData newState, long modificationTimestamp, boolean fromThrift) {
        RowMutation rm = new RowMutation("system", SystemKeyspace.getSchemaKSKey(this.ksName));
        newState.toSchemaNoColumns(rm, modificationTimestamp);
        MapDifference columnDiff = Maps.difference(this.column_metadata, newState.column_metadata);
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnLeft().values()) {
            if (fromThrift && cd.type != ColumnDefinition.Type.REGULAR) continue;
            cd.deleteFromSchema(rm, this.cfName, modificationTimestamp);
        }
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnRight().values()) {
            cd.toSchema(rm, this.cfName, this.getColumnDefinitionComparator(cd), modificationTimestamp);
        }
        for (ByteBuffer name : columnDiff.entriesDiffering().keySet()) {
            ColumnDefinition columnDefinition = newState.getColumnDefinition(name);
            columnDefinition.toSchema(rm, this.cfName, this.getColumnDefinitionComparator(columnDefinition), modificationTimestamp);
        }
        MapDifference tdiffrence = Maps.difference(this.triggers, newState.triggers);
        for (Map.Entry<String, Map<String, String>> entry : tdiffrence.entriesOnlyOnLeft().entrySet()) {
            TriggerOptions.deleteColumns(rm, this.cfName, entry, modificationTimestamp);
        }
        for (Map.Entry<String, Map<String, String>> entry : tdiffrence.entriesOnlyOnRight().entrySet()) {
            TriggerOptions.addColumns(rm, this.cfName, entry, modificationTimestamp);
        }
        return rm;
    }

    public RowMutation dropFromSchema(long timestamp) {
        RowMutation rm = new RowMutation("system", SystemKeyspace.getSchemaKSKey(this.ksName));
        ColumnFamily cf = rm.addOrGet(SchemaColumnFamiliesCf);
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        ColumnNameBuilder builder = SchemaColumnFamiliesCf.getCfDef().getColumnNameBuilder();
        builder.add(ByteBufferUtil.bytes(this.cfName));
        cf.addAtom(new RangeTombstone(builder.build(), builder.buildAsEndOfRange(), timestamp, ldt));
        ColumnFamily tcf = rm.addOrGet(SchemaTriggersCf);
        ColumnNameBuilder tbuilder = SchemaTriggersCf.getCfDef().getColumnNameBuilder();
        tbuilder.add(ByteBufferUtil.bytes(this.cfName));
        tcf.addAtom(new RangeTombstone(tbuilder.build(), tbuilder.buildAsEndOfRange(), timestamp, ldt));
        for (ColumnDefinition cd : this.column_metadata.values()) {
            cd.deleteFromSchema(rm, this.cfName, timestamp);
        }
        return rm;
    }

    public void toSchema(RowMutation rm, long timestamp) {
        this.toSchemaNoColumns(rm, timestamp);
        for (ColumnDefinition cd : this.column_metadata.values()) {
            cd.toSchema(rm, this.cfName, this.getColumnDefinitionComparator(cd), timestamp);
        }
    }

    private void toSchemaNoColumns(RowMutation rm, long timestamp) {
        ColumnFamily cf = rm.addOrGet(SchemaColumnFamiliesCf);
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        cf.addColumn(org.apache.cassandra.db.Column.create("", timestamp, this.cfName, ""));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.cfType.toString(), timestamp, this.cfName, "type"));
        if (this.isSuper()) {
            CompositeType ct = (CompositeType)this.comparator;
            cf.addColumn(org.apache.cassandra.db.Column.create(ct.types.get(0).toString(), timestamp, this.cfName, "comparator"));
            cf.addColumn(org.apache.cassandra.db.Column.create(ct.types.get(1).toString(), timestamp, this.cfName, "subcomparator"));
        } else {
            cf.addColumn(org.apache.cassandra.db.Column.create(this.comparator.toString(), timestamp, this.cfName, "comparator"));
        }
        cf.addColumn(this.comment == null ? DeletedColumn.create(ldt, timestamp, this.cfName, "comment") : org.apache.cassandra.db.Column.create(this.comment, timestamp, this.cfName, "comment"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.readRepairChance, timestamp, this.cfName, "read_repair_chance"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.dcLocalReadRepairChance, timestamp, this.cfName, "local_read_repair_chance"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.replicateOnWrite, timestamp, this.cfName, "replicate_on_write"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.populateIoCacheOnFlush, timestamp, this.cfName, "populate_io_cache_on_flush"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.gcGraceSeconds, timestamp, this.cfName, "gc_grace_seconds"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.defaultValidator.toString(), timestamp, this.cfName, "default_validator"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.keyValidator.toString(), timestamp, this.cfName, "key_validator"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.minCompactionThreshold, timestamp, this.cfName, "min_compaction_threshold"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.maxCompactionThreshold, timestamp, this.cfName, "max_compaction_threshold"));
        cf.addColumn(this.bloomFilterFpChance == null ? DeletedColumn.create(ldt, timestamp, this.cfName, "bloomFilterFpChance") : org.apache.cassandra.db.Column.create(this.bloomFilterFpChance, timestamp, this.cfName, "bloom_filter_fp_chance"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.memtableFlushPeriod, timestamp, this.cfName, "memtable_flush_period_in_ms"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.caching.toString(), timestamp, this.cfName, "caching"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.defaultTimeToLive, timestamp, this.cfName, "default_time_to_live"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.compactionStrategyClass.getName(), timestamp, this.cfName, "compaction_strategy_class"));
        cf.addColumn(org.apache.cassandra.db.Column.create(FBUtilities.json(this.compressionParameters.asThriftOptions()), timestamp, this.cfName, "compression_parameters"));
        cf.addColumn(org.apache.cassandra.db.Column.create(FBUtilities.json(this.compactionStrategyOptions), timestamp, this.cfName, "compaction_strategy_options"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.indexInterval, timestamp, this.cfName, "index_interval"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.speculativeRetry.toString(), timestamp, this.cfName, "speculative_retry"));
        for (Map.Entry<ByteBuffer, Long> entry : this.droppedColumns.entrySet()) {
            cf.addColumn(new org.apache.cassandra.db.Column(this.makeDroppedColumnName(entry.getKey()), LongType.instance.decompose(entry.getValue()), timestamp));
        }
        cf.addColumn(org.apache.cassandra.db.Column.create(this.aliasesToJson(this.partitionKeyColumns), timestamp, this.cfName, "key_aliases"));
        cf.addColumn(org.apache.cassandra.db.Column.create(this.aliasesToJson(this.clusteringKeyColumns), timestamp, this.cfName, "column_aliases"));
        cf.addColumn(this.compactValueColumn == null ? DeletedColumn.create(ldt, timestamp, this.cfName, "value_alias") : org.apache.cassandra.db.Column.create(this.compactValueColumn.name, timestamp, this.cfName, "value_alias"));
    }

    static CFMetaData fromSchemaNoColumns(UntypedResultSet.Row result) {
        try {
            CFMetaData cfm = new CFMetaData(result.getString("keyspace_name"), result.getString("columnfamily_name"), ColumnFamilyType.valueOf(result.getString("type")), TypeParser.parse(result.getString("comparator")), result.has("subcomparator") ? TypeParser.parse(result.getString("subcomparator")) : null);
            cfm.readRepairChance(result.getDouble("read_repair_chance"));
            cfm.dcLocalReadRepairChance(result.getDouble("local_read_repair_chance"));
            cfm.replicateOnWrite(result.getBoolean("replicate_on_write"));
            cfm.gcGraceSeconds(result.getInt("gc_grace_seconds"));
            cfm.defaultValidator(TypeParser.parse(result.getString("default_validator")));
            cfm.keyValidator(TypeParser.parse(result.getString("key_validator")));
            cfm.minCompactionThreshold(result.getInt("min_compaction_threshold"));
            cfm.maxCompactionThreshold(result.getInt("max_compaction_threshold"));
            if (result.has("comment")) {
                cfm.comment(result.getString("comment"));
            }
            if (result.has("bloom_filter_fp_chance")) {
                cfm.bloomFilterFpChance(result.getDouble("bloom_filter_fp_chance"));
            }
            if (result.has("memtable_flush_period_in_ms")) {
                cfm.memtableFlushPeriod(result.getInt("memtable_flush_period_in_ms"));
            }
            cfm.caching(Caching.valueOf(result.getString("caching")));
            if (result.has("default_time_to_live")) {
                cfm.defaultTimeToLive(result.getInt("default_time_to_live"));
            }
            if (result.has("speculative_retry")) {
                cfm.speculativeRetry(SpeculativeRetry.fromString(result.getString("speculative_retry")));
            }
            cfm.compactionStrategyClass(CFMetaData.createCompactionStrategy(result.getString("compaction_strategy_class")));
            cfm.compressionParameters(CompressionParameters.create(FBUtilities.fromJsonMap(result.getString("compression_parameters"))));
            cfm.compactionStrategyOptions(FBUtilities.fromJsonMap(result.getString("compaction_strategy_options")));
            if (result.has("index_interval")) {
                cfm.indexInterval(result.getInt("index_interval"));
            }
            if (result.has("populate_io_cache_on_flush")) {
                cfm.populateIoCacheOnFlush(result.getBoolean("populate_io_cache_on_flush"));
            }
            if (result.has("key_aliases")) {
                cfm.addColumnMetadataFromAliases(CFMetaData.aliasesFromStrings(FBUtilities.fromJsonList(result.getString("key_aliases"))), cfm.keyValidator, ColumnDefinition.Type.PARTITION_KEY);
            } else if (result.has("key_alias")) {
                cfm.addColumnMetadataFromAliases(Collections.singletonList(result.getBytes("key_alias")), cfm.keyValidator, ColumnDefinition.Type.PARTITION_KEY);
            }
            cfm.addColumnMetadataFromAliases(CFMetaData.aliasesFromStrings(FBUtilities.fromJsonList(result.getString("column_aliases"))), cfm.comparator, ColumnDefinition.Type.CLUSTERING_KEY);
            if (result.has("value_alias")) {
                cfm.addColumnMetadataFromAliases(Collections.singletonList(result.getBytes("value_alias")), cfm.defaultValidator, ColumnDefinition.Type.COMPACT_VALUE);
            }
            if (result.has("dropped_columns")) {
                cfm.droppedColumns(CFMetaData.convertDroppedColumns(result.getMap("dropped_columns", UTF8Type.instance, LongType.instance)));
            }
            return cfm;
        }
        catch (SyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void addColumnMetadataFromAliases(List<ByteBuffer> aliases, AbstractType<?> comparator, ColumnDefinition.Type type) {
        if (comparator instanceof CompositeType) {
            CompositeType ct = (CompositeType)comparator;
            for (int i = 0; i < aliases.size(); ++i) {
                if (aliases.get(i) == null) continue;
                this.column_metadata.put(aliases.get(i), new ColumnDefinition(aliases.get(i), ct.types.get(i), i, type));
            }
        } else {
            assert (aliases.size() <= 1);
            if (!aliases.isEmpty() && aliases.get(0) != null) {
                this.column_metadata.put(aliases.get(0), new ColumnDefinition(aliases.get(0), comparator, null, type));
            }
        }
    }

    public static CFMetaData fromSchema(UntypedResultSet.Row result) {
        CFMetaData cfDef = CFMetaData.fromSchemaNoColumns(result);
        cfDef.triggers(TriggerOptions.getAllTriggers(cfDef.ksName, cfDef.cfName));
        Row serializedColumnDefinitions = ColumnDefinition.readSchema(cfDef.ksName, cfDef.cfName);
        return CFMetaData.addColumnDefinitionSchema(cfDef, serializedColumnDefinitions);
    }

    private static CFMetaData fromSchema(Row row) {
        UntypedResultSet.Row result = QueryProcessor.resultify("SELECT * FROM system.schema_columnfamilies", row).one();
        return CFMetaData.fromSchema(result);
    }

    private String aliasesToJson(List<ColumnDefinition> rawAliases) {
        ArrayList aliases = new ArrayList(rawAliases.size());
        for (ColumnDefinition rawAlias : rawAliases) {
            aliases.add(UTF8Type.instance.compose(rawAlias.name));
        }
        return FBUtilities.json(aliases);
    }

    private static List<ByteBuffer> aliasesFromStrings(List<String> aliases) {
        ArrayList<ByteBuffer> rawAliases = new ArrayList<ByteBuffer>(aliases.size());
        for (String alias : aliases) {
            rawAliases.add(UTF8Type.instance.decompose(alias));
        }
        return rawAliases;
    }

    private static Map<ByteBuffer, Long> convertDroppedColumns(Map<String, Long> raw) {
        HashMap converted = Maps.newHashMap();
        for (Map.Entry<String, Long> entry : raw.entrySet()) {
            converted.put(UTF8Type.instance.decompose(entry.getKey()), entry.getValue());
        }
        return converted;
    }

    private ByteBuffer makeDroppedColumnName(ByteBuffer column) {
        ColumnNameBuilder builder = CFMetaData.SchemaColumnFamiliesCf.cqlCfDef.getColumnNameBuilder();
        builder.add(UTF8Type.instance.decompose(this.cfName));
        builder.add(UTF8Type.instance.decompose("dropped_columns"));
        return builder.add(column).build();
    }

    public RowMutation toSchema(long timestamp) throws ConfigurationException {
        RowMutation rm = new RowMutation("system", SystemKeyspace.getSchemaKSKey(this.ksName));
        this.toSchema(rm, timestamp);
        return rm;
    }

    public AbstractType<?> getColumnDefinitionComparator(ColumnDefinition def) {
        return this.getComponentComparator(def.componentIndex, def.type);
    }

    public AbstractType<?> getComponentComparator(Integer componentIndex, ColumnDefinition.Type type) {
        switch (type) {
            case REGULAR: {
                AbstractType<?> cfComparator;
                AbstractType<?> abstractType = cfComparator = this.cfType == ColumnFamilyType.Super ? ((CompositeType)this.comparator).types.get(1) : this.comparator;
                if (cfComparator instanceof CompositeType) {
                    if (componentIndex == null) {
                        return cfComparator;
                    }
                    List<AbstractType<?>> types = ((CompositeType)cfComparator).types;
                    AbstractType<?> t = types.get(componentIndex);
                    assert (t != null) : "Non-sensical component index";
                    return t;
                }
                return cfComparator;
            }
        }
        return UTF8Type.instance;
    }

    static CFMetaData addColumnDefinitionSchema(CFMetaData cfDef, Row serializedColumnDefinitions) {
        for (ColumnDefinition cd : ColumnDefinition.fromSchema(serializedColumnDefinitions, cfDef)) {
            cfDef.column_metadata.put(cd.name, cd);
        }
        return cfDef.rebuild();
    }

    public void addColumnDefinition(ColumnDefinition def) throws ConfigurationException {
        if (this.column_metadata.containsKey(def.name)) {
            throw new ConfigurationException(String.format("Cannot add column %s, a column with the same name already exists", this.getColumnDefinitionComparator(def).getString(def.name)));
        }
        this.addOrReplaceColumnDefinition(def);
    }

    public void addOrReplaceColumnDefinition(ColumnDefinition def) {
        this.column_metadata.put(def.name, def);
    }

    public boolean removeColumnDefinition(ColumnDefinition def) {
        return this.column_metadata.remove(def.name) != null;
    }

    public void recordColumnDrop(ColumnDefinition def) {
        assert (def.componentIndex != null);
        this.droppedColumns.put(def.name, FBUtilities.timestampMicros());
    }

    public void renameColumn(ByteBuffer from, String strFrom, ByteBuffer to, String strTo) throws InvalidRequestException {
        ColumnDefinition def = this.column_metadata.get(from);
        if (def == null) {
            throw new InvalidRequestException(String.format("Cannot rename unknown column %s in keyspace %s", strFrom, this.cfName));
        }
        if (this.column_metadata.get(to) != null) {
            throw new InvalidRequestException(String.format("Cannot rename column %s to %s in keyspace %s; another column of that name already exist", strFrom, strTo, this.cfName));
        }
        if (def.type == ColumnDefinition.Type.REGULAR) {
            throw new InvalidRequestException(String.format("Cannot rename non PRIMARY KEY part %s", strFrom));
        }
        if (def.isIndexed()) {
            throw new InvalidRequestException(String.format("Cannot rename column %s because it is secondary indexed", strFrom));
        }
        ColumnDefinition newDef = def.cloneWithNewName(to);
        this.column_metadata.put(newDef.name, newDef);
        this.column_metadata.remove(def.name);
    }

    public CFMetaData rebuild() {
        this.rebuildCQL3Metadata();
        this.cqlCfDef = new CFDefinition(this);
        return this;
    }

    public CFDefinition getCfDef() {
        assert (this.cqlCfDef != null);
        return this.cqlCfDef;
    }

    private void rebuildCQL3Metadata() {
        List<ColumnDefinition> pkCols = CFMetaData.nullInitializedList(this.keyValidator.componentsCount());
        boolean isDense = CFMetaData.isDense(this.comparator, this.column_metadata.values());
        int nbCkCols = isDense ? this.comparator.componentsCount() : this.comparator.componentsCount() - (this.hasCollection() ? 2 : 1);
        List<ColumnDefinition> ckCols = CFMetaData.nullInitializedList(nbCkCols);
        HashSet<ColumnDefinition> regCols = new HashSet<ColumnDefinition>();
        ColumnDefinition compactCol = null;
        for (ColumnDefinition def : this.column_metadata.values()) {
            switch (def.type) {
                case PARTITION_KEY: {
                    assert (def.componentIndex != null || !(this.keyValidator instanceof CompositeType));
                    pkCols.set(def.componentIndex == null ? 0 : def.componentIndex, def);
                    break;
                }
                case CLUSTERING_KEY: {
                    assert (def.componentIndex != null || !(this.comparator instanceof CompositeType));
                    ckCols.set(def.componentIndex == null ? 0 : def.componentIndex, def);
                    break;
                }
                case REGULAR: {
                    regCols.add(def);
                    break;
                }
                case COMPACT_VALUE: {
                    assert (compactCol == null) : "There shouldn't be more than one compact value defined: got " + compactCol + " and " + def;
                    compactCol = def;
                }
            }
        }
        this.partitionKeyColumns = this.addDefaultKeyAliases(pkCols);
        this.clusteringKeyColumns = this.addDefaultColumnAliases(ckCols);
        this.regularColumns = regCols;
        this.compactValueColumn = this.addDefaultValueAlias(compactCol, isDense);
    }

    private List<ColumnDefinition> addDefaultKeyAliases(List<ColumnDefinition> pkCols) {
        for (int i = 0; i < pkCols.size(); ++i) {
            if (pkCols.get(i) != null) continue;
            Integer idx = null;
            AbstractType<?> type = this.keyValidator;
            if (this.keyValidator instanceof CompositeType) {
                idx = i;
                type = ((CompositeType)this.keyValidator).types.get(i);
            }
            ByteBuffer name = ByteBufferUtil.bytes(i == 0 ? DEFAULT_KEY_ALIAS : DEFAULT_KEY_ALIAS + (i + 1));
            ColumnDefinition newDef = ColumnDefinition.partitionKeyDef(name, type, idx);
            this.column_metadata.put(newDef.name, newDef);
            pkCols.set(i, newDef);
        }
        return pkCols;
    }

    private List<ColumnDefinition> addDefaultColumnAliases(List<ColumnDefinition> ckCols) {
        for (int i = 0; i < ckCols.size(); ++i) {
            if (ckCols.get(i) != null) continue;
            Integer idx = null;
            AbstractType<?> type = this.comparator;
            if (this.comparator instanceof CompositeType) {
                idx = i;
                type = ((CompositeType)this.comparator).types.get(i);
            }
            ByteBuffer name = ByteBufferUtil.bytes(DEFAULT_COLUMN_ALIAS + (i + 1));
            ColumnDefinition newDef = ColumnDefinition.clusteringKeyDef(name, type, idx);
            this.column_metadata.put(newDef.name, newDef);
            ckCols.set(i, newDef);
        }
        return ckCols;
    }

    private ColumnDefinition addDefaultValueAlias(ColumnDefinition compactValueDef, boolean isDense) {
        if (isDense) {
            if (compactValueDef != null) {
                return compactValueDef;
            }
            ColumnDefinition newDef = ColumnDefinition.compactValueDef(ByteBufferUtil.bytes(DEFAULT_VALUE_ALIAS), this.defaultValidator);
            this.column_metadata.put(newDef.name, newDef);
            return newDef;
        }
        assert (compactValueDef == null);
        return null;
    }

    private boolean hasCollection() {
        if (this.isSuper() || !(this.comparator instanceof CompositeType)) {
            return false;
        }
        List<AbstractType<?>> types = ((CompositeType)this.comparator).types;
        return types.get(types.size() - 1) instanceof ColumnToCollectionType;
    }

    private static boolean isDense(AbstractType<?> comparator, Collection<ColumnDefinition> defs) {
        boolean hasRegular = false;
        int maxClusteringIdx = -1;
        for (ColumnDefinition def : defs) {
            switch (def.type) {
                case CLUSTERING_KEY: {
                    maxClusteringIdx = Math.max(maxClusteringIdx, def.componentIndex == null ? 0 : def.componentIndex);
                    break;
                }
                case REGULAR: {
                    hasRegular = true;
                }
            }
        }
        return maxClusteringIdx >= 0 ? maxClusteringIdx == comparator.componentsCount() - 1 : !hasRegular && !CFMetaData.isCQL3OnlyPKComparator(comparator);
    }

    private static boolean isCQL3OnlyPKComparator(AbstractType<?> comparator) {
        if (!(comparator instanceof CompositeType)) {
            return false;
        }
        CompositeType ct = (CompositeType)comparator;
        return ct.types.size() == 1 && ct.types.get(0) instanceof UTF8Type;
    }

    private static <T> List<T> nullInitializedList(int size) {
        ArrayList<Object> l = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            l.add(null);
        }
        return l;
    }

    public boolean isThriftCompatible() {
        if (this.isSuper()) {
            return true;
        }
        for (ColumnDefinition def : this.column_metadata.values()) {
            if (def.type != ColumnDefinition.Type.REGULAR || def.isThriftCompatible()) continue;
            return false;
        }
        return true;
    }

    public void validateColumns(Iterable<org.apache.cassandra.db.Column> columns) {
        for (org.apache.cassandra.db.Column column : columns) {
            column.validateFields(this);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cfId", (Object)this.cfId).append("ksName", (Object)this.ksName).append("cfName", (Object)this.cfName).append("cfType", (Object)this.cfType).append("comparator", this.comparator).append("comment", (Object)this.comment).append("readRepairChance", this.readRepairChance).append("dclocalReadRepairChance", this.dcLocalReadRepairChance).append("replicateOnWrite", this.replicateOnWrite).append("gcGraceSeconds", this.gcGraceSeconds).append("defaultValidator", this.defaultValidator).append("keyValidator", this.keyValidator).append("minCompactionThreshold", this.minCompactionThreshold).append("maxCompactionThreshold", this.maxCompactionThreshold).append("column_metadata", this.column_metadata).append("compactionStrategyClass", this.compactionStrategyClass).append("compactionStrategyOptions", this.compactionStrategyOptions).append("compressionOptions", this.compressionParameters.asThriftOptions()).append("bloomFilterFpChance", (Object)this.bloomFilterFpChance).append("memtable_flush_period_in_ms", this.memtableFlushPeriod).append("caching", (Object)this.caching).append("defaultTimeToLive", this.defaultTimeToLive).append("speculative_retry", (Object)this.speculativeRetry).append("indexInterval", this.indexInterval).append("populateIoCacheOnFlush", this.populateIoCacheOnFlush).append("droppedColumns", this.droppedColumns).append("triggers", this.triggers).toString();
    }

    public static class SpeculativeRetry {
        public final RetryType type;
        public final double value;

        private SpeculativeRetry(RetryType type, double value) {
            this.type = type;
            this.value = value;
        }

        public static SpeculativeRetry fromString(String retry) throws ConfigurationException {
            String name = retry.toUpperCase();
            try {
                if (name.endsWith(RetryType.PERCENTILE.toString())) {
                    double value = Double.parseDouble(name.substring(0, name.length() - 10));
                    if (value > 100.0 || value < 0.0) {
                        throw new ConfigurationException("PERCENTILE should be between 0 and 100");
                    }
                    return new SpeculativeRetry(RetryType.PERCENTILE, value / 100.0);
                }
                if (name.endsWith("MS")) {
                    double value = Double.parseDouble(name.substring(0, name.length() - 2));
                    return new SpeculativeRetry(RetryType.CUSTOM, value);
                }
                return new SpeculativeRetry(RetryType.valueOf(name), 0.0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConfigurationException("invalid speculative_retry type: " + retry);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SpeculativeRetry)) {
                return false;
            }
            SpeculativeRetry rhs = (SpeculativeRetry)obj;
            return Objects.equal((Object)((Object)this.type), (Object)((Object)rhs.type)) && Objects.equal((Object)this.value, (Object)rhs.value);
        }

        public String toString() {
            switch (this.type) {
                case PERCENTILE: {
                    return this.value + "PERCENTILE";
                }
                case CUSTOM: {
                    return this.value + "ms";
                }
            }
            return this.type.toString();
        }

        public static enum RetryType {
            NONE,
            CUSTOM,
            PERCENTILE,
            ALWAYS;

        }
    }

    public static enum Caching {
        ALL,
        KEYS_ONLY,
        ROWS_ONLY,
        NONE;


        public static Caching fromString(String cache) throws ConfigurationException {
            try {
                return Caching.valueOf(cache.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(String.format("%s not found, available types: %s.", cache, StringUtils.join((Object[])Caching.values(), (String)", ")));
            }
        }
    }
}

