/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import java.nio.ByteBuffer;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.ISaslAwareAuthenticator;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ServerConnection;
import org.apache.cassandra.transport.messages.AuthChallenge;
import org.apache.cassandra.transport.messages.AuthSuccess;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.jboss.netty.buffer.ChannelBuffer;

public class AuthResponse
extends Message.Request {
    public static final Message.Codec<AuthResponse> codec = new Message.Codec<AuthResponse>(){

        @Override
        public AuthResponse decode(ChannelBuffer body, int version) {
            if (version == 1) {
                throw new ProtocolException("SASL Authentication is not supported in version 1 of the protocol");
            }
            ByteBuffer b = CBUtil.readValue(body);
            byte[] token = new byte[b.remaining()];
            b.get(token);
            return new AuthResponse(token);
        }

        @Override
        public ChannelBuffer encode(AuthResponse response, int version) {
            return CBUtil.valueToCB(response.token);
        }
    };
    private byte[] token;

    public AuthResponse(byte[] token) {
        super(Message.Type.AUTH_RESPONSE);
        this.token = token;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this, this.getVersion());
    }

    @Override
    public Message.Response execute(QueryState queryState) {
        try {
            ISaslAwareAuthenticator.SaslAuthenticator authenticator = ((ServerConnection)this.connection).getAuthenticator();
            byte[] challenge = authenticator.evaluateResponse(this.token == null ? new byte[]{} : this.token);
            if (authenticator.isComplete()) {
                AuthenticatedUser user = authenticator.getAuthenticatedUser();
                queryState.getClientState().login(user);
                return new AuthSuccess(challenge);
            }
            return new AuthChallenge(challenge);
        }
        catch (AuthenticationException e) {
            return ErrorMessage.fromException(e);
        }
    }
}

