/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.streaming.StreamManagerMBean;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamState;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class StreamManager
implements StreamManagerMBean {
    public static final StreamManager instance = new StreamManager();
    private static final RateLimiter limiter = RateLimiter.create((double)Double.MAX_VALUE);
    private final Map<UUID, StreamResultFuture> currentStreams = new NonBlockingHashMap();

    public static RateLimiter getRateLimiter() {
        double currentThroughput = (double)DatabaseDescriptor.getStreamThroughputOutboundMegabitsPerSec() * 1024.0 * 1024.0;
        if (currentThroughput == 0.0) {
            currentThroughput = Double.MAX_VALUE;
        }
        if (limiter.getRate() != currentThroughput) {
            limiter.setRate(currentThroughput);
        }
        return limiter;
    }

    @Override
    public Set<StreamState> getCurrentStreams() {
        return Sets.newHashSet((Iterable)Iterables.transform(this.currentStreams.values(), (Function)new Function<StreamResultFuture, StreamState>(){

            public StreamState apply(StreamResultFuture input) {
                return input.getCurrentState();
            }
        }));
    }

    public void register(final StreamResultFuture result) {
        result.addListener(new Runnable(){

            @Override
            public void run() {
                StreamManager.this.currentStreams.remove(result.planId);
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        this.currentStreams.put(result.planId, result);
    }

    public StreamResultFuture getStream(UUID planId) {
        return this.currentStreams.get(planId);
    }
}

