/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class LongSerializer
implements TypeSerializer<Long> {
    public static final LongSerializer instance = new LongSerializer();

    @Override
    public Long serialize(ByteBuffer bytes) {
        return ByteBufferUtil.toLong(bytes);
    }

    @Override
    public ByteBuffer deserialize(Long value) {
        return ByteBufferUtil.bytes(value);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 8 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 8 or 0 byte long (%d)", bytes.remaining()));
        }
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 8) {
            throw new MarshalException("A long is exactly 8 bytes: " + bytes.remaining());
        }
        return String.valueOf(ByteBufferUtil.toLong(bytes));
    }

    @Override
    public String toString(Long value) {
        return String.valueOf(value);
    }

    @Override
    public Class<Long> getType() {
        return Long.class;
    }
}

