/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class BytesSerializer
implements TypeSerializer<ByteBuffer> {
    public static final BytesSerializer instance = new BytesSerializer();

    @Override
    public ByteBuffer serialize(ByteBuffer bytes) {
        return bytes.duplicate();
    }

    @Override
    public ByteBuffer deserialize(ByteBuffer value) {
        return value;
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return ByteBufferUtil.bytesToHex(bytes);
    }

    @Override
    public String toString(ByteBuffer value) {
        return this.getString(value);
    }

    @Override
    public Class<ByteBuffer> getType() {
        return ByteBuffer.class;
    }
}

