/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;

public class AsyncOneResponse<T>
implements IAsyncCallback<T> {
    private T result;
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final long start = System.nanoTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long timeout, TimeUnit tu) throws TimeoutException {
        this.lock.lock();
        try {
            boolean bVal = true;
            try {
                if (!this.done.get()) {
                    long overall_timeout = (timeout = tu.toNanos(timeout)) - (System.nanoTime() - this.start);
                    bVal = overall_timeout > 0L && this.condition.await(overall_timeout, TimeUnit.NANOSECONDS);
                }
            }
            catch (InterruptedException ex) {
                throw new AssertionError((Object)ex);
            }
            if (!bVal && !this.done.get()) {
                throw new TimeoutException("Operation timed out.");
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void response(MessageIn<T> response) {
        try {
            this.lock.lock();
            if (!this.done.get()) {
                this.result = response.payload;
                this.done.set(true);
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }
}

