/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Pair;

public class SSTableLoader
implements StreamEventHandler {
    private final File directory;
    private final String keyspace;
    private final Client client;
    private final OutputHandler outputHandler;
    private final Set<InetAddress> failedHosts = new HashSet<InetAddress>();

    public SSTableLoader(File directory, Client client, OutputHandler outputHandler) {
        this.directory = directory;
        this.keyspace = directory.getParentFile().getName();
        this.client = client;
        this.outputHandler = outputHandler;
    }

    protected Collection<SSTableReader> openSSTables() {
        final LinkedList<SSTableReader> sstables = new LinkedList<SSTableReader>();
        this.directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Descriptor desc;
                if (new File(dir, name).isDirectory()) {
                    return false;
                }
                Pair<Descriptor, Component> p = SSTable.tryComponentFromFilename(dir, name);
                Descriptor descriptor = desc = p == null ? null : (Descriptor)p.left;
                if (p == null || !((Component)p.right).equals(Component.DATA) || desc.temporary) {
                    return false;
                }
                if (!new File(desc.filenameFor(Component.PRIMARY_INDEX)).exists()) {
                    SSTableLoader.this.outputHandler.output(String.format("Skipping file %s because index is missing", name));
                    return false;
                }
                if (!SSTableLoader.this.client.validateColumnFamily(SSTableLoader.this.keyspace, desc.cfname)) {
                    SSTableLoader.this.outputHandler.output(String.format("Skipping file %s: column family %s.%s doesn't exist", name, SSTableLoader.this.keyspace, desc.cfname));
                    return false;
                }
                HashSet<Component> components = new HashSet<Component>();
                components.add(Component.DATA);
                components.add(Component.PRIMARY_INDEX);
                if (new File(desc.filenameFor(Component.COMPRESSION_INFO)).exists()) {
                    components.add(Component.COMPRESSION_INFO);
                }
                if (new File(desc.filenameFor(Component.STATS)).exists()) {
                    components.add(Component.STATS);
                }
                try {
                    sstables.add(SSTableReader.open(desc, components, null, SSTableLoader.this.client.getPartitioner()));
                }
                catch (IOException e) {
                    SSTableLoader.this.outputHandler.output(String.format("Skipping file %s, error opening it: %s", name, e.getMessage()));
                }
                return false;
            }
        });
        return sstables;
    }

    public StreamResultFuture stream() {
        return this.stream(Collections.emptySet());
    }

    public StreamResultFuture stream(Set<InetAddress> toIgnore) {
        this.client.init(this.keyspace);
        StreamPlan plan = new StreamPlan("Bulk Load");
        Collection<SSTableReader> sstables = this.openSSTables();
        if (sstables.isEmpty()) {
            return plan.execute();
        }
        Map<InetAddress, Collection<Range<Token>>> endpointToRanges = this.client.getEndpointToRangesMap();
        this.outputHandler.output(String.format("Streaming relevant part of %sto %s", this.names(sstables), endpointToRanges.keySet()));
        for (Map.Entry<InetAddress, Collection<Range<Token>>> entry : endpointToRanges.entrySet()) {
            InetAddress remote = entry.getKey();
            if (toIgnore.contains(remote)) continue;
            Collection<Range<Token>> ranges = entry.getValue();
            SSTableReader.acquireReferences(sstables);
            plan.transferFiles(remote, ranges, sstables);
        }
        StreamResultFuture bulkResult = plan.execute();
        bulkResult.addEventListener(this);
        return bulkResult;
    }

    public void onSuccess(StreamState finalState) {
    }

    public void onFailure(Throwable t) {
    }

    @Override
    public void handleStreamEvent(StreamEvent event) {
        if (event.eventType == StreamEvent.Type.FILE_PROGRESS) {
            ProgressInfo progress = ((StreamEvent.ProgressEvent)event).progress;
            StringBuilder sb = new StringBuilder("\r");
            sb.append(progress.fileName);
            sb.append(": ");
            sb.append(progress.currentBytes).append("/").append(progress.totalBytes);
            System.out.print(sb.toString());
            if (progress.currentBytes == progress.totalBytes) {
                System.out.println();
            }
        } else if (event.eventType == StreamEvent.Type.STREAM_COMPLETE) {
            StreamEvent.SessionCompleteEvent se = (StreamEvent.SessionCompleteEvent)event;
            if (!se.success) {
                this.failedHosts.add(se.peer);
            }
        }
    }

    private String names(Collection<SSTableReader> sstables) {
        StringBuilder builder = new StringBuilder();
        for (SSTableReader sstable : sstables) {
            builder.append(sstable.descriptor.filenameFor(Component.DATA)).append(" ");
        }
        return builder.toString();
    }

    public Set<InetAddress> getFailedHosts() {
        return this.failedHosts;
    }

    static {
        Config.setClientMode(true);
    }

    public static abstract class Client {
        private final Map<InetAddress, Collection<Range<Token>>> endpointToRanges = new HashMap<InetAddress, Collection<Range<Token>>>();
        private IPartitioner partitioner;

        public abstract void init(String var1);

        public void stop() {
        }

        public abstract boolean validateColumnFamily(String var1, String var2);

        public Map<InetAddress, Collection<Range<Token>>> getEndpointToRangesMap() {
            return this.endpointToRanges;
        }

        protected void setPartitioner(String partclass) throws ConfigurationException {
            this.setPartitioner(FBUtilities.newPartitioner(partclass));
        }

        protected void setPartitioner(IPartitioner partitioner) {
            this.partitioner = partitioner;
            DatabaseDescriptor.setPartitioner(partitioner);
        }

        public IPartitioner getPartitioner() {
            return this.partitioner;
        }

        protected void addRangeForEndpoint(Range<Token> range, InetAddress endpoint) {
            Collection<Range<Token>> ranges = this.endpointToRanges.get(endpoint);
            if (ranges == null) {
                ranges = new HashSet<Range<Token>>();
                this.endpointToRanges.put(endpoint, ranges);
            }
            ranges.add(range);
        }
    }
}

