/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.serializers.BooleanSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;

public class BooleanType
extends AbstractType<Boolean> {
    public static final BooleanType instance = new BooleanType();

    BooleanType() {
    }

    @Override
    public Boolean compose(ByteBuffer bytes) {
        return BooleanSerializer.instance.serialize(bytes);
    }

    @Override
    public ByteBuffer decompose(Boolean value) {
        return BooleanSerializer.instance.deserialize(value);
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1 == null || o1.remaining() != 1) {
            return o2 == null || o2.remaining() != 1 ? 0 : -1;
        }
        if (o2 == null || o2.remaining() != 1) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return BooleanSerializer.instance.getString(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty() || source.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return this.decompose(false);
        }
        if (source.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return this.decompose(true);
        }
        throw new MarshalException(String.format("unable to make boolean from '%s'", source));
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        BooleanSerializer.instance.validate(bytes);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.BOOLEAN;
    }

    @Override
    public TypeSerializer<Boolean> getSerializer() {
        return BooleanSerializer.instance;
    }
}

