/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.index.PerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractSimplePerColumnSecondaryIndex
extends PerColumnSecondaryIndex {
    private ColumnFamilyStore indexCfs;

    @Override
    public void init() {
        assert (this.baseCfs != null && this.columnDefs != null && this.columnDefs.size() == 1);
        ColumnDefinition columnDef = (ColumnDefinition)this.columnDefs.iterator().next();
        this.init(columnDef);
        AbstractType<?> indexComparator = SecondaryIndex.getIndexComparator(this.baseCfs.metadata, columnDef);
        CFMetaData indexedCfMetadata = CFMetaData.newIndexMetadata(this.baseCfs.metadata, columnDef, indexComparator);
        this.indexCfs = ColumnFamilyStore.createColumnFamilyStore(this.baseCfs.table, indexedCfMetadata.cfName, new LocalPartitioner(columnDef.getValidator()), indexedCfMetadata);
        CFMetaData.Caching baseCaching = this.baseCfs.metadata.getCaching();
        if (baseCaching == CFMetaData.Caching.ALL || baseCaching == CFMetaData.Caching.ROWS_ONLY) {
            double estimatedKeys = this.indexCfs.estimateKeys();
            double averageColumnCount = this.indexCfs.getMeanColumns();
            if (averageColumnCount > 0.0 && estimatedKeys / averageColumnCount > 1.0) {
                logger.debug("turning row cache on for " + this.indexCfs.getColumnFamilyName());
                this.indexCfs.metadata.caching(baseCaching);
                this.indexCfs.initRowCache();
            }
        }
    }

    protected abstract void init(ColumnDefinition var1);

    protected abstract ByteBuffer makeIndexColumnName(ByteBuffer var1, IColumn var2);

    protected abstract AbstractType getExpressionComparator();

    public String expressionString(IndexExpression expr) {
        return String.format("'%s.%s %s %s'", this.baseCfs.columnFamily, this.getExpressionComparator().getString(expr.column_name), expr.op, this.baseCfs.metadata.getColumn_metadata().get(expr.column_name).getValidator().getString(expr.value));
    }

    @Override
    public void delete(ByteBuffer rowKey, IColumn column) {
        if (column.isMarkedForDelete()) {
            return;
        }
        DecoratedKey valueKey = this.getIndexKeyFor(column.value());
        int localDeletionTime = (int)(System.currentTimeMillis() / 1000L);
        ColumnFamily cfi = ColumnFamily.create(this.indexCfs.metadata);
        ByteBuffer name = this.makeIndexColumnName(rowKey, column);
        assert (name.remaining() > 0 && name.remaining() <= 65535) : name.remaining();
        cfi.addTombstone(name, localDeletionTime, column.timestamp());
        this.indexCfs.apply(valueKey, cfi, SecondaryIndexManager.nullUpdater);
        if (logger.isDebugEnabled()) {
            logger.debug("removed index entry for cleaned-up value {}:{}", (Object)valueKey, (Object)cfi);
        }
    }

    @Override
    public void insert(ByteBuffer rowKey, IColumn column) {
        DecoratedKey valueKey = this.getIndexKeyFor(column.value());
        ColumnFamily cfi = ColumnFamily.create(this.indexCfs.metadata);
        ByteBuffer name = this.makeIndexColumnName(rowKey, column);
        assert (name.remaining() > 0 && name.remaining() <= 65535) : name.remaining();
        if (column instanceof ExpiringColumn) {
            ExpiringColumn ec = (ExpiringColumn)column;
            cfi.addColumn(new ExpiringColumn(name, ByteBufferUtil.EMPTY_BYTE_BUFFER, ec.timestamp(), ec.getTimeToLive(), ec.getLocalDeletionTime()));
        } else {
            cfi.addColumn(new Column(name, ByteBufferUtil.EMPTY_BYTE_BUFFER, column.timestamp()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("applying index row {} in {}", (Object)this.indexCfs.metadata.getKeyValidator().getString(valueKey.key), (Object)cfi);
        }
        this.indexCfs.apply(valueKey, cfi, SecondaryIndexManager.nullUpdater);
    }

    @Override
    public void update(ByteBuffer rowKey, IColumn col) {
        this.insert(rowKey, col);
    }

    @Override
    public void removeIndex(ByteBuffer columnName) {
        this.indexCfs.invalidate();
    }

    @Override
    public void forceBlockingFlush() {
        try {
            this.indexCfs.forceBlockingFlush();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void invalidate() {
        this.indexCfs.invalidate();
    }

    @Override
    public void truncate(long truncatedAt) {
        this.indexCfs.discardSSTables(truncatedAt);
    }

    @Override
    public ColumnFamilyStore getIndexCfs() {
        return this.indexCfs;
    }

    @Override
    public String getIndexName() {
        return this.indexCfs.columnFamily;
    }

    @Override
    public long getLiveSize() {
        return this.indexCfs.getMemtableDataSize();
    }

    @Override
    public void reload() {
        this.indexCfs.metadata.reloadSecondaryIndexMetadata(this.baseCfs.metadata);
        this.indexCfs.reload();
    }
}

