/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.cql3.PropertyDefinitions;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;

public class IndexPropDefs
extends PropertyDefinitions {
    public static final String KW_OPTIONS = "options";
    public static final Set<String> keywords = new HashSet<String>();
    public static final Set<String> obsoleteKeywords = new HashSet<String>();
    public static final String INDEX_CLASS_KEY = "class";

    public void validate(boolean isCustom) throws RequestValidationException {
        this.validate(keywords, obsoleteKeywords);
        if (isCustom && !this.getOptions().containsKey("class_name")) {
            throw new InvalidRequestException(String.format("Custom index requires '%s' option to be specified", INDEX_CLASS_KEY));
        }
        if (!isCustom && !this.getOptions().isEmpty()) {
            throw new InvalidRequestException(String.format("Only custom indexes can currently be parametrized", new Object[0]));
        }
    }

    public Map<String, String> getOptions() throws SyntaxException {
        Map<String, String> options = this.getMap(KW_OPTIONS);
        if (options == null) {
            return Collections.emptyMap();
        }
        if (!options.isEmpty() && options.containsKey(INDEX_CLASS_KEY)) {
            options.put("class_name", options.get(INDEX_CLASS_KEY));
            options.remove(INDEX_CLASS_KEY);
        }
        return options;
    }

    static {
        keywords.add(KW_OPTIONS);
    }
}

