/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.MemoryUsage;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutorMBean;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.service.CacheServiceMBean;
import org.apache.cassandra.service.PBSPredictionResult;
import org.apache.cassandra.service.PBSPredictorMBean;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeToolHelp;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class NodeCmd {
    private static final Pair<String, String> SNAPSHOT_COLUMNFAMILY_OPT = Pair.create("cf", "column-family");
    private static final Pair<String, String> HOST_OPT = Pair.create("h", "host");
    private static final Pair<String, String> PORT_OPT = Pair.create("p", "port");
    private static final Pair<String, String> USERNAME_OPT = Pair.create("u", "username");
    private static final Pair<String, String> PASSWORD_OPT = Pair.create("pw", "password");
    private static final Pair<String, String> TAG_OPT = Pair.create("t", "tag");
    private static final Pair<String, String> TOKENS_OPT = Pair.create("T", "tokens");
    private static final Pair<String, String> PRIMARY_RANGE_OPT = Pair.create("pr", "partitioner-range");
    private static final Pair<String, String> SNAPSHOT_REPAIR_OPT = Pair.create("snapshot", "with-snapshot");
    private static final Pair<String, String> LOCAL_DC_REPAIR_OPT = Pair.create("local", "in-local-dc");
    private static final Pair<String, String> START_TOKEN_OPT = Pair.create("st", "start-token");
    private static final Pair<String, String> END_TOKEN_OPT = Pair.create("et", "end-token");
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 7199;
    private static final ToolOptions options = new ToolOptions();
    private final NodeProbe probe;

    public NodeCmd(NodeProbe probe) {
        this.probe = probe;
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        StringBuilder header = new StringBuilder(512);
        header.append("\nAvailable commands\n");
        NodeToolHelp ntHelp = NodeCmd.loadHelp();
        for (NodeToolHelp.NodeToolCommand cmd : ntHelp.commands) {
            NodeCmd.addCmdHelp(header, cmd);
        }
        String usage = String.format("java %s --host <arg> <command>%n", NodeCmd.class.getName());
        hf.printHelp(usage, "", (Options)options, "");
        System.out.println(header.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NodeToolHelp loadHelp() {
        InputStream is = NodeCmd.class.getClassLoader().getResourceAsStream("org/apache/cassandra/tools/NodeToolHelp.yaml");
        assert (is != null);
        try {
            Constructor constructor = new Constructor(NodeToolHelp.class);
            TypeDescription desc = new TypeDescription(NodeToolHelp.class);
            desc.putListPropertyType("commands", NodeToolHelp.NodeToolCommand.class);
            Yaml yaml = new Yaml(new Loader((BaseConstructor)constructor));
            NodeToolHelp nodeToolHelp = (NodeToolHelp)yaml.load(is);
            return nodeToolHelp;
        }
        finally {
            FileUtils.closeQuietly(is);
        }
    }

    private static void addCmdHelp(StringBuilder sb, NodeToolHelp.NodeToolCommand cmd) {
        sb.append("  ").append(cmd.name);
        if (cmd.name.length() <= 20) {
            for (int i = cmd.name.length(); i < 22; ++i) {
                sb.append(" ");
            }
        }
        sb.append(" - ").append(cmd.help);
    }

    public void printRing(PrintStream outs, String keyspace) {
        boolean keyspaceSelected;
        Map<InetAddress, Float> ownerships;
        Map<String, String> tokensToEndpoints = this.probe.getTokenToEndpointMap();
        LinkedHashMultimap endpointsToTokens = LinkedHashMultimap.create();
        for (Map.Entry<String, String> entry : tokensToEndpoints.entrySet()) {
            endpointsToTokens.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        String format = "%-16s%-12s%-7s%-8s%-16s%-20s%-44s%n";
        try {
            ownerships = this.probe.effectiveOwnership(keyspace);
            keyspaceSelected = true;
        }
        catch (IllegalStateException ex) {
            ownerships = this.probe.getOwnership();
            outs.printf("Note: Ownership information does not include topology; for complete information, specify a keyspace%n", new Object[0]);
            keyspaceSelected = false;
        }
        try {
            outs.println();
            LinkedHashMap perDcOwnerships = Maps.newLinkedHashMap();
            for (Map.Entry<InetAddress, Float> entry : ownerships.entrySet()) {
                String dc = this.probe.getEndpointSnitchInfoProxy().getDatacenter(entry.getKey().getHostAddress());
                if (!perDcOwnerships.containsKey(dc)) {
                    perDcOwnerships.put(dc, new LinkedHashMap());
                }
                ((Map)perDcOwnerships.get(dc)).put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<InetAddress, Float> entry : perDcOwnerships.entrySet()) {
                this.printDc(outs, format, (String)((Object)entry.getKey()), (LinkedHashMultimap<String, String>)endpointsToTokens, keyspaceSelected, (Map)((Object)entry.getValue()));
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private void printDc(PrintStream outs, String format, String dc, LinkedHashMultimap<String, String> endpointsToTokens, boolean keyspaceSelected, Map<InetAddress, Float> filteredOwnerships) {
        List<String> liveNodes = this.probe.getLiveNodes();
        List<String> deadNodes = this.probe.getUnreachableNodes();
        List<String> joiningNodes = this.probe.getJoiningNodes();
        List<String> leavingNodes = this.probe.getLeavingNodes();
        List<String> movingNodes = this.probe.getMovingNodes();
        Map<String, String> loadMap = this.probe.getLoadMap();
        outs.println("Datacenter: " + dc);
        outs.println("==========");
        ArrayList tokens = new ArrayList();
        float totalReplicas = 0.0f;
        String lastToken = "";
        for (Map.Entry<InetAddress, Float> entry : filteredOwnerships.entrySet()) {
            tokens.addAll(endpointsToTokens.get((Object)entry.getKey().getHostAddress()));
            lastToken = (String)tokens.get(tokens.size() - 1);
            totalReplicas += entry.getValue().floatValue();
        }
        if (keyspaceSelected) {
            outs.print("Replicas: " + (int)totalReplicas + "\n\n");
        }
        outs.printf(format, "Address", "Rack", "Status", "State", "Load", "Owns", "Token");
        if (filteredOwnerships.size() > 1) {
            outs.printf(format, "", "", "", "", "", "", lastToken);
        } else {
            outs.println();
        }
        for (Map.Entry<InetAddress, Float> entry : filteredOwnerships.entrySet()) {
            String endpoint = entry.getKey().getHostAddress();
            for (String token : endpointsToTokens.get((Object)endpoint)) {
                String rack;
                try {
                    rack = this.probe.getEndpointSnitchInfoProxy().getRack(endpoint);
                }
                catch (UnknownHostException e) {
                    rack = "Unknown";
                }
                String status = liveNodes.contains(endpoint) ? "Up" : (deadNodes.contains(endpoint) ? "Down" : "?");
                String state = "Normal";
                if (joiningNodes.contains(endpoint)) {
                    state = "Joining";
                } else if (leavingNodes.contains(endpoint)) {
                    state = "Leaving";
                } else if (movingNodes.contains(endpoint)) {
                    state = "Moving";
                }
                String load = loadMap.containsKey(endpoint) ? loadMap.get(endpoint) : "?";
                String owns = new DecimalFormat("##0.00%").format(entry.getValue());
                outs.printf(format, endpoint, rack, status, state, load, owns, token);
            }
        }
        outs.println();
    }

    public void printClusterStatus(PrintStream outs, String keyspace) throws UnknownHostException {
        new ClusterStatus(outs, keyspace).print();
    }

    public void printThreadPoolStats(PrintStream outs) {
        outs.printf("%-25s%10s%10s%15s%10s%18s%n", "Pool Name", "Active", "Pending", "Completed", "Blocked", "All time blocked");
        Iterator<Map.Entry<String, JMXEnabledThreadPoolExecutorMBean>> threads = this.probe.getThreadPoolMBeanProxies();
        while (threads.hasNext()) {
            Map.Entry<String, JMXEnabledThreadPoolExecutorMBean> thread = threads.next();
            String poolName = thread.getKey();
            JMXEnabledThreadPoolExecutorMBean threadPoolProxy = thread.getValue();
            outs.printf("%-25s%10s%10s%15s%10s%18s%n", poolName, threadPoolProxy.getActiveCount(), threadPoolProxy.getPendingTasks(), threadPoolProxy.getCompletedTasks(), threadPoolProxy.getCurrentlyBlockedTasks(), threadPoolProxy.getTotalBlockedTasks());
        }
        outs.printf("%n%-20s%10s%n", "Message type", "Dropped");
        for (Map.Entry<String, Integer> entry : this.probe.getDroppedMessages().entrySet()) {
            outs.printf("%-20s%10s%n", entry.getKey(), entry.getValue());
        }
    }

    public void printInfo(PrintStream outs, ToolCommandLine cmd) {
        boolean gossipInitialized = this.probe.isInitialized();
        List<String> toks = this.probe.getTokens();
        if (toks.size() == 1) {
            outs.printf("%-17s: %s%n", "Token", toks.get(0));
        } else if (!cmd.hasOption((String)NodeCmd.TOKENS_OPT.left)) {
            outs.printf("%-17s: (invoke with -T/--tokens to see all %d tokens)%n", "Token", toks.size());
        }
        outs.printf("%-17s: %s%n", "ID", this.probe.getLocalHostId());
        outs.printf("%-17s: %s%n", "Gossip active", gossipInitialized);
        outs.printf("%-17s: %s%n", "Thrift active", this.probe.isThriftServerRunning());
        outs.printf("%-17s: %s%n", "Load", this.probe.getLoadString());
        if (gossipInitialized) {
            outs.printf("%-17s: %s%n", "Generation No", this.probe.getCurrentGenerationNumber());
        } else {
            outs.printf("%-17s: %s%n", "Generation No", 0);
        }
        long secondsUp = this.probe.getUptime() / 1000L;
        outs.printf("%-17s: %d%n", "Uptime (seconds)", secondsUp);
        MemoryUsage heapUsage = this.probe.getHeapMemoryUsage();
        double memUsed = (double)heapUsage.getUsed() / 1048576.0;
        double memMax = (double)heapUsage.getMax() / 1048576.0;
        outs.printf("%-17s: %.2f / %.2f%n", "Heap Memory (MB)", memUsed, memMax);
        outs.printf("%-17s: %s%n", "Data Center", this.probe.getDataCenter());
        outs.printf("%-17s: %s%n", "Rack", this.probe.getRack());
        outs.printf("%-17s: %s%n", "Exceptions", this.probe.getExceptionCount());
        CacheServiceMBean cacheService = this.probe.getCacheServiceMBean();
        outs.printf("%-17s: size %d (bytes), capacity %d (bytes), %d hits, %d requests, %.3f recent hit rate, %d save period in seconds%n", "Key Cache", cacheService.getKeyCacheSize(), cacheService.getKeyCacheCapacityInBytes(), cacheService.getKeyCacheHits(), cacheService.getKeyCacheRequests(), cacheService.getKeyCacheRecentHitRate(), cacheService.getKeyCacheSavePeriodInSeconds());
        outs.printf("%-17s: size %d (bytes), capacity %d (bytes), %d hits, %d requests, %.3f recent hit rate, %d save period in seconds%n", "Row Cache", cacheService.getRowCacheSize(), cacheService.getRowCacheCapacityInBytes(), cacheService.getRowCacheHits(), cacheService.getRowCacheRequests(), cacheService.getRowCacheRecentHitRate(), cacheService.getRowCacheSavePeriodInSeconds());
        if (toks.size() > 1 && cmd.hasOption((String)NodeCmd.TOKENS_OPT.left)) {
            for (String tok : toks) {
                outs.printf("%-17s: %s%n", "Token", tok);
            }
        }
    }

    public void printReleaseVersion(PrintStream outs) {
        outs.println("ReleaseVersion: " + this.probe.getReleaseVersion());
    }

    public void printNetworkStats(final InetAddress addr, PrintStream outs) {
        List<String> files;
        Set<InetAddress> hosts;
        outs.printf("Mode: %s%n", this.probe.getOperationMode());
        Set<InetAddress> set = hosts = addr == null ? this.probe.getStreamDestinations() : new HashSet<InetAddress>(){
            {
                this.add(addr);
            }
        };
        if (hosts.size() == 0) {
            outs.println("Not sending any streams.");
        }
        for (InetAddress host : hosts) {
            try {
                files = this.probe.getFilesDestinedFor(host);
                if (files.size() > 0) {
                    outs.printf("Streaming to: %s%n", host);
                    for (String file : files) {
                        outs.printf("   %s%n", file);
                    }
                    continue;
                }
                outs.printf(" Nothing streaming to %s%n", host);
            }
            catch (IOException ex) {
                outs.printf("   Error retrieving file data for %s%n", host);
            }
        }
        Set<InetAddress> set2 = hosts = addr == null ? this.probe.getStreamSources() : new HashSet<InetAddress>(){
            {
                this.add(addr);
            }
        };
        if (hosts.size() == 0) {
            outs.println("Not receiving any streams.");
        }
        for (InetAddress host : hosts) {
            try {
                files = this.probe.getIncomingFiles(host);
                if (files.size() > 0) {
                    outs.printf("Streaming from: %s%n", host);
                    for (String file : files) {
                        outs.printf("   %s%n", file);
                    }
                    continue;
                }
                outs.printf(" Nothing streaming from %s%n", host);
            }
            catch (IOException ex) {
                outs.printf("   Error retrieving file data for %s%n", host);
            }
        }
        MessagingServiceMBean ms = this.probe.msProxy;
        outs.printf("%-25s", "Pool Name");
        outs.printf("%10s", "Active");
        outs.printf("%10s", "Pending");
        outs.printf("%15s%n", "Completed");
        int pending = 0;
        Iterator<Number> i$ = ms.getCommandPendingTasks().values().iterator();
        while (i$.hasNext()) {
            int n = i$.next();
            pending += n;
        }
        long completed = 0L;
        i$ = ms.getCommandCompletedTasks().values().iterator();
        while (i$.hasNext()) {
            long n = (Long)i$.next();
            completed += n;
        }
        outs.printf("%-25s%10s%10s%15s%n", "Commands", "n/a", pending, completed);
        pending = 0;
        i$ = ms.getResponsePendingTasks().values().iterator();
        while (i$.hasNext()) {
            int n = (Integer)i$.next();
            pending += n;
        }
        completed = 0L;
        i$ = ms.getResponseCompletedTasks().values().iterator();
        while (i$.hasNext()) {
            long n = (Long)i$.next();
            completed += n;
        }
        outs.printf("%-25s%10s%10s%15s%n", "Responses", "n/a", pending, completed);
    }

    public void printCompactionStats(PrintStream outs) {
        int compactionThroughput = this.probe.getCompactionThroughput();
        CompactionManagerMBean cm = this.probe.getCompactionManagerProxy();
        outs.println("pending tasks: " + cm.getPendingTasks());
        if (cm.getCompactions().size() > 0) {
            outs.printf("%25s%16s%16s%16s%16s%10s%10s%n", "compaction type", "keyspace", "column family", "completed", "total", "unit", "progress");
        }
        long remainingBytes = 0L;
        for (Map<String, String> c : cm.getCompactions()) {
            String percentComplete = new Long(c.get("total")) == 0L ? "n/a" : new DecimalFormat("0.00").format((double)new Long(c.get("completed")).longValue() / (double)new Long(c.get("total")).longValue() * 100.0) + "%";
            outs.printf("%25s%16s%16s%16s%16s%10s%10s%n", c.get("taskType"), c.get("keyspace"), c.get("columnfamily"), c.get("completed"), c.get("total"), c.get("unit"), percentComplete);
            if (!c.get("taskType").equals(OperationType.COMPACTION.toString())) continue;
            remainingBytes += new Long(c.get("total")) - new Long(c.get("completed"));
        }
        long remainingTimeInSecs = compactionThroughput == 0 || remainingBytes == 0L ? -1L : remainingBytes / (0x100000L * (long)compactionThroughput);
        String remainingTime = remainingTimeInSecs < 0L ? "n/a" : String.format("%dh%02dm%02ds", remainingTimeInSecs / 3600L, remainingTimeInSecs % 3600L / 60L, remainingTimeInSecs % 60L);
        outs.printf("%25s%10s%n", "Active compaction remaining time : ", remainingTime);
    }

    public void printColumnFamilyStats(PrintStream outs) {
        ArrayList<ColumnFamilyStoreMBean> columnFamilies;
        HashMap cfstoreMap = new HashMap();
        Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> cfamilies = this.probe.getColumnFamilyStoreMBeanProxies();
        while (cfamilies.hasNext()) {
            Map.Entry<String, ColumnFamilyStoreMBean> entry = cfamilies.next();
            String tableName = entry.getKey();
            ColumnFamilyStoreMBean cfsProxy = entry.getValue();
            if (!cfstoreMap.containsKey(tableName)) {
                columnFamilies = new ArrayList<ColumnFamilyStoreMBean>();
                columnFamilies.add(cfsProxy);
                cfstoreMap.put(tableName, columnFamilies);
                continue;
            }
            ((List)cfstoreMap.get(tableName)).add(cfsProxy);
        }
        for (Map.Entry entry : cfstoreMap.entrySet()) {
            String tableName = (String)entry.getKey();
            columnFamilies = (ArrayList<ColumnFamilyStoreMBean>)entry.getValue();
            long tableReadCount = 0L;
            long tableWriteCount = 0L;
            int tablePendingTasks = 0;
            double tableTotalReadTime = 0.0;
            double tableTotalWriteTime = 0.0;
            outs.println("Keyspace: " + tableName);
            for (ColumnFamilyStoreMBean cfstore : columnFamilies) {
                long writeCount = cfstore.getWriteCount();
                long readCount = cfstore.getReadCount();
                if (readCount > 0L) {
                    tableReadCount += readCount;
                    tableTotalReadTime += (double)cfstore.getTotalReadLatencyMicros();
                }
                if (writeCount > 0L) {
                    tableWriteCount += writeCount;
                    tableTotalWriteTime += (double)cfstore.getTotalWriteLatencyMicros();
                }
                tablePendingTasks += cfstore.getPendingTasks();
            }
            double tableReadLatency = tableReadCount > 0L ? tableTotalReadTime / (double)tableReadCount / 1000.0 : Double.NaN;
            double tableWriteLatency = tableWriteCount > 0L ? tableTotalWriteTime / (double)tableWriteCount / 1000.0 : Double.NaN;
            outs.println("\tRead Count: " + tableReadCount);
            outs.println("\tRead Latency: " + String.format("%s", tableReadLatency) + " ms.");
            outs.println("\tWrite Count: " + tableWriteCount);
            outs.println("\tWrite Latency: " + String.format("%s", tableWriteLatency) + " ms.");
            outs.println("\tPending Tasks: " + tablePendingTasks);
            for (ColumnFamilyStoreMBean cfstore : columnFamilies) {
                String cfName = cfstore.getColumnFamilyName();
                if (cfName.contains(".")) {
                    outs.println("\t\tColumn Family (index): " + cfName);
                } else {
                    outs.println("\t\tColumn Family: " + cfName);
                }
                outs.println("\t\tSSTable count: " + cfstore.getLiveSSTableCount());
                int[] leveledSStables = cfstore.getSSTableCountPerLevel();
                if (leveledSStables != null) {
                    outs.print("\t\tSSTables in each level: [");
                    for (int level = 0; level < leveledSStables.length; ++level) {
                        int count = leveledSStables[level];
                        outs.print(count);
                        long maxCount = 4L;
                        if (level > 0) {
                            maxCount = (long)Math.pow(10.0, level);
                        }
                        if ((long)count > maxCount) {
                            outs.print("/" + maxCount);
                        }
                        if (level < leveledSStables.length - 1) {
                            outs.print(", ");
                            continue;
                        }
                        outs.println("]");
                    }
                }
                outs.println("\t\tSpace used (live): " + cfstore.getLiveDiskSpaceUsed());
                outs.println("\t\tSpace used (total): " + cfstore.getTotalDiskSpaceUsed());
                outs.println("\t\tNumber of Keys (estimate): " + cfstore.estimateKeys());
                outs.println("\t\tMemtable Columns Count: " + cfstore.getMemtableColumnsCount());
                outs.println("\t\tMemtable Data Size: " + cfstore.getMemtableDataSize());
                outs.println("\t\tMemtable Switch Count: " + cfstore.getMemtableSwitchCount());
                outs.println("\t\tRead Count: " + cfstore.getReadCount());
                outs.println("\t\tRead Latency: " + String.format("%01.3f", cfstore.getRecentReadLatencyMicros() / 1000.0) + " ms.");
                outs.println("\t\tWrite Count: " + cfstore.getWriteCount());
                outs.println("\t\tWrite Latency: " + String.format("%01.3f", cfstore.getRecentWriteLatencyMicros() / 1000.0) + " ms.");
                outs.println("\t\tPending Tasks: " + cfstore.getPendingTasks());
                outs.println("\t\tBloom Filter False Positives: " + cfstore.getBloomFilterFalsePositives());
                outs.println("\t\tBloom Filter False Ratio: " + String.format("%01.5f", cfstore.getRecentBloomFilterFalseRatio()));
                outs.println("\t\tBloom Filter Space Used: " + cfstore.getBloomFilterDiskSpaceUsed());
                outs.println("\t\tCompacted row minimum size: " + cfstore.getMinRowSize());
                outs.println("\t\tCompacted row maximum size: " + cfstore.getMaxRowSize());
                outs.println("\t\tCompacted row mean size: " + cfstore.getMeanRowSize());
                outs.println("");
            }
            outs.println("----------------");
        }
    }

    public void printRemovalStatus(PrintStream outs) {
        outs.println("RemovalStatus: " + this.probe.getRemovalStatus());
    }

    private void printCfHistograms(String keySpace, String columnFamily, PrintStream output) {
        ColumnFamilyStoreMBean store = this.probe.getCfsProxy(keySpace, columnFamily);
        long[] offsets = new EstimatedHistogram().getBucketOffsets();
        long[] rrlh = store.getRecentReadLatencyHistogramMicros();
        long[] rwlh = store.getRecentWriteLatencyHistogramMicros();
        long[] sprh = store.getRecentSSTablesPerReadHistogram();
        long[] ersh = store.getEstimatedRowSizeHistogram();
        long[] ecch = store.getEstimatedColumnCountHistogram();
        output.println(String.format("%s/%s histograms", keySpace, columnFamily));
        output.println(String.format("%-10s%10s%18s%18s%18s%18s", "Offset", "SSTables", "Write Latency", "Read Latency", "Row Size", "Column Count"));
        for (int i = 0; i < offsets.length; ++i) {
            output.println(String.format("%-10d%10s%18s%18s%18s%18s", offsets[i], i < sprh.length ? Long.valueOf(sprh[i]) : "0", i < rwlh.length ? Long.valueOf(rwlh[i]) : "0", i < rrlh.length ? Long.valueOf(rrlh[i]) : "0", i < ersh.length ? Long.valueOf(ersh[i]) : "0", i < ecch.length ? Long.valueOf(ecch[i]) : "0"));
        }
    }

    private void printProxyHistograms(PrintStream output) {
        StorageProxyMBean sp = this.probe.getSpProxy();
        long[] offsets = new EstimatedHistogram().getBucketOffsets();
        long[] rrlh = sp.getRecentReadLatencyHistogramMicros();
        long[] rwlh = sp.getRecentWriteLatencyHistogramMicros();
        long[] rrnglh = sp.getRecentRangeLatencyHistogramMicros();
        output.println("proxy histograms");
        output.println(String.format("%-10s%18s%18s%18s", "Offset", "Read Latency", "Write Latency", "Range Latency"));
        for (int i = 0; i < offsets.length; ++i) {
            output.println(String.format("%-10d%18s%18s%18s", offsets[i], i < rrlh.length ? Long.valueOf(rrlh[i]) : "0", i < rwlh.length ? Long.valueOf(rwlh[i]) : "0", i < rrnglh.length ? Long.valueOf(rrnglh[i]) : "0"));
        }
    }

    private void printEndPoints(String keySpace, String cf, String key, PrintStream output) {
        List<InetAddress> endpoints = this.probe.getEndpoints(keySpace, cf, key);
        for (InetAddress anEndpoint : endpoints) {
            output.println(anEndpoint.getHostAddress());
        }
    }

    private void printSSTables(String keyspace, String cf, String key, PrintStream output) {
        List<String> sstables = this.probe.getSSTables(keyspace, cf, key);
        for (String sstable : sstables) {
            output.println(sstable);
        }
    }

    private void printIsThriftServerRunning(PrintStream outs) {
        outs.println(this.probe.isThriftServerRunning() ? "running" : "not running");
    }

    public void predictConsistency(Integer replicationFactor, Integer timeAfterWrite, Integer numVersions, Float percentileLatency, PrintStream output) {
        PBSPredictorMBean predictorMBean = this.probe.getPBSPredictorMBean();
        for (int r = 1; r <= replicationFactor; ++r) {
            for (int w = 1; w <= replicationFactor; ++w) {
                if (w + r > replicationFactor + 1) continue;
                try {
                    PBSPredictionResult result = predictorMBean.doPrediction(replicationFactor, r, w, timeAfterWrite.intValue(), numVersions, percentileLatency.floatValue());
                    if (r == 1 && w == 1) {
                        output.printf("%dms after a given write, with maximum version staleness of k=%d%n", timeAfterWrite, numVersions);
                    }
                    output.printf("N=%d, R=%d, W=%d%n", replicationFactor, r, w);
                    output.printf("Probability of consistent reads: %f%n", Float.valueOf(result.getConsistencyProbability()));
                    output.printf("Average read latency: %fms (%.3fth %%ile %dms)%n", Float.valueOf(result.getAverageReadLatency()), Float.valueOf(result.getPercentileReadLatencyPercentile() * 100.0f), result.getPercentileReadLatencyValue());
                    output.printf("Average write latency: %fms (%.3fth %%ile %dms)%n%n", Float.valueOf(result.getAverageWriteLatency()), Float.valueOf(result.getPercentileWriteLatencyPercentile() * 100.0f), result.getPercentileWriteLatencyValue());
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] args) throws IOException, InterruptedException, ConfigurationException, ParseException {
        parser = new PosixParser();
        cmd = null;
        try {
            cmd = new ToolCommandLine(parser.parse((Options)NodeCmd.options, args));
        }
        catch (ParseException p) {
            NodeCmd.badUse(p.getMessage());
        }
        host = cmd.hasOption((String)NodeCmd.HOST_OPT.left) != false ? cmd.getOptionValue((String)NodeCmd.HOST_OPT.left) : "127.0.0.1";
        port = 7199;
        portNum = cmd.getOptionValue((String)NodeCmd.PORT_OPT.left);
        if (portNum != null) {
            try {
                port = Integer.parseInt(portNum);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Port must be a number");
            }
        }
        username = cmd.getOptionValue((String)NodeCmd.USERNAME_OPT.left);
        password = cmd.getOptionValue((String)NodeCmd.PASSWORD_OPT.left);
        probe = null;
        try {
            probe = username == null ? new NodeProbe(host, port) : new NodeProbe(host, port, username, password);
        }
        catch (IOException ioe) {
            inner = NodeCmd.findInnermostThrowable(ioe);
            if (inner instanceof ConnectException) {
                System.err.printf("Failed to connect to '%s:%d': %s%n", new Object[]{host, port, inner.getMessage()});
                System.exit(1);
            }
            if (inner instanceof UnknownHostException) {
                System.err.printf("Cannot resolve '%s': unknown host%n", new Object[]{host});
                System.exit(1);
            }
            NodeCmd.err(ioe, "Error connecting to remote JMX agent!");
        }
        try {
            command = null;
            try {
                command = cmd.getCommand();
            }
            catch (IllegalArgumentException e) {
                NodeCmd.badUse(e.getMessage());
            }
            nodeCmd = new NodeCmd(probe);
            arguments = cmd.getCommandArguments();
            columnFamilyName = null;
            switch (3.$SwitchMap$org$apache$cassandra$tools$NodeCmd$NodeCommand[command.ordinal()]) {
                case 1: {
                    NodeCmd.printUsage();
                    ** break;
lbl50:
                    // 1 sources

                    break;
                }
                case 2: {
                    if (arguments.length > 0) {
                        nodeCmd.printRing(System.out, arguments[0]);
                        ** break;
lbl55:
                        // 1 sources

                    } else {
                        nodeCmd.printRing(System.out, null);
                        ** break;
                    }
lbl58:
                    // 1 sources

                    break;
                }
                case 3: {
                    nodeCmd.printInfo(System.out, cmd);
                    ** break;
lbl62:
                    // 1 sources

                    break;
                }
                case 4: {
                    nodeCmd.printColumnFamilyStats(System.out);
                    ** break;
lbl66:
                    // 1 sources

                    break;
                }
                case 5: {
                    nodeCmd.printThreadPoolStats(System.out);
                    ** break;
lbl70:
                    // 1 sources

                    break;
                }
                case 6: {
                    nodeCmd.printReleaseVersion(System.out);
                    ** break;
lbl74:
                    // 1 sources

                    break;
                }
                case 7: {
                    nodeCmd.printCompactionStats(System.out);
                    ** break;
lbl78:
                    // 1 sources

                    break;
                }
                case 8: {
                    probe.stopGossiping();
                    ** break;
lbl82:
                    // 1 sources

                    break;
                }
                case 9: {
                    probe.startGossiping();
                    ** break;
lbl86:
                    // 1 sources

                    break;
                }
                case 10: {
                    probe.disableHintedHandoff();
                    ** break;
lbl90:
                    // 1 sources

                    break;
                }
                case 11: {
                    probe.enableHintedHandoff();
                    ** break;
lbl94:
                    // 1 sources

                    break;
                }
                case 12: {
                    probe.pauseHintsDelivery();
                    ** break;
lbl98:
                    // 1 sources

                    break;
                }
                case 13: {
                    probe.resumeHintsDelivery();
                    ** break;
lbl102:
                    // 1 sources

                    break;
                }
                case 14: {
                    probe.stopThriftServer();
                    ** break;
lbl106:
                    // 1 sources

                    break;
                }
                case 15: {
                    probe.startThriftServer();
                    ** break;
lbl110:
                    // 1 sources

                    break;
                }
                case 16: {
                    nodeCmd.printIsThriftServerRunning(System.out);
                    ** break;
lbl114:
                    // 1 sources

                    break;
                }
                case 17: {
                    probe.resetLocalSchema();
                    ** break;
lbl118:
                    // 1 sources

                    break;
                }
                case 18: {
                    if (arguments.length > 0) {
                        nodeCmd.printClusterStatus(System.out, arguments[0]);
                        ** break;
lbl123:
                        // 1 sources

                    } else {
                        nodeCmd.printClusterStatus(System.out, null);
                        ** break;
                    }
lbl126:
                    // 1 sources

                    break;
                }
                case 19: {
                    if (arguments.length > 0) {
                        System.err.println("Decommission will decommission the node you are connected to and does not take arguments!");
                        System.exit(1);
                    }
                    probe.decommission();
                    ** break;
lbl133:
                    // 1 sources

                    break;
                }
                case 20: {
                    try {
                        probe.drain();
                        ** break;
lbl138:
                        // 1 sources

                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occured during flushing");
                        ** break;
                    }
lbl142:
                    // 1 sources

                    break;
                }
                case 21: {
                    if (arguments.length > 0) {
                        nodeCmd.printNetworkStats(InetAddress.getByName(arguments[0]), System.out);
                        ** break;
lbl147:
                        // 1 sources

                    } else {
                        nodeCmd.printNetworkStats(null, System.out);
                        ** break;
                    }
lbl150:
                    // 1 sources

                    break;
                }
                case 22: {
                    columnFamilyName = cmd.getOptionValue((String)NodeCmd.SNAPSHOT_COLUMNFAMILY_OPT.left);
                }
                case 23: {
                    tag = cmd.getOptionValue((String)NodeCmd.TAG_OPT.left);
                    NodeCmd.handleSnapshots(command, tag, arguments, columnFamilyName, probe);
                    ** break;
lbl157:
                    // 1 sources

                    break;
                }
                case 24: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing token argument for move.");
                    }
                    try {
                        probe.move(arguments[0]);
                        ** break;
lbl164:
                        // 1 sources

                    }
                    catch (UnsupportedOperationException uoerror) {
                        System.err.println(uoerror.getMessage());
                        System.exit(1);
                        ** break;
                    }
lbl169:
                    // 1 sources

                    break;
                }
                case 25: {
                    if (probe.isJoined()) {
                        System.err.println("This node has already joined the ring.");
                        System.exit(1);
                    }
                    probe.joinRing();
                    ** break;
lbl176:
                    // 1 sources

                    break;
                }
                case 26: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing value argument.");
                    }
                    probe.setCompactionThroughput(Integer.parseInt(arguments[0]));
                    ** break;
lbl182:
                    // 1 sources

                    break;
                }
                case 27: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing value argument.");
                    }
                    probe.setStreamThroughput(Integer.parseInt(arguments[0]));
                    ** break;
lbl188:
                    // 1 sources

                    break;
                }
                case 28: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing value argument.");
                    }
                    probe.setTraceProbability(Double.parseDouble(arguments[0]));
                    ** break;
lbl194:
                    // 1 sources

                    break;
                }
                case 29: {
                    if (arguments.length > 1) {
                        NodeCmd.badUse("Too many arguments.");
                    }
                    probe.rebuild(arguments.length == 1 ? arguments[0] : null);
                    ** break;
lbl200:
                    // 1 sources

                    break;
                }
                case 30: {
                    System.err.println("Warn: removetoken is deprecated, please use removenode instead");
                }
                case 31: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing an argument for removenode (either status, force, or an ID)");
                        ** break;
lbl207:
                        // 1 sources

                    } else if (arguments[0].equals("status")) {
                        nodeCmd.printRemovalStatus(System.out);
                        ** break;
lbl211:
                        // 1 sources

                    } else if (arguments[0].equals("force")) {
                        nodeCmd.printRemovalStatus(System.out);
                        probe.forceRemoveCompletion();
                        ** break;
lbl216:
                        // 1 sources

                    } else {
                        probe.removeNode(arguments[0]);
                        ** break;
                    }
lbl219:
                    // 1 sources

                    break;
                }
                case 32: {
                    probe.invalidateKeyCache();
                    ** break;
lbl223:
                    // 1 sources

                    break;
                }
                case 33: {
                    probe.invalidateRowCache();
                    ** break;
lbl227:
                    // 1 sources

                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    NodeCmd.optionalKSandCFs(command, cmd, arguments, probe);
                    ** break;
lbl231:
                    // 1 sources

                    break;
                }
                case 40: {
                    if (arguments.length != 2) {
                        NodeCmd.badUse("getcompactionthreshold requires ks and cf args.");
                    }
                    probe.getCompactionThreshold(System.out, arguments[0], arguments[1]);
                    ** break;
lbl237:
                    // 1 sources

                    break;
                }
                case 41: {
                    if (arguments.length != 2) {
                        NodeCmd.badUse("cfhistograms requires ks and cf args");
                    }
                    nodeCmd.printCfHistograms(arguments[0], arguments[1], System.out);
                    ** break;
lbl243:
                    // 1 sources

                    break;
                }
                case 42: {
                    if (arguments.length != 2) {
                        NodeCmd.badUse("setcachecapacity requires key-cache-capacity, and row-cache-capacity args.");
                    }
                    probe.setCacheCapacities(Integer.parseInt(arguments[0]), Integer.parseInt(arguments[1]));
                    ** break;
lbl249:
                    // 1 sources

                    break;
                }
                case 43: {
                    if (arguments.length != 4) {
                        NodeCmd.badUse("setcompactionthreshold requires ks, cf, min, and max threshold args.");
                    }
                    minthreshold = Integer.parseInt(arguments[2]);
                    maxthreshold = Integer.parseInt(arguments[3]);
                    if (minthreshold < 0 || maxthreshold < 0) {
                        NodeCmd.badUse("Thresholds must be positive integers");
                    }
                    if (minthreshold > maxthreshold) {
                        NodeCmd.badUse("Min threshold cannot be greater than max.");
                    }
                    if (minthreshold < 2 && maxthreshold != 0) {
                        NodeCmd.badUse("Min threshold must be at least 2");
                    }
                    probe.setCompactionThreshold(arguments[0], arguments[1], minthreshold, maxthreshold);
                    ** break;
lbl263:
                    // 1 sources

                    break;
                }
                case 44: {
                    if (arguments.length != 3) {
                        NodeCmd.badUse("getendpoints requires ks, cf and key args");
                    }
                    nodeCmd.printEndPoints(arguments[0], arguments[1], arguments[2], System.out);
                    ** break;
lbl269:
                    // 1 sources

                    break;
                }
                case 45: {
                    if (arguments.length != 0) {
                        NodeCmd.badUse("proxyhistograms does not take arguments");
                    }
                    nodeCmd.printProxyHistograms(System.out);
                    ** break;
lbl275:
                    // 1 sources

                    break;
                }
                case 46: {
                    if (arguments.length != 3) {
                        NodeCmd.badUse("getsstables requires ks, cf and key args");
                    }
                    nodeCmd.printSSTables(arguments[0], arguments[1], arguments[2], System.out);
                    ** break;
lbl281:
                    // 1 sources

                    break;
                }
                case 47: {
                    if (arguments.length != 2) {
                        NodeCmd.badUse("load_new_sstables requires ks and cf args");
                    }
                    probe.loadNewSSTables(arguments[0], arguments[1]);
                    ** break;
lbl287:
                    // 1 sources

                    break;
                }
                case 48: {
                    if (arguments.length < 2) {
                        NodeCmd.badUse("rebuild_index requires ks and cf args");
                    }
                    if (arguments.length >= 3) {
                        probe.rebuildIndex(arguments[0], arguments[1], arguments[2].split(","));
                        ** break;
lbl294:
                        // 1 sources

                    } else {
                        probe.rebuildIndex(arguments[0], arguments[1], new String[0]);
                        ** break;
                    }
lbl297:
                    // 1 sources

                    break;
                }
                case 49: {
                    nodeCmd.printGossipInfo(System.out);
                    ** break;
lbl301:
                    // 1 sources

                    break;
                }
                case 50: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("stop requires a type.");
                    }
                    probe.stop(arguments[0].toUpperCase());
                    ** break;
lbl307:
                    // 1 sources

                    break;
                }
                case 51: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing keyspace argument for describering.");
                    }
                    nodeCmd.printDescribeRing(arguments[0], System.out);
                    ** break;
lbl313:
                    // 1 sources

                    break;
                }
                case 52: {
                    nodeCmd.printRangeKeySample(System.out);
                    ** break;
lbl317:
                    // 1 sources

                    break;
                }
                case 53: {
                    if (arguments.length < 2) {
                        NodeCmd.badUse("Requires replication factor and time");
                    }
                    numVersions = 1;
                    if (arguments.length == 3) {
                        numVersions = Integer.parseInt(arguments[2]);
                    }
                    percentileLatency = 0.999f;
                    if (arguments.length == 4) {
                        percentileLatency = Float.parseFloat(arguments[3]);
                    }
                    nodeCmd.predictConsistency(Integer.parseInt(arguments[0]), Integer.parseInt(arguments[1]), numVersions, Float.valueOf(percentileLatency), System.out);
                    ** break;
lbl329:
                    // 1 sources

                    break;
                }
                default: {
                    throw new RuntimeException("Unreachable code.");
                }
            }
        }
        finally {
            if (probe != null) {
                try {
                    probe.close();
                }
                catch (IOException ex) {}
            }
        }
        System.exit(probe.isFailed() != false ? 1 : 0);
    }

    private static Throwable findInnermostThrowable(Throwable ex) {
        Throwable inner = ex.getCause();
        return inner == null ? ex : NodeCmd.findInnermostThrowable(inner);
    }

    private void printDescribeRing(String keyspaceName, PrintStream out) {
        out.println("Schema Version:" + this.probe.getSchemaVersion());
        out.println("TokenRange: ");
        try {
            for (String tokenRangeString : this.probe.describeRing(keyspaceName)) {
                out.println("\t" + tokenRangeString);
            }
        }
        catch (IOException e) {
            NodeCmd.err(e, e.getMessage());
        }
    }

    private void printRangeKeySample(PrintStream outs) {
        outs.println("RangeKeySample: ");
        List<String> tokenStrings = this.probe.sampleKeyRange();
        for (String tokenString : tokenStrings) {
            outs.println("\t" + tokenString);
        }
    }

    private void printGossipInfo(PrintStream out) {
        out.println(this.probe.getGossipInfo());
    }

    private static void badUse(String useStr) {
        System.err.println(useStr);
        NodeCmd.printUsage();
        System.exit(1);
    }

    private static void err(Exception e, String errStr) {
        System.err.println(errStr);
        e.printStackTrace();
        System.exit(3);
    }

    private static void complainNonzeroArgs(String[] args, NodeCommand cmd) {
        if (args.length > 0) {
            System.err.println("Too many arguments for command '" + cmd.toString() + "'.");
            NodeCmd.printUsage();
            System.exit(1);
        }
    }

    private static void handleSnapshots(NodeCommand nc, String tag, String[] cmdArgs, String columnFamily, NodeProbe probe) throws InterruptedException, IOException {
        String[] keyspaces = Arrays.copyOfRange(cmdArgs, 0, cmdArgs.length);
        System.out.print("Requested snapshot for: ");
        if (keyspaces.length > 0) {
            for (int i = 0; i < keyspaces.length; ++i) {
                System.out.print(keyspaces[i] + " ");
            }
        } else {
            System.out.print("all keyspaces ");
        }
        if (columnFamily != null) {
            System.out.print("and column family: " + columnFamily);
        }
        System.out.println();
        switch (nc) {
            case SNAPSHOT: {
                if (tag == null || tag.equals("")) {
                    tag = new Long(System.currentTimeMillis()).toString();
                }
                probe.takeSnapshot(tag, columnFamily, keyspaces);
                System.out.println("Snapshot directory: " + tag);
                break;
            }
            case CLEARSNAPSHOT: {
                probe.clearSnapshot(tag, keyspaces);
            }
        }
    }

    private static void optionalKSandCFs(NodeCommand nc, ToolCommandLine cmd, String[] cmdArgs, NodeProbe probe) throws InterruptedException, IOException {
        List<String> keyspaces = cmdArgs.length == 0 ? probe.getKeyspaces() : Arrays.asList(cmdArgs[0]);
        for (String keyspace : keyspaces) {
            if (probe.getKeyspaces().contains(keyspace)) continue;
            System.err.println("Keyspace [" + keyspace + "] does not exist.");
            System.exit(1);
        }
        for (String keyspace : keyspaces) {
            String[] columnFamilies = cmdArgs.length <= 1 ? new String[]{} : Arrays.copyOfRange(cmdArgs, 1, cmdArgs.length);
            switch (nc) {
                case REPAIR: {
                    boolean snapshot = cmd.hasOption((String)NodeCmd.SNAPSHOT_REPAIR_OPT.left);
                    boolean localDC = cmd.hasOption((String)NodeCmd.LOCAL_DC_REPAIR_OPT.left);
                    boolean primaryRange = cmd.hasOption((String)NodeCmd.PRIMARY_RANGE_OPT.left);
                    if (cmd.hasOption((String)NodeCmd.START_TOKEN_OPT.left) || cmd.hasOption((String)NodeCmd.END_TOKEN_OPT.left)) {
                        probe.forceRepairRangeAsync(System.out, keyspace, snapshot, localDC, cmd.getOptionValue((String)NodeCmd.START_TOKEN_OPT.left), cmd.getOptionValue((String)NodeCmd.END_TOKEN_OPT.left), columnFamilies);
                        break;
                    }
                    probe.forceRepairAsync(System.out, keyspace, snapshot, localDC, primaryRange, columnFamilies);
                    break;
                }
                case FLUSH: {
                    try {
                        probe.forceTableFlush(keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occurred during flushing");
                    }
                    break;
                }
                case COMPACT: {
                    try {
                        probe.forceTableCompaction(keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occurred during compaction");
                    }
                    break;
                }
                case CLEANUP: {
                    if (keyspace.equals("system")) break;
                    try {
                        probe.forceTableCleanup(keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occurred during cleanup");
                    }
                    break;
                }
                case SCRUB: {
                    try {
                        probe.scrub(keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occurred while scrubbing keyspace " + keyspace);
                    }
                    break;
                }
                case UPGRADESSTABLES: {
                    try {
                        probe.upgradeSSTables(keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occurred while upgrading the sstables for keyspace " + keyspace);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unreachable code.");
                }
            }
        }
    }

    static {
        options.addOption(SNAPSHOT_COLUMNFAMILY_OPT, true, "only take a snapshot of the specified column family");
        options.addOption(HOST_OPT, true, "node hostname or ip address");
        options.addOption(PORT_OPT, true, "remote jmx agent port number");
        options.addOption(USERNAME_OPT, true, "remote jmx agent username");
        options.addOption(PASSWORD_OPT, true, "remote jmx agent password");
        options.addOption(TAG_OPT, true, "optional name to give a snapshot");
        options.addOption(TOKENS_OPT, false, "display all tokens");
        options.addOption(PRIMARY_RANGE_OPT, false, "only repair the first range returned by the partitioner for the node");
        options.addOption(SNAPSHOT_REPAIR_OPT, false, "repair one node at a time using snapshots");
        options.addOption(LOCAL_DC_REPAIR_OPT, false, "only repair against nodes in the same datacenter");
        options.addOption(START_TOKEN_OPT, true, "token at which repair range starts");
        options.addOption(END_TOKEN_OPT, true, "token at which repair range ends");
    }

    private static class ToolCommandLine {
        private final CommandLine commandLine;

        public ToolCommandLine(CommandLine commands) {
            this.commandLine = commands;
        }

        public Option[] getOptions() {
            return this.commandLine.getOptions();
        }

        public boolean hasOption(String opt) {
            return this.commandLine.hasOption(opt);
        }

        public String getOptionValue(String opt) {
            return this.commandLine.getOptionValue(opt);
        }

        public NodeCommand getCommand() {
            if (this.commandLine.getArgs().length == 0) {
                throw new IllegalArgumentException("Command was not specified.");
            }
            String command = this.commandLine.getArgs()[0];
            try {
                return NodeCommand.valueOf(command.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unrecognized command: " + command);
            }
        }

        public String[] getCommandArguments() {
            List params = this.commandLine.getArgList();
            if (params.size() < 2) {
                return new String[0];
            }
            String[] toReturn = new String[params.size() - 1];
            for (int i = 1; i < params.size(); ++i) {
                String parm = (String)params.get(i);
                if (parm.startsWith("\\")) {
                    parm = parm.substring(1);
                }
                toReturn[i - 1] = parm;
            }
            return toReturn;
        }
    }

    private static class ToolOptions
    extends Options {
        private ToolOptions() {
        }

        public void addOption(Pair<String, String> opts, boolean hasArgument, String description) {
            this.addOption(opts, hasArgument, description, false);
        }

        public void addOption(Pair<String, String> opts, boolean hasArgument, String description, boolean required) {
            this.addOption((String)opts.left, (String)opts.right, hasArgument, description, required);
        }

        public void addOption(String opt, String longOpt, boolean hasArgument, String description, boolean required) {
            Option option = new Option(opt, longOpt, hasArgument, description);
            option.setRequired(required);
            this.addOption(option);
        }
    }

    private class ClusterStatus {
        String kSpace = null;
        String format = null;
        Collection<String> joiningNodes;
        Collection<String> leavingNodes;
        Collection<String> movingNodes;
        Collection<String> liveNodes;
        Collection<String> unreachableNodes;
        Map<String, String> loadMap;
        Map<String, String> hostIDMap;
        Map<String, String> tokensToEndpoints;
        EndpointSnitchInfoMBean epSnitchInfo;
        PrintStream outs;

        ClusterStatus(PrintStream outs, String kSpace) {
            this.kSpace = kSpace;
            this.outs = outs;
            this.joiningNodes = NodeCmd.this.probe.getJoiningNodes();
            this.leavingNodes = NodeCmd.this.probe.getLeavingNodes();
            this.movingNodes = NodeCmd.this.probe.getMovingNodes();
            this.loadMap = NodeCmd.this.probe.getLoadMap();
            this.tokensToEndpoints = NodeCmd.this.probe.getTokenToEndpointMap();
            this.liveNodes = NodeCmd.this.probe.getLiveNodes();
            this.unreachableNodes = NodeCmd.this.probe.getUnreachableNodes();
            this.hostIDMap = NodeCmd.this.probe.getHostIdMap();
            this.epSnitchInfo = NodeCmd.this.probe.getEndpointSnitchInfoProxy();
        }

        private void printStatusLegend() {
            this.outs.println("Status=Up/Down");
            this.outs.println("|/ State=Normal/Leaving/Joining/Moving");
        }

        private Map<String, Map<InetAddress, Float>> getOwnershipByDc(Map<InetAddress, Float> ownerships) throws UnknownHostException {
            LinkedHashMap ownershipByDc = Maps.newLinkedHashMap();
            EndpointSnitchInfoMBean epSnitchInfo = NodeCmd.this.probe.getEndpointSnitchInfoProxy();
            for (Map.Entry<InetAddress, Float> ownership : ownerships.entrySet()) {
                String dc = epSnitchInfo.getDatacenter(ownership.getKey().getHostAddress());
                if (!ownershipByDc.containsKey(dc)) {
                    ownershipByDc.put(dc, new LinkedHashMap());
                }
                ((Map)ownershipByDc.get(dc)).put(ownership.getKey(), ownership.getValue());
            }
            return ownershipByDc;
        }

        private String getFormat(boolean hasEffectiveOwns, boolean isTokenPerNode) {
            if (this.format == null) {
                StringBuffer buf = new StringBuffer();
                buf.append("%s%s  %-16s  %-9s  ");
                if (!isTokenPerNode) {
                    buf.append("%-6s  ");
                }
                if (hasEffectiveOwns) {
                    buf.append("%-16s  ");
                } else {
                    buf.append("%-5s  ");
                }
                buf.append("%-36s  ");
                if (isTokenPerNode) {
                    buf.append("%-39s  ");
                }
                buf.append("%s%n");
                this.format = buf.toString();
            }
            return this.format;
        }

        private void printNode(String endpoint, Float owns, Map<InetAddress, Float> ownerships, boolean hasEffectiveOwns, boolean isTokenPerNode) throws UnknownHostException {
            String fmt = this.getFormat(hasEffectiveOwns, isTokenPerNode);
            String status = this.liveNodes.contains(endpoint) ? "U" : (this.unreachableNodes.contains(endpoint) ? "D" : "?");
            String state = this.joiningNodes.contains(endpoint) ? "J" : (this.leavingNodes.contains(endpoint) ? "L" : (this.movingNodes.contains(endpoint) ? "M" : "N"));
            String load = this.loadMap.containsKey(endpoint) ? this.loadMap.get(endpoint) : "?";
            String strOwns = new DecimalFormat("##0.0%").format(ownerships.get(InetAddress.getByName(endpoint)));
            String hostID = this.hostIDMap.get(endpoint);
            String rack = this.epSnitchInfo.getRack(endpoint);
            if (isTokenPerNode) {
                this.outs.printf(fmt, status, state, endpoint, load, strOwns, hostID, NodeCmd.this.probe.getTokens(endpoint).get(0), rack);
            } else {
                int tokens = NodeCmd.this.probe.getTokens(endpoint).size();
                this.outs.printf(fmt, status, state, endpoint, load, tokens, strOwns, hostID, rack);
            }
        }

        private void printNodesHeader(boolean hasEffectiveOwns, boolean isTokenPerNode) {
            String owns;
            String fmt = this.getFormat(hasEffectiveOwns, isTokenPerNode);
            String string = owns = hasEffectiveOwns ? "Owns (effective)" : "Owns";
            if (isTokenPerNode) {
                this.outs.printf(fmt, "-", "-", "Address", "Load", owns, "Host ID", "Token", "Rack");
            } else {
                this.outs.printf(fmt, "-", "-", "Address", "Load", "Tokens", owns, "Host ID", "Rack");
            }
        }

        void print() throws UnknownHostException {
            Map<InetAddress, Float> ownerships;
            boolean hasEffectiveOwns = false;
            boolean isTokenPerNode = true;
            try {
                ownerships = NodeCmd.this.probe.effectiveOwnership(this.kSpace);
                hasEffectiveOwns = true;
            }
            catch (IllegalStateException e) {
                ownerships = NodeCmd.this.probe.getOwnership();
            }
            if (new HashSet<String>(this.tokensToEndpoints.values()).size() < this.tokensToEndpoints.keySet().size()) {
                isTokenPerNode = false;
            }
            for (Map.Entry<String, Map<InetAddress, Float>> dc : this.getOwnershipByDc(ownerships).entrySet()) {
                String dcHeader = String.format("Datacenter: %s%n", dc.getKey());
                this.outs.printf(dcHeader, new Object[0]);
                for (int i = 0; i < dcHeader.length() - 1; ++i) {
                    this.outs.print('=');
                }
                this.outs.println();
                this.printStatusLegend();
                this.printNodesHeader(hasEffectiveOwns, isTokenPerNode);
                for (Map.Entry<InetAddress, Float> entry : dc.getValue().entrySet()) {
                    this.printNode(entry.getKey().getHostAddress(), entry.getValue(), ownerships, hasEffectiveOwns, isTokenPerNode);
                }
            }
        }
    }

    private static enum NodeCommand {
        CFHISTOGRAMS,
        CFSTATS,
        CLEANUP,
        CLEARSNAPSHOT,
        COMPACT,
        COMPACTIONSTATS,
        DECOMMISSION,
        DISABLEGOSSIP,
        DISABLEHANDOFF,
        DISABLETHRIFT,
        DRAIN,
        ENABLEGOSSIP,
        ENABLEHANDOFF,
        ENABLETHRIFT,
        FLUSH,
        GETCOMPACTIONTHRESHOLD,
        GETENDPOINTS,
        GETSSTABLES,
        GOSSIPINFO,
        HELP,
        INFO,
        INVALIDATEKEYCACHE,
        INVALIDATEROWCACHE,
        JOIN,
        MOVE,
        NETSTATS,
        PAUSEHANDOFF,
        PROXYHISTOGRAMS,
        REBUILD,
        REFRESH,
        REMOVETOKEN,
        REMOVENODE,
        REPAIR,
        RESUMEHANDOFF,
        RING,
        SCRUB,
        SETCACHECAPACITY,
        SETCOMPACTIONTHRESHOLD,
        SETCOMPACTIONTHROUGHPUT,
        SETSTREAMTHROUGHPUT,
        SETTRACEPROBABILITY,
        SNAPSHOT,
        STATUS,
        STATUSTHRIFT,
        STOP,
        TPSTATS,
        UPGRADESSTABLES,
        VERSION,
        DESCRIBERING,
        RANGEKEYSAMPLE,
        REBUILD_INDEX,
        RESETLOCALSCHEMA,
        PREDICTCONSISTENCY;

    }
}

